<?php

namespace App\Http\Controllers\Api\V1;

use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class MapApiController extends Controller
{
    private string $apiKey = 'AIzaSyAy4JOunAVgrk4dJN_R8yX7nvLpqvzQJUQ';

    public function placeApiAutocomplete(Request $request): mixed
    {
        $validator = Validator::make($request->all(), [
            'search_text' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 422);
        }

        $url = 'https://places.googleapis.com/v1/places:autocomplete';
        $data = [
            'input' => $request->input('search_text'),
        ];

        $headers = [
            'Content-Type' => 'application/json',
            'X-Goog-Api-Key' => $this->AIzaSyAy4JOunAVgrk4dJN_R8yX7nvLpqvzQJUQ ,
            'X-Goog-FieldMask' => '*',
        ];

        $response = Http::withHeaders($headers)->post($url, $data);
        return $response->json();
    }

    public function distanceApi(Request $request): mixed
    {
        $validator = Validator::make($request->all(), [
            'origin_lat' => 'required',
            'origin_lng' => 'required',
            'destination_lat' => 'required',
            'destination_lng' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 422);
        }

        $url = 'https://routes.googleapis.com/distanceMatrix/v2:computeRouteMatrix';

        $origin = [
            "waypoint" => [
                "location" => [
                    "latLng" => [
                        "latitude" =>  $request['origin_lat'],
                        "longitude" => $request['origin_lng']
                    ]
                ]
            ]
        ];

        $destination = [
            "waypoint" => [
                "location" => [
                    "latLng" => [
                        "latitude" => $request['destination_lat'],
                        "longitude" => $request['destination_lng']
                    ]
                ]
            ]
        ];

        $data = [
            "origins" => [$origin],
            "destinations" => [$destination],
            "travelMode" => "DRIVE",
            "routingPreference" => "TRAFFIC_AWARE"
        ];

        $headers = [
            'Content-Type' => 'application/json',
            'X-Goog-Api-Key' => $this->AIzaSyAy4JOunAVgrk4dJN_R8yX7nvLpqvzQJUQ ,
            'X-Goog-FieldMask' => '*'
        ];

        $response = Http::withHeaders($headers)->post($url, $data);
        return $response->json();
    }

    public function placeApiDetails(Request $request): mixed
    {
        $validator = Validator::make($request->all(), [
            'placeid' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 422);
        }

        $url = 'https://places.googleapis.com/v1/places/' . $request['placeid'];

        $headers = [
            'Content-Type' => 'application/json',
            'X-Goog-Api-Key' => $this->AIzaSyAy4JOunAVgrk4dJN_R8yX7nvLpqvzQJUQ ,
            'X-Goog-FieldMask' => '*',
        ];

        $response = Http::withHeaders($headers)->get($url);
        return $response->json();
    }

    public function geocodeApi(Request $request): mixed
    {
        $validator = Validator::make($request->all(), [
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 422);
        }

        $latlng = $request->lat . ',' . $request->lng;
        $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng={$latlng}&key={$this->AIzaSyAy4JOunAVgrk4dJN_R8yX7nvLpqvzQJUQ}";

        $response = Http::get($url);
        return $response->json();
        
        
    }
}
