<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DMSelfRegistration extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    protected $status;
    protected $name;

    public function __construct($status, $name)
    {
        $this->status = $status;
        $this->name = $name;
    }

    /**
     * @return DMSelfRegistration
     */
    public function build()
    {
        $status = $this->status;
        $name = $this->name;
        return $this->view('email-templates.dm-self-registration', ['status' => $status, 'name' => $name]);
    }
}
