<?php $__env->startSection('title', translate('POS')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .add-customer-modal{
            display: none;
        }
        #location_map_div .overflow-hidden{
            height: 200px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
        <div class="content container-fluid">
            <div class="d-flex flex-wrap">
                <div class="order--pos-left">
                    <div class="card">
                        <div class="card-header m-1 bg-light border-0">
                            <h5 class="card-title">
                                <span>
                                    <?php echo e(translate('Product section')); ?>

                            </span>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-sm-6">
                                    <div class="input-group header-item">
                                        <select name="category" id="category" class="form-control js-select2-custom mx-1" title="<?php echo e(translate('select category')); ?>">
                                            <option value=""><?php echo e(translate('All Categories')); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>" <?php echo e($category == $item->id ? 'selected' : ''); ?>><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <form id="search-form">
                                        <div class="input-group input-group-merge input-group-flush">
                                            <div class="input-group-prepend w--30 justify-content-center">
                                                <div class="input-group-text">
                                                    <i class="tio-search"></i>
                                                </div>
                                            </div>
                                            <input id="datatableSearch" type="search" value="<?php echo e($keyword?$keyword:''); ?>" name="search"  class="form-control rounded border" placeholder="<?php echo e(translate('Search by product name')); ?>" aria-label="<?php echo e(translate('Search here')); ?>">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div id="items">
                                <div class="row g-1">
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="order--item-box item-box">
                                            <?php echo $__env->make('branch-views.pos._single_product',['product'=>$product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="pt-4">
                                <?php echo $products->withQueryString()->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="order--pos-right">
                    <div class="card">
                        <div class="card-header bg-light border-0 m-1">
                            <h5 class="card-title">
                                <span>
                                    <?php echo e(translate('Billing section')); ?>

                                </span>
                            </h5>
                        </div>
                        <div class="card-body p-0">
                            <div class="px-4">
                                <div class="d-flex flex-wrap flex-row py-2 add--customer-btn">
                                    <select id="customer" name="customer_id" data-placeholder="<?php echo e(translate('Walk In Customer')); ?>" class="js-data-example-ajax form-control">
                                        <option selected disabled><?php echo e(translate('select customer')); ?></option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user['id']); ?>" <?php echo e(session('customer_id') == $user['id'] ? 'selected' : ''); ?>><?php echo e($user['f_name'].' '.$user['l_name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <button class="btn btn--primary rounded font-regular" data-toggle="modal" data-target="#add-customer" type="button"><?php echo e(translate('Add New Customer')); ?></button>
                                </div>
                                <div class="w-100 py-2">
                                    <div class="form-group">
                                        <label class="input-label font-weight-semibold fz-16 text-dark"><?php echo e(translate('Select Order Type')); ?></label>
                                        <div>
                                            <div class="form-control d-flex flex-column-3">
                                                <label class="custom-radio d-flex gap-2 align-items-center m-0">
                                                    <input type="radio" class="order-type-radio" name="order_type" value="take_away" <?php echo e(!session()->has('order_type') || session()->get('order_type') == 'take_away' ? 'checked' : ''); ?>>
                                                    <span class="media align-items-center mb-0">
                                                        <span class="media-body ml-1"><?php echo e(translate('Take Away')); ?></span>
                                                    </span>
                                                </label>
                                                <label class="custom-radio d-flex gap-2 align-items-center m-0 ml-3">
                                                    <input type="radio" class="order-type-radio" name="order_type" value="home_delivery" <?php echo e(session()->has('order_type') && session()->get('order_type') == 'home_delivery' ? 'checked' : ''); ?>>
                                                    <span class="media align-items-center mb-0">
                                                        <span class="media-body ml-1"><?php echo e(translate('Home Delivery')); ?></span>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="w-100 py-2">
                                    <div class="form-group d-none" id="home_delivery_section">
                                        <div class="d-flex justify-content-between">
                                            <label for="" class="font-weight-semibold fz-16 text-dark"><?php echo e(translate('Delivery Information')); ?>

                                                <small>(<?php echo e(translate('Home Delivery')); ?>)</small>
                                            </label>
                                            <span class="edit-btn cursor-pointer" id="delivery_address" data-toggle="modal"
                                                  data-target="#AddressModal"><i class="tio-edit"></i>
                                        </span>
                                        </div>
                                        <div class="pos--delivery-options-info d-flex flex-wrap" id="del-add">
                                            <?php echo $__env->make('admin-views.pos._address', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class='w-100' id="cart">
                                    <?php echo $__env->make('branch-views.pos._cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
				</div>
			</div>
		</div>

    <div class="modal no-scrolling fade" id="quick-view" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content" id="quick-view-modal">

            </div>
        </div>
    </div>

    <?php ($order=\App\Model\Order::find(session('last_order'))); ?>
    <?php if($order): ?>
    <?php (session(['last_order'=> false])); ?>
    <div class="modal fade" id="print-invoice" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(translate('Print Invoice')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center">
                        <input id="printButton" type="button" class="btn btn-primary non-printable" value="<?php echo e(translate('Proceed, If thermal printer is ready.')); ?>" />
                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger non-printable"><?php echo e(translate('Back')); ?></a>
                    </div>
                    <hr class="non-printable">
                    <div class="row m-auto" id="printableArea">
                        <?php echo $__env->make('branch-views.pos.order.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

        <div class="modal fade add-customer-modal" id="add-customer">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(translate('Add new customer')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('branch.pos.customer.store')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12 col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('First name')); ?> <span class="input-label-secondary text-danger">*</span></label>
                                        <input type="text" name="f_name" class="form-control" value="" placeholder="<?php echo e(translate('First name')); ?>" required="">
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Last name')); ?> <span class="input-label-secondary text-danger">*</span></label>
                                        <input type="text" name="l_name" class="form-control" value="" placeholder="<?php echo e(translate('Last name')); ?>" required="">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Email')); ?><span class="input-label-secondary text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control" value="" placeholder="<?php echo e(translate('Ex : ex@example.com')); ?>" required="">
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Phone (With country code)')); ?><span class="input-label-secondary text-danger">*</span></label>
                                        <input type="text" name="phone" class="form-control" value="" placeholder="<?php echo e(translate('Phone')); ?>" required="">
                                    </div>
                                </div>
                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('Reset')); ?></button>
                                <button type="submit" id="submit_new_customer" class="btn btn--primary"><?php echo e(translate('Submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="AddressModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-light border-bottom py-3">
                        <h5 class="modal-title flex-grow-1 text-center"><?php echo e(translate('Delivery Information')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <?php
                        if(session()->has('address')) {
                            $old = session()->get('address');
                        }else {
                            $old = null;
                        }
                        ?>
                        <form id='delivery_address_store'>
                            <?php echo csrf_field(); ?>

                            <div class="row g-2" id="delivery_address">
                                <div class="col-md-6">
                                    <label class="input-label" for=""><?php echo e(translate('contact_person_name')); ?>

                                        <span class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" class="form-control" name="contact_person_name"
                                           value="<?php echo e($old ? $old['contact_person_name'] : ''); ?>" placeholder="<?php echo e(translate('Ex :')); ?> <?php echo e(translate('Jhon')); ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="input-label" for=""><?php echo e(translate('Contact Number')); ?>

                                        <span class="input-label-secondary text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="contact_person_number"
                                           value="<?php echo e($old ? $old['contact_person_number'] : ''); ?>"  placeholder="<?php echo e(translate('Ex :')); ?> +3264124565" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="input-label" for=""><?php echo e(translate('Road')); ?></label>
                                    <input type="text" class="form-control" name="road" value="<?php echo e($old ? $old['road'] : ''); ?>"  placeholder="<?php echo e(translate('Ex :')); ?> 4th">
                                </div>
                                <div class="col-md-4">
                                    <label class="input-label" for=""><?php echo e(translate('House')); ?></label>
                                    <input type="text" class="form-control" name="house" value="<?php echo e($old ? $old['house'] : ''); ?>" placeholder="<?php echo e(translate('Ex :')); ?> 45/C">
                                </div>
                                <div class="col-md-4">
                                    <label class="input-label" for=""><?php echo e(translate('Floor')); ?></label>
                                    <input type="text" class="form-control" name="floor" value="<?php echo e($old ? $old['floor'] : ''); ?>"  placeholder="<?php echo e(translate('Ex :')); ?> 1A">
                                </div>
                                <div class="col-md-12">
                                    <label class="input-label"><?php echo e(translate('address')); ?></label>
                                    <textarea name="address" id="address" class="form-control" required><?php echo e($old ? $old['address'] : ''); ?></textarea>
                                </div>

                                <?php
                                    $branchId =(int) auth('branch')->id();
                                    $branch = \App\Model\Branch::with(['delivery_charge_setup', 'delivery_charge_by_area'])
                                        ->where(['id' => $branchId])
                                        ->first(['id', 'name', 'status']);

                                    $deliveryType = $branch->delivery_charge_setup->delivery_charge_type ?? 'fixed';
                                    $deliveryType = $deliveryType == 'area' ? 'area' : ($deliveryType == 'distance' ? 'distance' : 'fixed');

                                    if (isset($branch->delivery_charge_setup) && $branch->delivery_charge_setup->delivery_charge_type == 'distance') {
                                        unset($branch->delivery_charge_by_area);
                                        $branch->delivery_charge_by_area = [];
                                    }
                                ?>

                                <?php ($googleMapStatus = \App\CentralLogics\Helpers::get_business_settings('google_map_status')); ?>
                                <?php if($googleMapStatus): ?>
                                    <?php if($deliveryType == 'distance'): ?>
                                        <div class="col-md-6">
                                            <label class="input-label" for=""><?php echo e(translate('longitude')); ?><span
                                                    class="input-label-secondary text-danger">*</span></label>
                                            <input type="text" class="form-control" id="longitude" name="longitude"
                                                   value="<?php echo e($old ? $old['longitude'] : ''); ?>" readonly required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="input-label" for=""><?php echo e(translate('latitude')); ?><span
                                                    class="input-label-secondary text-danger">*</span></label>
                                            <input type="text" class="form-control" id="latitude" name="latitude"
                                                   value="<?php echo e($old ? $old['latitude'] : ''); ?>" readonly required>
                                        </div>

                                        <div class="col-12">
                                            <div class="d-flex justify-content-between">
                                                <span class="text-primary">
                                                    <?php echo e(translate('* pin the address in the map to calculate delivery fee')); ?>

                                                </span>
                                            </div>
                                            <div id="location_map_div">
                                                <input id="pac-input" class="controls rounded initial-8"
                                                       title="<?php echo e(translate('search_your_location_here')); ?>" type="text"
                                                       placeholder="<?php echo e(translate('search_here')); ?>" />
                                                <div id="location_map_canvas" class="overflow-hidden rounded"></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if($deliveryType == 'area'): ?>
                                    <div class="col-md-6">
                                        <label class="input-label"><?php echo e(translate('Delivery Area')); ?></label>
                                        <select name="selected_area_id" class="form-control js-select2-custom-x mx-1" id="areaDropdown" >
                                            <option value=""><?php echo e(translate('Select Area')); ?></option>
                                            <?php $__currentLoopData = $branch->delivery_charge_by_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($area['id']); ?>" <?php echo e((isset($old) && $old['area_id'] == $area['id']) ? 'selected' : ''); ?> data-charge="<?php echo e($area['delivery_charge']); ?>" ><?php echo e($area['area_name']); ?> - (<?php echo e(Helpers::set_symbol($area['delivery_charge'])); ?>)</option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="input-label" for=""><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                        <input type="number" class="form-control" name="delivery_charge" id="deliveryChargeInput" value="" readonly>
                                    </div>
                                <?php endif; ?>

                            </div>
                            <div class="col-md-12 mt-2">
                                <div class="btn--container justify-content-end">
                                    <button id="updateDeliveryAddressButton" class="btn btn-sm btn--primary w-100" type="button" data-dismiss="modal">
                                        <?php echo e(translate('Update')); ?> <?php echo e(translate('Delivery address')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

<script>

    $('#category').on('change', function() {
        var selectedCategoryId = $(this).val();
        set_category_filter(selectedCategoryId);
    });

    $('#customer').on('change', function() {
        var customerId = $(this).val();
        store_key('customer_id', customerId);
    });


    $('#updateDeliveryAddressButton').on('click', function() {
        deliveryAdressStore();
    });

    $('.order-type-radio').on('change', function() {
        var orderType = $(this).val();
        select_order_type(orderType);
    });

    $('.product-card-clickable').on('click', function() {
        var productId = $(this).data('product-id');
        quickView(productId);
    });

    $(document).on('ready', function () {
        <?php if($order): ?>
        $('#print-invoice').modal('show');
        <?php endif; ?>
    });


    $('#printButton').on('click', function() {
        printDiv('printableArea');
    });

    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
        location.reload();
    }

    function set_category_filter(id) {
        var nurl = new URL('<?php echo url()->full(); ?>');
        nurl.searchParams.set('category_id', id);
        location.href = nurl;
    }


    $('#search-form').on('submit', function (e) {
        e.preventDefault();
        var keyword= $('#datatableSearch').val();
        var nurl = new URL('<?php echo url()->full(); ?>');
        nurl.searchParams.set('keyword', keyword);
        location.href = nurl;
    });

    function quickView(product_id) {
        $.ajax({
            url: '<?php echo e(route('branch.pos.quick-view')); ?>',
            type: 'GET',
            data: {
                product_id: product_id
            },
            dataType: 'json', // added data type
            beforeSend: function () {
                $('#loading').show();
            },
            success: function (data) {
                $('#quick-view').modal('show');
                $('#quick-view-modal').empty().html(data.view);
            },
            complete: function () {
                $('#loading').hide();
            },
        });
    }

    function checkAddToCartValidity() {

        return true;
    }

    function cartQuantityInitialize() {
        $('.btn-number').click(function (e) {
            e.preventDefault();

            var fieldName = $(this).attr('data-field');
            var type = $(this).attr('data-type');
            var input = $("input[name='" + fieldName + "']");
            var currentVal = parseInt(input.val());

            if (!isNaN(currentVal)) {
                if (type == 'minus') {

                    if (currentVal > input.attr('min')) {
                        input.val(currentVal - 1).change();
                    }
                    if (parseInt(input.val()) == input.attr('min')) {
                        $(this).attr('disabled', true);
                    }

                } else if (type == 'plus') {

                    var qty_initial_max_val = parseInt($('#check_max_qty').val());

                    if (currentVal + 1 > qty_initial_max_val) {
                        $('.stock-validation-message').html('There isn’t enough quantity on stock. only ' + qty_initial_max_val +' items are available.');
                        showWarningPopup();

                        input.val(qty_initial_max_val).change();
                    } else {
                        if (currentVal < input.attr('max')) {
                            input.val(currentVal + 1).change();
                        }
                    }
                }
            } else {
                input.val(0);
            }
        });

        $('.input-number').focusin(function () {
            $(this).data('oldValue', $(this).val());
        });

        $('.input-number').change(function () {

            minValue = parseInt($(this).attr('min'));
            maxValue = parseInt($(this).attr('max'));
            valueCurrent = parseInt($(this).val());

            var input_initial_max_val = parseInt($('#check_max_qty').val());
            var input_qty_max_val = input_initial_max_val + 1;

            var name = $(this).attr('name');

            if (valueCurrent >= minValue) {
                $(".btn-number[data-type='minus'][data-field='" + name + "']").removeAttr('disabled');
            } else {
                $('.stock-validation-message').html('Sorry, the minimum value was reached');
                showWarningPopup();
                $(this).val($(this).data('oldValue'));
            }

            if(valueCurrent >= input_qty_max_val){
                $('.stock-validation-message').html('There isn’t enough quantity on stock. only ' + input_initial_max_val +' items are available.');
                showWarningPopup();
                $(this).val(input_qty_max_val-1)
            } else if (valueCurrent <= maxValue) {
                $(".btn-number[data-type='plus'][data-field='" + name + "']").removeAttr('disabled')
            } else {
                $('.stock-validation-message').html('There isn’t enough quantity on stock. only ' + input_initial_max_val +' items are available.');
                showWarningPopup();
                $(this).val(1)
            }
        });

        $(".input-number").keydown(function (e) {
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
                (e.keyCode == 65 && e.ctrlKey === true) ||
                (e.keyCode >= 35 && e.keyCode <= 39)) {
                return;
            }

            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        });
    }

    function showWarningPopup() {
        var popup = $('.warning_popup');
        popup.removeClass('d-none').fadeIn(300);

        setTimeout(function() {
            popup.fadeOut(300, function() {
                popup.addClass('d-none');
            });
        }, 5000);
    }

    // Manual close (× button)
    $(document).on('click', '.close_warning_popup', function() {
        var popup = $(this).closest('.warning_popup');
        popup.fadeOut(300, function() {
            popup.addClass('d-none');
        });
    });

    function getVariantPrice() {
        let quantity = $('#quantity').val();

        if (quantity > 0 && checkAddToCartValidity()) {

            let formData = {
                _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                id: $('input[name="id"]').val(),
                quantity: quantity
            };

            $('[type=radio]:checked').each(function () {
                formData[$(this).attr('name')] = $(this).val();
            });

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('branch.pos.variant_price')); ?>',
                data: formData,
                success: function (data) {
                    $('#add-to-cart-form #chosen_price_div').removeClass('d-none');
                    $('#add-to-cart-form #chosen_price_div #chosen_price').html(data.price);
                    $('#check_max_qty').val(data.stock);
                    $('.warning_popup_wrapper .warning_popup .product-stock-count').html(data.stock);
                    $('#current-stock-count').html(data.stock);
                    $('.product-quantity #quantity').attr('max', data.stock)
                }
            });
        }
    }

    function addToCart(form_id = 'add-to-cart-form') {
        if (checkAddToCartValidity()) {

            let quantity = $('#quantity').val();

            let formData = {
                _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                id: $('input[name="id"]').val(),
                quantity: quantity
            };

            $('[type=radio]:checked').each(function () {
                formData[$(this).attr('name')] = $(this).val();
            });

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('branch.pos.add-to-cart')); ?>',
                data: formData,
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    if (data.data == 1) {
                        Swal.fire({
                            icon: 'info',
                            title: '<?php echo e(translate("Cart")); ?>',
                            text: "<?php echo e(translate('Product already added in cart')); ?>",
                            confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                        });
                        return false;
                    } else if (data.quantity <= 0) {
                        Swal.fire({
                            icon: 'info',
                            title: '<?php echo e(translate("Cart")); ?>',
                            text: "<?php echo e(translate('Product is out of stock')); ?>",
                            confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                        });
                        return false;

                    } else if (data.data == 0) {
                        Swal.fire({
                            icon: 'error',
                            title: '<?php echo e(translate("Cart")); ?>',
                            text: '<?php echo e(translate('Sorry, product out of stock')); ?>.',
                            confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                        });
                        return false;
                    }
                    $('.call-when-done').click();

                    toastr.success('<?php echo e(translate('Item has been added in your cart')); ?>!', {
                        CloseButton: true,
                        ProgressBar: true
                    });

                    updateCart();
                },
                complete: function () {
                    $('#loading').hide();
                }
            });
        } else {
            Swal.fire({
                type: 'info',
                title: '<?php echo e(translate("Cart")); ?>',
                text: '<?php echo e(translate('Please choose all the options')); ?>',
                confirmButtonText: '<?php echo e(translate("Yes")); ?>',
            });
        }
    }

    function removeFromCart(key) {
        $.post('<?php echo e(route('branch.pos.remove-from-cart')); ?>', {_token: '<?php echo e(csrf_token()); ?>', key: key}, function (data) {
            if (data.errors) {
                for (var i = 0; i < data.errors.length; i++) {
                    toastr.error(data.errors[i].message, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            } else {
                updateCart();
                toastr.info('<?php echo e(translate('Item has been removed from cart')); ?>', {
                    CloseButton: true,
                    ProgressBar: true
                });
            }

        });
    }

    function emptyCart() {
        $.post('<?php echo e(route('branch.pos.emptyCart')); ?>', {_token: '<?php echo e(csrf_token()); ?>'}, function (data) {
            updateCart();
            toastr.info('<?php echo e(translate('Item has been removed from cart')); ?>', {
                CloseButton: true,
                ProgressBar: true
            });
            location.reload();
        });
    }

    function updateCart() {
        $.post('<?php echo e(route('branch.pos.cart_items')); ?>', {_token: '<?php echo e(csrf_token()); ?>'}, function (data) {
            $('#cart').empty().html(data);
        });
    }

   $(function(){
        $(document).on('click','input[type=number]',function(){ this.select(); });
    });


    function updateQuantity(e){
        var element = $( e.target );
        var minValue = parseInt(element.attr('min'));
        var maxValue = parseInt(element.attr('max'));
        var valueCurrent = parseInt(element.val());

        var key = element.data('key');
        var product_id = element.attr("id");

        if (!isNaN(valueCurrent)) {
            if (valueCurrent >= minValue && valueCurrent <= maxValue) {
                $.post('<?php echo e(route('branch.pos.updateQuantity')); ?>',
                    {_token: '<?php echo e(csrf_token()); ?>',
                        key: key, quantity:valueCurrent
                    },
                    function (data) {
                        updateCart();
                    });
            } else if(valueCurrent >= maxValue) {
                $.post('<?php echo e(route('branch.pos.updateQuantity')); ?>',
                    {_token: '<?php echo e(csrf_token()); ?>',
                        key: key, quantity:maxValue
                    },
                    function (data) {
                        updateCart();
                    });

                Swal.fire({
                    icon: 'error',
                    title: '<?php echo e(translate("Cart")); ?>',
                    text: 'There is not enough quantity on stock. Only ' + maxValue + ' items are available.' ,
                    confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: '<?php echo e(translate("Cart")); ?>',
                    text: '<?php echo e(translate('Sorry, the minimum value was reached')); ?>',
                    confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                });
                updateCart();
            }
        }else {

            Swal.fire({
                icon: 'error',
                title: '<?php echo e(translate("Cart")); ?>',
                text: '<?php echo e(translate('Kindly provide valid quantity')); ?>',
                confirmButtonText: '<?php echo e(translate("Yes")); ?>',
            });
            updateCart();
        }


        if(e.type == 'keydown')
        {
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
                (e.keyCode == 65 && e.ctrlKey === true) ||
                (e.keyCode >= 35 && e.keyCode <= 39)) {
                return;
            }

            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        }

    };


    $('.js-select2-custom').each(function () {
        var select2 = $.HSCore.components.HSSelect2.init($(this));
    });

    $('.js-data-example-ajax').select2({
        ajax: {
            url: '<?php echo e(route('branch.pos.customers')); ?>',
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                results: data
                };
            },
            __port: function (params, success, failure) {
                var $request = $.ajax(params);

                $request.then(success);
                $request.fail(failure);

                return $request;
            }
        }
    });

    function store_key(key, value) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
            }
        });
        $.post({
            url: '<?php echo e(route('branch.pos.store-keys')); ?>',
            data: {
                key:key,
                value:value,
            },
            success: function (data) {
                key = key=='customer_id' ? "<?php echo e(translate('customer_id')); ?>" : (key=='branch_id' ? "<?php echo e(translate('branch_id')); ?>":'');
                toastr.success(key+' '+'<?php echo e(translate('selected')); ?>!', {
                    CloseButton: true,
                    ProgressBar: true
                });
            },
        });
    }

    $(document).ready(function() {
        var orderType = <?php echo json_encode(session('order_type')); ?>;

        if (orderType === 'home_delivery') {
            $('#home_delivery_section').removeClass('d-none');
        } else {
            $('#home_delivery_section').addClass('d-none');
        }
    });

    function select_order_type(order_type) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
            }
        });
        $.post({
            url: '<?php echo e(route('branch.pos.order_type.store')); ?>',
            data: {
                order_type:order_type,
            },
            beforeSend: function () {
                $('#loading').show();
            },
            success: function (data) {
                console.log(data);
                updateCart();
            },
            complete: function () {
                $('#loading').hide();
            }
        });

        if(order_type == 'home_delivery') {
            $('#home_delivery_section').removeClass('d-none');
        }else{
            $('#home_delivery_section').addClass('d-none')
        }
    }

    function deliveryAdressStore(form_id = 'delivery_address_store') {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
            }
        });
        $.post({
            url: '<?php echo e(route('branch.pos.add-delivery-address')); ?>',
            data: $('#' + form_id).serializeArray(),
            beforeSend: function() {
                $('#loading').show();
            },
            success: function(data) {
                console.log(data.errors);
                if (data.errors) {
                    for (var i = 0; i < data.errors.length; i++) {
                        toastr.error(data.errors[i].message, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                } else {
                    $('#del-add').empty().html(data.view);
                }
                updateCart();
                $('.call-when-done').click();
            },
            complete: function() {
                $('#loading').hide();
            }
        });
    }

    // Update paid-by radio button handler
    $('.paid-by').change(function() {
        var selectedPaymentOption = $(this).val();

        // Get total order amount from the displayed value
        var totalOrderAmount = $('.hidden-paid-amount').val();

        // Toggle readonly attribute for paid amount input
        if (selectedPaymentOption == 'card') {
            $('#paid-amount').attr('readonly', true);
            $('#paid-amount').addClass('bg-F5F5F5');
            // Reset paid amount to order amount
            $('#paid-amount').val(totalOrderAmount);
            calculateAmountDifference();
        } else {
            $('#paid-amount').removeAttr('readonly');
            $('#paid-amount').removeClass('bg-F5F5F5');
        }
    });

    $('#order_place').submit(function(eventObj) {
        if($('#customer').val())
        {
            $(this).append('<input type="hidden" name="user_id" value="'+$('#customer').val()+'" /> ');
        }
        return true;
    });

    $(document).ready(function() {
        const $areaDropdown = $('#areaDropdown');
        const $deliveryChargeInput = $('#deliveryChargeInput');

        $areaDropdown.change(function() {
            const selectedOption = $(this).find('option:selected');
            const charge = selectedOption.data('charge');
            $deliveryChargeInput.val(charge);
        });
    });
</script>

<?php if($googleMapStatus == 1 && $deliveryType == 'distance'): ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Dynamically load the Google Maps API script
            var script = document.createElement('script');
            script.src = "https://maps.googleapis.com/maps/api/js?key=<?php echo e(\App\Model\BusinessSetting::where('key', 'map_api_client_key')->first()?->value); ?>&libraries=places&v=weekly";
            script.onload = function() {
                initAutocomplete();
            };
            document.head.appendChild(script);
        });

        function initAutocomplete() {
            var myLatLng = { lat: 23.811842872190343, lng: 90.356331 };

            // Initialize the map
            const map = new google.maps.Map(document.getElementById("location_map_canvas"), {
                center: myLatLng,
                zoom: 13,
                mapTypeId: "roadmap",
            });

            // Initialize the marker
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
            });

            // Initialize Geocoder for reverse geocoding
            var geocoder = new google.maps.Geocoder();

            // Add click event listener to the map
            google.maps.event.addListener(map, 'click', function(mapsMouseEvent) {
                var coordinates = mapsMouseEvent.latLng.toJSON();
                var latlng = new google.maps.LatLng(coordinates.lat, coordinates.lng);
                marker.setPosition(latlng);
                map.panTo(latlng);

                // Update latitude and longitude in input fields
                document.getElementById('latitude').value = coordinates.lat;
                document.getElementById('longitude').value = coordinates.lng;

                // Reverse geocode to get the address
                geocoder.geocode({ 'latLng': latlng }, function(results, status) {
                    if (status == google.maps.GeocoderStatus.OK && results[1]) {
                        document.getElementById('address').value = results[1].formatted_address;
                    }
                });
            });

            // Initialize the search box for places search
            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);
            map.controls[google.maps.ControlPosition.TOP_CENTER].push(input);

            // Bias the SearchBox results towards current map's viewport
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });

            let markers = [];

            // Listen for places_changed event in the search box
            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length === 0) {
                    return;
                }

                // Clear out the old markers
                markers.forEach((marker) => marker.setMap(null));
                markers = [];

                // For each place, get the name and location
                const bounds = new google.maps.LatLngBounds();
                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        return;
                    }

                    var mrkr = new google.maps.Marker({
                        map,
                        title: place.name,
                        position: place.geometry.location,
                    });

                    // Update lat and lng when a marker is clicked
                    google.maps.event.addListener(mrkr, "click", function() {
                        document.getElementById('latitude').value = this.position.lat();
                        document.getElementById('longitude').value = this.position.lng();
                    });

                    markers.push(mrkr);

                    if (place.geometry.viewport) {
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });
                map.fitBounds(bounds);
            });
        }
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/branch-views/pos/index.blade.php ENDPATH**/ ?>