<?php $__env->startSection('title', translate('Language Translate')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/admin')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="card border __language-card">
            <div class="card-header">
                <h5 class="card-title"><?php echo e(translate('language_content_table')); ?></h5>
                <a href="<?php echo e(route('admin.business-settings.web-app.system-setup.language.index')); ?>"
                    class="btn btn-sm btn--danger btn-icon-split">
                    <span class="text text-capitalize"><?php echo e(translate('back')); ?></span>
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered m-0" id="dataTable" width="100%" cellspacing="0">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col"><?php echo e(translate('SL')); ?></th>
                            <th scope="col"><?php echo e(translate('key')); ?></th>
                            <th scope="col"><?php echo e(translate('value')); ?></th>
                            <th scope="col"></th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $lang_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $count=>$language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="lang-<?php echo e($language['key']); ?>">
                                <td><?php echo e($count+1); ?></td>
                                <td class="translate-key">
                                    <div class="white-space-initial">
                                        <input type="text" name="key[]" value="<?php echo e($language['key']); ?>" hidden>
                                        <label><?php echo e($language['key']); ?></label>
                                    </div>
                                </td>
                                <td class="translate-value">
                                    <input type="text" class="form-control w-100" name="value[]"
                                            id="value-<?php echo e($count+1); ?>"
                                            value="<?php echo e($language['value']); ?>">
                                </td>
                                <td>
                                    <button type="button"
                                            onclick="update_lang('<?php echo e(urlencode($language['key'])); ?>',$('#value-<?php echo e($count+1); ?>').val())"
                                            class="btn btn-primary update-language"><?php echo e(translate('Update')); ?>

                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://code.jquery.com/jquery-3.1.1.min.js" ></script>

    <script src="<?php echo e(asset('public/assets/admin')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>

        $(document).ready(function () {
            $('#dataTable').DataTable({
                    "pageLength": <?php echo e(\App\CentralLogics\Helpers::getPagination()); ?>

                });
        });


        function update_lang(key, value) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.business-settings.web-app.system-setup.language.translate-submit',[$lang])); ?>",
                method: 'POST',
                data: {
                    key: key,
                    value: value
                },
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (response) {
                    toastr.success('<?php echo e(translate('text_updated_successfully')); ?>');
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }

        function remove_key(key) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.business-settings.web-app.system-setup.language.remove-key',[$lang])); ?>",
                method: 'POST',
                data: {
                    key: key
                },
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (response) {
                    toastr.success('<?php echo e(translate('Key removed successfully')); ?>');
                    $('#lang-'+key).hide();
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/language/translate.blade.php ENDPATH**/ ?>