<?php $__env->startSection('title', translate('Bulk Export List')); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('/public/assets/admin/img/bulk.png')); ?>" class="w--20" alt="">
                </span>
                <span>
                    <?php echo e(translate('Products Bulk Export')); ?>

                </span>
            </h1>
        </div>
        <div class="card">
            <div class="card-body p-2 pt-3">
                <div class="export-steps">
                    <div class="export-steps-item">
                        <div class="inner">
                            <h5><?php echo e(translate('STEP 1')); ?></h5>
                            <p>
                                <?php echo e(translate('Select Data Type')); ?>

                            </p>
                        </div>
                    </div>
                    <div class="export-steps-item">
                        <div class="inner">
                            <h5><?php echo e(translate('STEP 2')); ?></h5>
                            <p>
                                <?php echo e(translate('Select Data Range and Export')); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <form class="product-form px-3 pb-3"  action="<?php echo e(route('admin.product.bulk-export')); ?>" method="GET" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlSelect1"><?php echo e(translate('type')); ?><span
                                        class="input-label-secondary"></span></label>
                                <select name="type" id="type" data-placeholder="<?php echo e(translate('select')); ?> <?php echo e(translate('type')); ?>" class="form-control" required title="Select Type">
                                    <option value="all"><?php echo e(translate('all')); ?> <?php echo e(translate('data')); ?></option>
                                    <option value="date_wise"><?php echo e(translate('date')); ?> <?php echo e(translate('wise')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group date_wise">
                                <label class="input-label" for="exampleFormControlSelect1"><?php echo e(translate('from')); ?> <?php echo e(translate('date')); ?><span
                                        class="input-label-secondary"></span></label>
                                <input type="date" name="start_date" id="start_date" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group date_wise">
                                <label class="input-label text-capitalize" for="exampleFormControlSelect1"><?php echo e(translate('to')); ?> <?php echo e(translate('date')); ?><span
                                        class="input-label-secondary"></span></label>
                                <input type="date" name="end_date" id="end_date" class="form-control">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="btn--container justify-content-end">
                                <button class="btn btn--reset" type="reset" id="reset"><?php echo e(translate('clear')); ?></button>
                                <button class="btn btn--primary" type="submit" href="<?php echo e(route('admin.product.bulk-export')); ?>" title="<?php echo e(translate('bulk_export')); ?>"><?php echo e(translate('export')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('script_2'); ?>
<script>
    $(document).on('ready', function (){
        $('.id_wise').hide();
        $('.date_wise').hide();
        $('#type').on('change', function() {
            $('.date_wise').hide();
            $('.'+$(this).val()).show();
            $('#end_date').attr('required', false);
        })

    });

    $(document).ready(function () {
        $("#reset").click(function(){
            $('.date_wise').hide();
            $('#end_date').attr('required', false);
            $('#start_date').attr('max',false);
            $('#end_date').attr('min',false);
        })
    });

    $("#start_date").on("change", function () {
        $('#end_date').attr('min',$(this).val());
        $('#end_date').attr('required', true);
    });

    $("#end_date").on("change", function () {
        $('#start_date').attr('max',$(this).val());
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/product/bulk-export-index.blade.php ENDPATH**/ ?>