<?php $__env->startSection('title', translate('social media login')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">


        <div class="page-header">
            <?php echo $__env->make('admin-views.business-settings.partial.third-party-api-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php if(isset($appleLoginService)): ?>
            <div class="card">
                <form action="<?php echo e(route('admin.business-settings.web-app.third-party.update-apple-login')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-header card-header-shadow">
                        <div class="d-flex justify-content-between align-items-center w-100">
                            <div class="__social-media-login-top flex-grow-1">
                                <h5 class="card-title align-items-center">
                                    <img src="<?php echo e(asset('/public/assets/admin/img/modal/apple.png')); ?>" class="mr-1 w--20" alt="<?php echo e(translate('apple')); ?>">
                                    <?php echo e(translate('Apple Login')); ?>

                                </h5>
                            </div>
                            <div class="text--primary-2 d-flex flex-wrap align-items-center" type="button" data-toggle="modal" data-target="#<?php echo e($appleLoginService['login_medium']); ?>-modal">
                                <strong class="mr-2 text--underline"><?php echo e(translate('Credential Setup')); ?></strong>
                                <div class="blinkings">
                                    <i class="tio-info-outined"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-body text-left">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('client_id')); ?></label>
                                    <input type="text" class="form-control" name="client_id" value="<?php echo e($appleLoginService['client_id']); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('team_id')); ?></label>
                                    <input type="text" class="form-control" name="team_id" value="<?php echo e($appleLoginService['team_id']); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('key_id')); ?></label>
                                    <input type="text" class="form-control" name="key_id" value="<?php echo e($appleLoginService['key_id']); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('service_file')); ?> <?php echo e($appleLoginService['service_file']?translate('(Already Exists)'):''); ?></label>
                                    <input type="file" accept=".p8" class="form-control" name="service_file"
                                           value="<?php echo e('storage/app/public/apple-login/'.$appleLoginService['service_file']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="btn--container justify-content-end">
                            <button type="reset" class="btn btn--reset mb-2"><?php echo e(translate('Reset')); ?></button>
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                    class="btn btn--primary mb-2 call-demo"><?php echo e(translate('save')); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
        <?php endif; ?>

    </div>

    <div class="modal fade" id="apple-modal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog status-warning-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body pb-0"><b></b>
                    <div class="text-center mb-20">
                        <img src="<?php echo e(asset('/public/assets/admin/img/modal/apple.png')); ?>" alt="" class="mb-3">
                        <h5 class="modal-title mb-2"><?php echo e(translate('apple_api_set_instruction')); ?></h5>
                    </div>
                    <ol>
                        <li><?php echo e(translate('Go to Apple Developer page')); ?> (<a href="https://developer.apple.com/account/resources/identifiers/list" target="_blank"><?php echo e(translate('click_here')); ?></a>)</li>
                        <li><?php echo e(translate('Here in top left corner you can see the')); ?> <b><?php echo e(translate('Team ID')); ?></b> <?php echo e(translate('[Apple_Deveveloper_Account_Name - Team_ID]')); ?></li>
                        <li><?php echo e(translate('Click Plus icon -> select App IDs -> click on Continue')); ?></li>
                        <li><?php echo e(translate('Put a description and also identifier (identifier that used for app) and this is the')); ?> <b><?php echo e(translate('Client ID')); ?></b> </li>
                        <li><?php echo e(translate('Click Continue and Download the file in device named AuthKey_ID.p8 (Store it safely and it is used for push notification)')); ?> </li>
                        <li><?php echo e(translate('Again click Plus icon -> select Service IDs -> click on Continue')); ?> </li>
                        <li><?php echo e(translate('Push a description and also identifier and Continue')); ?> </li>
                        <li><?php echo e(translate('Download the file in device named')); ?> <b><?php echo e(translate('AuthKey_KeyID.p8')); ?></b> <?php echo e(translate('[This is the Service Key ID file and also after AuthKey_ that is the Key ID]')); ?></li>
                    </ol>
                </div>
                <div class="modal-footer justify-content-center border-0">
                    <button type="button" class="btn btn--primary w-100 mw-300px" data-dismiss="modal"><?php echo e(translate('Got It')); ?></button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/social-media-login.blade.php ENDPATH**/ ?>