<?php $__env->startSection('title', translate('Product Setup')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <?php echo $__env->make('admin-views.business-settings.partial.business-settings-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="business-setting">
            <div class="card">

                <div class="card-body">
                    <form action="<?php echo e(route('admin.business-settings.store.product-setup-update')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row align-items-end">
                            <?php ($stock_limit=\App\Model\BusinessSetting::where('key','minimum_stock_limit')->first()->value); ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label class="input-label" for="minimum_stock_limit"><?php echo e(translate('minimum stock limit')); ?></label>
                                    <input type="number" min="1" value="<?php echo e($stock_limit); ?>"
                                           name="minimum_stock_limit" class="form-control" placeholder="" required>
                                </div>
                            </div>
                            <?php ($tax_status= \App\CentralLogics\Helpers::get_business_settings('product_vat_tax_status')); ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('Product VAT/TAX Status (Included/Excluded)')); ?></label>
                                    <select name="product_vat_tax_status" class="form-control">
                                        <option value="excluded" <?php echo e($tax_status =='excluded'?'selected':''); ?>><?php echo e(translate('excluded')); ?></option>
                                        <option value="included" <?php echo e($tax_status =='included'?'selected':''); ?>><?php echo e(translate('included')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-6 mt-5">
                                <?php ($featuredProductStatus=\App\CentralLogics\Helpers::get_business_settings('featured_product_status')); ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                            <span class="line--limit-1">
                                                <strong><?php echo e(translate('featured_product')); ?></strong>
                                            </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right"
                                                      data-original-title="<?php echo e(translate('If the status is off most featured product will not show to user.')); ?>">
                                                    <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" name="featured_product_status" class="toggle-switch-input" <?php echo e($featuredProductStatus == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-6">
                                <?php ($trendingProductStatus=\App\CentralLogics\Helpers::get_business_settings('trending_product_status')); ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                            <span class="line--limit-1">
                                                <strong><?php echo e(translate('trending_product')); ?></strong>
                                            </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right"
                                                      data-original-title="<?php echo e(translate('If the status is off most trending product will not show to user.')); ?>">
                                                    <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" name="trending_product_status" class="toggle-switch-input" <?php echo e($trendingProductStatus == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>


                            <div class="col-md-4 col-sm-6">
                                <?php ($mostReviewedProductStatus=\App\CentralLogics\Helpers::get_business_settings('most_reviewed_product_status')); ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                            <span class="line--limit-1">
                                                <strong><?php echo e(translate('most_reviewed_product')); ?></strong>
                                            </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right"
                                                      data-original-title="<?php echo e(translate('If the status is off most reviewed product will not show to user.')); ?>">
                                                    <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" name="most_reviewed_product_status" class="toggle-switch-input" <?php echo e($mostReviewedProductStatus == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-6">
                                <?php ($recommendedProductStatus=\App\CentralLogics\Helpers::get_business_settings('recommended_product_status')); ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                            <span class="line--limit-1">
                                                <strong><?php echo e(translate('recommended_product')); ?></strong>
                                            </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right"
                                                      data-original-title="<?php echo e(translate('If the status is off recommended product will not show to user.')); ?>">
                                                    <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" name="recommended_product_status" class="toggle-switch-input" <?php echo e($recommendedProductStatus == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4 col-sm-6">
                                <?php ($productWeightType=\App\CentralLogics\Helpers::get_business_settings('product_weight_unit')); ?>
                                <div class="form-group">
                                    <label class="input-label text-capitalize"><?php echo e(translate('product_weight_unit')); ?>

                                        <span class="form-label-secondary text-danger ml-1" data-toggle="tooltip" data-placement="right"
                                              data-original-title="<?php echo e(translate('product_weight_unit_type')); ?>">
                                                <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                            </span>
                                    </label>
                                    <select name="product_weight_unit" class="form-control">
                                        <option value="kg" <?php echo e($productWeightType=='kg'?'selected':''); ?>><?php echo e(translate('Kilogram')); ?> (<?php echo e(translate('kg')); ?>)</option>
                                        <option value="gm" <?php echo e($productWeightType=='gm'?'selected':''); ?>><?php echo e(translate('Gram')); ?> (<?php echo e(translate('g')); ?>)</option>
                                        <option value="lb" <?php echo e($productWeightType=='lb'?'selected':''); ?>><?php echo e(translate('Pound')); ?> (<?php echo e(translate('lb')); ?>)</option>
                                        <option value="oz" <?php echo e($productWeightType=='oz'?'selected':''); ?>><?php echo e(translate('Ounce')); ?> (<?php echo e(translate('oz')); ?>)</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="btn--container justify-content-end">
                            <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                    class="btn btn--primary call-demo"><?php echo e(translate('save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/product-setup-index.blade.php ENDPATH**/ ?>