<?php $__env->startSection('title', translate('Earning Report')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="media align-items-center mb-2">
                <div class="d-flex gap-2 align-items-center">
                    <img src="<?php echo e(asset('public/assets/admin/img/image-4.png')); ?>" class="w--20" alt="">
                    <h1 class="mb-0"><?php echo e(translate('earning')); ?> <?php echo e(translate('report')); ?> <?php echo e(translate('overview')); ?></h1>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form action="<?php echo e(url()->current()); ?>" method="GET">
                    <div class="row g-3">
                        <div class="col-12">
                            <div>
                                <label class="form-label mb-0 font-semibold"><?php echo e(translate('show')); ?> <?php echo e(translate('data')); ?> <?php echo e(translate('by')); ?> <?php echo e(translate('date')); ?><?php echo e(translate('range')); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label"><?php echo e(translate('start')); ?> <?php echo e(translate('date')); ?></label>
                            <label class="input-date">
                                <input type="text" name="from" id="from_date" value="<?php echo e(request()->get('from')); ?>"
                                       class="js-flatpickr form-control flatpickr-custom flatpickr-input" placeholder="<?php echo e(translate('dd/mm/yy')); ?>" required>
                            </label>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label"><?php echo e(translate('end')); ?> <?php echo e(translate('date')); ?></label>
                            <label class="input-date">
                                <input type="text" name="to" id="to_date" value="<?php echo e(request()->get('to')); ?>"
                                       class="js-flatpickr form-control flatpickr-custom flatpickr-input" placeholder="<?php echo e(translate('dd/mm/yy')); ?>" required>
                            </label>
                        </div>
                        <div class="col-md-4">
                            <label class="input-label d-none d-md-block">&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn--primary min-h-45px btn-block"><?php echo e(translate('show')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <div class="d-flex flex-wrap g-2 g-lg-3">
                    <div class="flex-grow-1">
                        <div class="card card-sm bg--1 border-0 shadow-none">
                            <div class="card-body py-5 px-xl-5">
                                <div class="row">
                                    <div class="col">
                                        <div class="media">
                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('total')); ?> <?php echo e(translate('earning')); ?></h4>
                                                <span class="text-warning">
                                                <i class="tio-trending-up"></i> <?php echo e(Helpers::set_symbol(round(abs($totalEarning)))); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                                "value": <?php echo e($totalSold > 0 ? round(((abs($totalEarning)) / $totalSold) * 100) : 0); ?>,
                                                "maxValue": 100,
                                                "duration": 2000,
                                                "isViewportInit": true,
                                                "colors": ["#0096ff40", "#0096ff90"],
                                                "radius": 25,
                                                "width": 3,
                                                "fgStrokeLinecap": "round",
                                                "textFontSize": 14,
                                                "additionalText": "%",
                                                "textClass": "circle-custom-text",
                                                "textColor": "#0096ff"
                                            }'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="card card-sm bg--2 border-0 shadow-none">
                            <div class="card-body py-5 px-xl-5">
                                <div class="row">
                                    <div class="col">
                                        <div class="media">
                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('total')); ?> <?php echo e(translate('sold')); ?></h4>
                                                <span class="text-success">
                                                <i class="tio-trending-up"></i> <?php echo e(Helpers::set_symbol(round(abs($totalSold)))); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                                "value": <?php echo e($totalSold > 0 ? 100 : 0); ?>,
                                                "maxValue": 100,
                                                "duration": 2000,
                                                "isViewportInit": true,
                                                "colors": ["#00800040", "green"],
                                                "radius": 25,
                                                "width": 3,
                                                "fgStrokeLinecap": "round",
                                                "textFontSize": 14,
                                                "additionalText": "%",
                                                "textClass": "circle-custom-text",
                                                "textColor": "green"
                                            }'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="card card-sm bg--3 border-0 shadow-none">
                            <div class="card-body py-5 px-xl-5">
                                <div class="row">
                                    <div class="col">
                                        <div class="media">
                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('total')); ?> <?php echo e(translate('tax')); ?></h4>
                                                <span class="text-danger">
                                                <i class="tio-trending-up"></i> <?php echo e(Helpers::set_symbol(round(abs($totalTax)))); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                                "value": <?php echo e($totalSold > 0 ? round(((abs($totalTax)) / $totalSold) * 100) : 0); ?>,
                                                "maxValue": 100,
                                                "duration": 2000,
                                                "isViewportInit": true,
                                                "colors": ["#f83b3b40", "#f83b3b"],
                                                "radius": 25,
                                                "width": 3,
                                                "fgStrokeLinecap": "round",
                                                "textFontSize": 14,
                                                "additionalText": "%",
                                                "textClass": "circle-custom-text",
                                                "textColor": "#f83b3b"
                                                }'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="card card-sm bg--4 border-0 shadow-none">
                            <div class="card-body py-5 px-xl-5">
                                <div class="row">
                                    <div class="col">
                                        <div class="media">
                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('total')); ?> <?php echo e(translate('delivery')); ?> <?php echo e(translate('charge')); ?></h4>
                                                <span class="text-warning">
                                                <i class="tio-trending-up"></i> <?php echo e(Helpers::set_symbol(round(abs($totalDeliveryCharge)))); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                                "value": <?php echo e($totalDeliveryCharge > 0 ? round(((abs($totalDeliveryCharge)) / $totalSold) * 100) : 0); ?>,
                                                "maxValue": 100,
                                                "duration": 2000,
                                                "isViewportInit": true,
                                                "colors": ["#ec9a3c40", "#ec9a3c"],
                                                "radius": 25,
                                                "width": 3,
                                                "fgStrokeLinecap": "round",
                                                "textFontSize": 14,
                                                "additionalText": "%",
                                                "textClass": "circle-custom-text",
                                                "textColor": "#ec9a3c"
                                            }'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="d-flex align-items-center gap-2 mb-3">
                    <img width="20" src="<?php echo e(asset('/public/assets/admin/img/order-statistics.png')); ?>" alt="">
                    <h3 class="mb-0"><?php echo e(translate('Total sale of ')); ?> <?php echo e(date('Y')); ?> :<span class="text-primary"> <?php echo e(Helpers::set_symbol($thisYearTotalSold)); ?></span></h3>
                </div>

                <div class="chartjs-custom h-400">
                    <canvas id="gradient-line-chart"></canvas>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin')); ?>/vendor/chart.js/dist/Chart.min.js"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/flatpicker.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/earning.js')); ?>"></script>

    <script>
        (function ($) {
            "use strict";

            let canvas = document.getElementById('gradient-line-chart');
            let ctx = canvas.getContext('2d');
            let myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"],
                    datasets: [{
                        label: "Total Order",
                        lineTension: .5,
                        borderColor: "#00C9A7",
                        pointBorderColor: "#00C9A7",
                        pointBackgroundColor: "#00C9A7",
                        fill: false,
                        backgroundColor: "rgba(82, 220, 79, .04)",
                        borderWidth: 3,
                        data: [<?php echo e($sold[1]); ?>, <?php echo e($sold[2]); ?>, <?php echo e($sold[3]); ?>, <?php echo e($sold[4]); ?>, <?php echo e($sold[5]); ?>, <?php echo e($sold[6]); ?>, <?php echo e($sold[7]); ?>, <?php echo e($sold[8]); ?>, <?php echo e($sold[9]); ?>, <?php echo e($sold[10]); ?>, <?php echo e($sold[11]); ?>, <?php echo e($sold[12]); ?>]
                    }, {
                        label: "Total Tax",
                        lineTension: .5,
                        borderColor: "#ED4C78",
                        pointBorderColor: "#ED4C78",
                        pointBackgroundColor: "#ED4C78",
                        fill: false,
                        backgroundColor: "rgba(50, 131, 249, .04)",
                        borderWidth: 3,
                        data: [<?php echo e($tax[1]); ?>, <?php echo e($tax[2]); ?>, <?php echo e($tax[3]); ?>, <?php echo e($tax[4]); ?>, <?php echo e($tax[5]); ?>, <?php echo e($tax[6]); ?>, <?php echo e($tax[7]); ?>, <?php echo e($tax[8]); ?>, <?php echo e($tax[9]); ?>, <?php echo e($tax[10]); ?>, <?php echo e($tax[11]); ?>, <?php echo e($tax[12]); ?>]

                    }, {
                        label: "Total Delivery Charge",
                        lineTension: .5,
                        borderColor: "#F5A200",
                        pointBorderColor: "#F5A200",
                        pointBackgroundColor: "#F5A200",
                        fill: false,
                        backgroundColor: "rgba(50, 131, 249, .04)",
                        borderWidth: 3,
                        data: [<?php echo e($deliveryCharge[1]); ?>, <?php echo e($deliveryCharge[2]); ?>, <?php echo e($deliveryCharge[3]); ?>, <?php echo e($deliveryCharge[4]); ?>, <?php echo e($deliveryCharge[5]); ?>, <?php echo e($deliveryCharge[6]); ?>, <?php echo e($deliveryCharge[7]); ?>, <?php echo e($deliveryCharge[8]); ?>, <?php echo e($deliveryCharge[9]); ?>, <?php echo e($deliveryCharge[10]); ?>, <?php echo e($deliveryCharge[11]); ?>, <?php echo e($deliveryCharge[12]); ?>]

        }]
                },
                options: {
                    maintainAspectRatio: false,
                    legend: {
                        position: "top",
                        align: "end",
                    },
                    scales: {
                        x: {
                            grid: {
                                display: false,
                            }
                        },
                    }
                }
            });
        })(jQuery);
    </script>

    <script>
        $('#from_date,#to_date').change(function () {
            let fr = $('#from_date').val();
            let to = $('#to_date').val();
            if (fr != '' && to != '') {
                if (fr > to) {
                    $('#from_date').val('');
                    $('#to_date').val('');
                    toastr.error('<?php echo e(translate("Invalid date range!")); ?>', Error, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/report/earning-index.blade.php ENDPATH**/ ?>