<?php $__env->startSection('title', translate('branch List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/add_branch.png')); ?>" class="w--20" alt="<?php echo e(translate('branch')); ?>">
                </span>
                <span>
                    <?php echo e(translate('branch List')); ?> <span class="badge badge-soft-secondary"><?php echo e($branches->total()); ?></span>
                </span>
            </h1>
        </div>

        <div class="row g-3">

            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header border-0">
                        <div class="card--header">
                            <h5 class="card-header-title"></h5>
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search"
                                        class="form-control"
                                        placeholder="<?php echo e(translate('Search by Name')); ?>" aria-label="Search"
                                        value="<?php echo e($search); ?>" required autocomplete="off">
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text">
                                            <?php echo e(translate('Search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive datatable-custom">
                        <table id="columnSearchDatatable"
                               class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                               data-hs-datatables-options='{
                                 "order": [],
                                 "orderCellsTop": true
                               }'>
                            <thead class="thead-light">
                            <tr>
                                <th class="border-0"><?php echo e(translate('#')); ?></th>
                                <th class="border-0"><?php echo e(translate('branch name')); ?></th>
                                <th class="border-0"><?php echo e(translate('branch type')); ?></th>
                                <th class="border-0"><?php echo e(translate('contact info')); ?></th>
                                <th class="border-0"><?php echo e(translate('Delivery Charge Type')); ?></th>
                                <th class="border-0"><?php echo e(translate('status')); ?></th>
                                <th class="border-0 text-center"><?php echo e(translate('action')); ?></th>
                            </tr>

                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($branches->firstItem()+$key); ?></td>
                                    <td>
                                        <div class="short-media">
                                            <img src="<?php echo e($branch->imageFullPath); ?>">
                                            <div class="text-cont">
                                                <span class="d-block font-size-sm text-body text-trim-50">
                                                    <?php echo e($branch['name']); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($branch['id']==1): ?>
                                            <span><?php echo e(translate('main')); ?> </span>
                                        <?php else: ?>
                                            <span><?php echo e(translate('sub Branch')); ?> </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <h5 class="m-0">
                                            <a href="mailto:<?php echo e($branch['email']); ?>"><?php echo e($branch['email']); ?></a>
                                        </h5>
                                        <div>
                                            <a href="Tel:<?php echo e($branch['phone']); ?>"><?php echo e($branch['phone']); ?></a>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-soft-success"> <?php echo e($branch?->delivery_charge_setup?->delivery_charge_type); ?> </span>
                                    </td>
                                    <td>
                                        <?php if($branch['id']!=1): ?>
                                        <label class="toggle-switch">
                                            <input type="checkbox"
                                                   class="toggle-switch-input status-change-alert" id="stocksCheckbox<?php echo e($branch->id); ?>"
                                                   data-route="<?php echo e(route('admin.branch.status', [$branch->id, $branch->status ? 0 : 1])); ?>"
                                                   data-message="<?php echo e($branch->status? translate('you_want_to_disable_this_branch'): translate('you_want_to_active_this_branch')); ?>"
                                                <?php echo e($branch->status ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label text">
                                        <span class="toggle-switch-indicator"></span>
                                    </span>
                                        </label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn--container justify-content-center">
                                            <a class="action-btn" target="_blank"
                                               href="<?php echo e(route('admin.business-settings.store.delivery-fee-setup')); ?>">
                                                <i class="tio-settings"></i>
                                            </a>
                                            <a class="action-btn"
                                                href="<?php echo e(route('admin.branch.edit',[$branch['id']])); ?>"><i class="tio-edit"></i>
                                            </a>
                                            <?php if($branch['id']!=1): ?>
                                                <a class="action-btn btn--danger btn-outline-danger form-alert" href="javascript:"
                                                   data-id="branch-<?php echo e($branch['id']); ?>"
                                                   data-message="<?php echo e(translate("Want to delete this")); ?>">
                                                    <i class="tio-delete-outlined"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                        <form action="<?php echo e(route('admin.branch.delete',[$branch['id']])); ?>"
                                                method="post" id="branch-<?php echo e($branch['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <table>
                            <tfoot>
                            <?php echo $branches->links(); ?>

                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/branch/list.blade.php ENDPATH**/ ?>