<?php $__env->startSection('title', translate('Keyword_Search_Analytics')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/analytics_logo.png')); ?>" class="w--20" alt="<?php echo e(translate('analytics')); ?>">
                </span>
                <span>
                    <?php echo e(translate('Keyword_Search_Analytics')); ?>

                </span>
            </h1>
        </div>

        <div class="row gy-3">
            <div class="col-lg-4">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex flex-wrap justify-content-between gap-3">
                            <h4><?php echo e(translate('Trending_Keywords')); ?></h4>
                            <div class="select-wrap d-flex flex-wrap gap-10">
                                <select class="form-control js-select2-custom trending-keywords__select" name="date_range">
                                    <option value="today" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='today'?'selected':''); ?>><?php echo e(translate('Today')); ?></option>
                                    <option value="all_time" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='all_time'?'selected':''); ?>><?php echo e(translate('All_Time')); ?></option>
                                    <option value="this_week" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_week'?'selected':''); ?>><?php echo e(translate('This_Week')); ?></option>
                                    <option value="last_week" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_week'?'selected':''); ?>><?php echo e(translate('Last_Week')); ?></option>
                                    <option value="this_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_month'?'selected':''); ?>><?php echo e(translate('This_Month')); ?></option>
                                    <option value="last_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_month'?'selected':''); ?>><?php echo e(translate('Last_Month')); ?></option>
                                    <option value="last_15_days" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_15_days'?'selected':''); ?>><?php echo e(translate('Last_15_Days')); ?></option>
                                    <option value="this_year" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year'?'selected':''); ?>><?php echo e(translate('This_Year')); ?></option>
                                    <option value="last_year" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_year'?'selected':''); ?>><?php echo e(translate('Last_Year')); ?></option>
                                    <option value="last_6_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_6_month'?'selected':''); ?>><?php echo e(translate('Last_6_Month')); ?></option>
                                    <option value="this_year_1st_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_1st_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_1st_Quarter')); ?></option>
                                    <option value="this_year_2nd_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_2nd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_2nd_Quarter')); ?></option>
                                    <option value="this_year_3rd_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_3rd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_3rd_Quarter')); ?></option>
                                    <option value="this_year_4th_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_4th_quarter'?'selected':''); ?>><?php echo e(translate('this_year_4th_quarter')); ?></option>
                                </select>
                            </div>
                        </div>
                        <?php if(count($graphData['count']) < 1 && count($graphData['keyword']) < 1): ?>
                            <div class="text-center py-4"><?php echo e(translate('No data available')); ?></div>
                        <?php endif; ?>
                        <div id="apex_radial-bar-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex flex-wrap justify-content-between gap-3">
                            <h4><?php echo e(translate('category_Wise_Search_Volume')); ?></h4>
                            <div class="select-wrap d-flex flex-wrap gap-10">
                                <select class="form-control js-select2-custom w-100 zone-search-volume__select" id="date-range" name="date_range_2">
                                    <option value="today"  <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='today'?'selected':''); ?>><?php echo e(translate('Today')); ?></option>
                                    <option value="all_time" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='all_time'?'selected':''); ?>><?php echo e(translate('All_Time')); ?></option>
                                    <option value="this_week" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_week'?'selected':''); ?>><?php echo e(translate('This_Week')); ?></option>
                                    <option value="last_week" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_week'?'selected':''); ?>><?php echo e(translate('Last_Week')); ?></option>
                                    <option value="this_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_month'?'selected':''); ?>><?php echo e(translate('This_Month')); ?></option>
                                    <option value="last_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_month'?'selected':''); ?>><?php echo e(translate('Last_Month')); ?></option>
                                    <option value="last_15_days" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_15_days'?'selected':''); ?>><?php echo e(translate('Last_15_Days')); ?></option>
                                    <option value="this_year" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year'?'selected':''); ?>><?php echo e(translate('This_Year')); ?></option>
                                    <option value="last_year" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_year'?'selected':''); ?>><?php echo e(translate('Last_Year')); ?></option>
                                    <option value="last_6_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_6_month'?'selected':''); ?>><?php echo e(translate('Last_6_Month')); ?></option>
                                    <option value="this_year_1st_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_1st_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_1st_Quarter')); ?></option>
                                    <option value="this_year_2nd_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_2nd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_2nd_Quarter')); ?></option>
                                    <option value="this_year_3rd_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_3rd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_3rd_Quarter')); ?></option>
                                    <option value="this_year_4th_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_4th_quarter'?'selected':''); ?>><?php echo e(translate('this_year_4th_quarter')); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="mt-4">
                            <div class="row gy-3">
                                <div class="col-lg-5">
                                    <div
                                        class="bg-light h-100 rounded d-flex justify-content-center align-items-center p-3">
                                        <div class="text-center">
                                            <img class="mb-2" width="50"
                                                 src="<?php echo e(asset('public/assets/admin/img/analytics_logo.png')); ?>"
                                                 alt="<?php echo e(translate('analytics_logo')); ?>">
                                            <h2 class="mb-2"><?php echo e($searchedKeywordCount); ?></h2>
                                            <p><?php echo e(translate('Total Search Volume')); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="max-h320-auto">
                                        <ul class="common-list after-none gap-10 d-flex flex-column list-unstyled">
                                            <?php $__currentLoopData = $categoryWiseVolumes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <div
                                                        class="mb-2 d-flex align-items-center justify-content-between gap-10 flex-wrap">
                                                        <span class="zone-name"><?php echo e($item->category?->name); ?></span>
                                                        <span class="booking-count"><?php echo e(number_format(($item['count']*100)/$total, 2)); ?> %</span>
                                                    </div>
                                                    <div class="progress">
                                                        <div class="progress-bar" role="progressbar"
                                                             style="width: <?php echo e(($item['count']*100)/$total); ?>%"
                                                             aria-valuenow="25" aria-valuemin="0"
                                                             aria-valuemax="100"></div>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div class="card--header">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group">
                            <input id="datatableSearch_" type="search" name="search"
                                   class="form-control"
                                   placeholder="<?php echo e(translate('search_by_Keyword')); ?>"
                                   aria-label="Search"
                                   value="<?php echo e($search??''); ?>" required autocomplete="off">
                            <div class="input-group-append">
                                <button type="submit" class="input-group-text">
                                    <?php echo e(translate('Search')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div>
                    <button type="button" class="btn btn-outline--primary text-nowrap btn-block"
                            data-toggle="dropdown">
                        <i class="tio-download-to"></i>
                        <?php echo e(translate('Export')); ?>

                        <i class="tio-chevron-down"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-right">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('admin.analytics.keyword.export.excel')); ?>"><?php echo e(translate('Excel')); ?></a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table
                    class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('Keyword')); ?></th>
                        <th class="text-center"><?php echo e(translate('Search Volume')); ?></th>
                        <th class="text-center"><?php echo e(translate('Related Categories')); ?></th>
                        <th class="text-center"><?php echo e(translate('Related Products')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $searchedTableData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($searchedTableData->firstitem()+$key); ?></td>
                            <td><?php echo e($item->keyword??''); ?></td>
                            <td class="text-center"><?php echo e($item->volume_count ?? ''); ?></td>
                            <td class="text-center">
                                <a href="#" data-toggle="tooltip" data-html="true" data-placement="right" title="
                                        <?php
                                            $categories = json_decode($item->searched_category);
                                            foreach ($categories as $category) {
                                                echo $category->category?->name . '<br>' ;
                                            }

                                        ?>">
                                    <?php echo e($item->searched_category_count); ?></a>

                            </td>
                            <td class="text-center"><?php echo e($item->searched_product_count); ?></td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <table>
                    <tfoot>
                    <?php echo $searchedTableData->links(); ?>

                    </tfoot>
                    <?php if(count($searchedTableData) == 0): ?>
                        <div class="text-center p-4">
                            <img class="w-120px mb-3"
                                 src="<?php echo e(asset('/public/assets/admin/svg/illustrations/sorry.svg')); ?>"
                                 alt="<?php echo e(translate('image')); ?>">
                            <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                        </div>
                    <?php endif; ?>
                </table>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

        <?php $__env->startPush('script_2'); ?>
            <script src="<?php echo e(asset('/public/assets/admin/js/apex-charts/apexcharts.js')); ?>"></script>
            <script>
                var options = {
                    //series: <?php echo json_encode($graphData['count'], 15, 512) ?>,
                    series: <?php echo json_encode($graphData['avg'], 15, 512) ?>,
                    chart: {
                        height: 350,
                        type: 'radialBar',
                    },
                    plotOptions: {
                        radialBar: {
                            hollow: {
                                margin: 10,
                                size: '55%',
                            },
                            dataLabels: {
                                name: {
                                    fontSize: '16px',
                                },
                                value: {
                                    fontSize: '14px',
                                },
                                total: {
                                    show: true,
                                    label: 'Total',
                                    formatter: function (w) {
                                        return <?php echo e(array_sum($graphData['count'])); ?>

                                    }
                                }
                            }
                        }
                    },
                    labels: <?php echo json_encode(count($graphData['keyword']) > 0 ? $graphData['keyword'] : '', 15, 512) ?>,
                    colors: ['#286CD1', '#FFC700', '#A2CEEE', '#79CCA5', '#FFB16D'],
                    legend: {
                        show: true,
                        floating: false,
                        fontSize: '12px',
                        position: 'bottom',
                        horizontalAlign: 'center',
                        offsetY: -10,
                        itemMargin: {
                            horizontal: 5,
                            vertical: 10
                        },
                        labels: {
                            useSeriesColors: true,
                        },
                        markers: {
                            size: 0
                        },
                        formatter: function (seriesName, opts) {
                            return seriesName + ":  " + opts.w.globals.series[opts.seriesIndex]
                        },
                    },
                };

                var chart = new ApexCharts(document.querySelector("#apex_radial-bar-chart"), options);
                chart.render();
            </script>

            <script>
                $(".trending-keywords__select").on('change', function () {
                    if (this.value !== "") location.href = "<?php echo e(route('admin.analytics.keyword-search')); ?>" + '?date_range=' + this.value + '&date_range_2=' + '<?php echo e($queryParams['date_range_2']??'all_time'); ?>';
                });
                $(".zone-search-volume__select").on('change', function () {
                    if (this.value !== "") location.href = "<?php echo e(route('admin.analytics.keyword-search')); ?>" + '?date_range=' + '<?php echo e($queryParams['date_range']??'all_time'); ?>' + '&date_range_2=' + this.value;
                });
            </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/analytics/keyword-search.blade.php ENDPATH**/ ?>