<?php $__env->startSection('title', translate('mail config')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <?php echo $__env->make('admin-views.business-settings.partial.third-party-api-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row gx-2 gx-lg-3">
            <div class="col-xl-8">
                <div class="card mb-3">
                    <div class="card-body">

                        <div class="position-relative">
                                <button class="btn btn-secondary" type="button" data-toggle="collapse"
                                        data-target="#collapseExample" aria-expanded="false"
                                        aria-controls="collapseExample">
                                    <i class="tio-email-outlined"></i>
                                    <?php echo e(translate('test_your_email_integration')); ?>

                                </button>
                            <div class="fixed--to-right">
                                <i class="tio-telegram float-right"></i>
                            </div>
                        </div>

                        <div class="collapse" id="collapseExample">
                            <form class="pt-3" action="javascript:">
                                <div class="row g-2">
                                    <div class="col-sm-8">
                                        <div class="form-group mb-0">
                                            <label for="inputPassword2"
                                                    class="sr-only"><?php echo e(translate('mail')); ?></label>
                                            <input type="email" id="test-email" class="form-control"
                                                    placeholder="Ex : jhon@email.com">
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <button type="button" class="btn btn-primary h-100 btn-block" id="send-mail">
                                            <i class="tio-telegram"></i>
                                            <?php echo e(translate('send_mail')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
            <?php ($config=\App\Model\BusinessSetting::where(['key'=>'mail_config'])->first()); ?>
            <?php ($data=json_decode($config['value'],true)); ?>
            <?php ($status=$data['status']== 1 ? 0 : 1); ?>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-wrap">
                            <label class="control-label h3 mb-0 text-capitalize mr-3"><?php echo e(translate('mail configuration status')); ?></label>
                            <div class="custom--switch">
                                <input type="checkbox" name="status" value="" id="switch6" switch="primary"
                                       data-route="<?php echo e(route('admin.business-settings.web-app.mail-config.status',[$status])); ?>"
                                    class="toggle-switch-input mail-status-change" id="stocksCheckbox<?php echo e(1); ?>" <?php echo e($data['status'] ==  1 ? 'checked' : ''); ?>>
                                <label for="switch6" data-on-label="on" data-off-label="off"></label>
                            </div>
                        </div>
                        <form action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.mail-config'):'javascript:'); ?>" method="post"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php if(isset($config)): ?>
                                <div class="row mt-3">
                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('mailer')); ?> <?php echo e(translate('name')); ?></label><br>
                                        <input type="text" placeholder="<?php echo e(translate('ex : Alex')); ?>" class="form-control" name="name"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['name']:''); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('host')); ?></label><br>
                                        <input type="text" class="form-control" name="host" value="<?php echo e(env('APP_MODE')!='demo'?$data['host']:''); ?>" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('driver')); ?></label><br>
                                        <input type="text" class="form-control" name="driver" value="<?php echo e(env('APP_MODE')!='demo'?$data['driver']:''); ?>" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('port')); ?></label><br>
                                        <input type="text" class="form-control" name="port" value="<?php echo e(env('APP_MODE')!='demo'?$data['port']:''); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('username')); ?></label><br>
                                        <input type="text" placeholder="<?php echo e(translate('ex : ex@yahoo.com')); ?>" class="form-control" name="username"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['username']:''); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('email')); ?> <?php echo e(translate('id')); ?></label><br>
                                        <input type="text" placeholder="<?php echo e(translate('ex : ex@yahoo.com')); ?>" class="form-control" name="email"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['email_id']:''); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('encryption')); ?></label><br>
                                        <input type="text" placeholder="<?php echo e(translate('ex : tls')); ?>" class="form-control" name="encryption"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$data['encryption']:''); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label"><?php echo e(translate('password')); ?></label><br>
                                        <input type="text" class="form-control" name="password" value="<?php echo e(env('APP_MODE')!='demo'?$data['password']:''); ?>" required>
                                    </div>
                                </div>
                                <div class="btn--container justify-content-end">
                                    <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                    <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                            class="btn btn-primary mt-2 mb-2 call-demo"><?php echo e(translate('save')); ?>

                                    </button>
                                </div>
                            <?php else: ?>
                                <button type="submit" class="btn btn-primary mt-2 mb-2"><?php echo e(translate('configure')); ?></button>
                            <?php endif; ?>
                        </form>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
<script>
    "use strict";

    $('.mail-status-change').on('click', function(){
        let route = $(this).data('route');

        $.get({
            url: route,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $('#loading').show();
            },
            success: function (data) {
                toastr.success(data.message);
            },
            complete: function () {
                $('#loading').hide();
            },
        });
    });


    function ValidateEmail(inputText) {
        var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
        if (inputText.match(mailformat)) {
            return true;
        } else {
            return false;
        }
    }

    $('#send-mail').on('click', function(){
        if (ValidateEmail($('#test-email').val())) {
            Swal.fire({
                title: '<?php echo e(translate('Are you sure?')); ?>?',
                text: "<?php echo e(translate('a_test_mail_will_be_sent_to_your_email')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#F56A57',
                cancelButtonColor: 'secondary',
                confirmButtonText: '<?php echo e(translate('Yes')); ?>!'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.business-settings.web-app.mail-send')); ?>",
                        method: 'POST',
                        data: {
                            "email": $('#test-email').val()
                        },
                        beforeSend: function () {
                            $('#loading').show();
                        },
                        success: function (data) {
                            if (data.success === 2) {
                                toastr.error('<?php echo e(translate('email_configuration_error')); ?> !!');
                            } else if (data.success === 1) {
                                toastr.success('<?php echo e(translate('email_configured_perfectly!')); ?>!');
                            } else {
                                toastr.info('<?php echo e(translate('email_status_is_not_active')); ?>!');
                            }
                        },
                        complete: function () {
                            $('#loading').hide();

                        }
                    });
                }
            })
        } else {
            toastr.error('<?php echo e(translate('invalid_email_address')); ?> !!');
        }
    });

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/mail-index.blade.php ENDPATH**/ ?>