<?php $__env->startSection('title', translate('Update Attribute')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/attribute.png')); ?>" class="w--24" alt="<?php echo e(translate('attribute')); ?>">
                </span>
                <span>
                    <?php echo e(translate('attribute')); ?> <?php echo e(translate('update')); ?>

                </span>
            </h1>
        </div>
        <div class="card">
            <div class="card-body pt-2">
                <form action="<?php echo e(route('admin.attribute.update',[$attribute['id']])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php ($data = Helpers::get_business_settings('language')); ?>
                    <?php ($defaultLang = Helpers::get_default_language()); ?>

                    <?php if($data && array_key_exists('code', $data[0])): ?>

                        <ul class="nav nav-tabs mb-4 d-inline-flex">
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item">
                                    <a class="nav-link lang_link <?php echo e($lang['default'] == true ? 'active':''); ?>" href="#" id="<?php echo e($lang['code']); ?>-link">
                                        <?php echo e(Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <div class="row">
                            <div class="col-12">
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if(count($attribute['translations'])){
                                            $translate = [];
                                            foreach($attribute['translations'] as $t)
                                            {
                                                if($t->locale == $lang['code'] && $t->key=="name"){
                                                    $translate[$lang['code']]['name'] = $t->value;
                                                }
                                            }
                                        }
                                    ?>
                                    <div class="form-group lang_form <?php echo e($lang['default'] == false ? 'd-none':''); ?>" id="<?php echo e($lang['code']); ?>-form">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?> (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                        <input type="text" name="name[]" class="form-control"
                                               placeholder="<?php echo e(translate('New attribute')); ?>"
                                               value="<?php echo e($lang['code'] == 'en' ? $attribute['name'] : ($translate[$lang['code']]['name']??'')); ?>"
                                               <?php echo e($lang['status'] == true ? 'required':''); ?> maxlength="255"
                                               <?php if($lang['status'] == true): ?> oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>>
                                    </div>
                                    <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group lang_form" id="<?php echo e($defaultLang); ?>-form">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?> (<?php echo e(strtoupper($defaultLang)); ?>)</label>
                                    <input type="text" name="name[]" class="form-control" value="<?php echo e($attribute['name']); ?>" placeholder="<?php echo e(translate('New attribute')); ?>" maxlength="255">
                                </div>
                                <input type="hidden" name="lang[]" value="<?php echo e($defaultLang); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="btn--container justify-content-end">
                        <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            $("#"+lang+"-form").removeClass('d-none');
            if(lang == '<?php echo e($defaultLang); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/attribute/edit.blade.php ENDPATH**/ ?>