<?php $__env->startSection('title', translate('reCaptcha Setup')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <?php echo $__env->make('admin-views.business-settings.partial.third-party-api-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="d-flex flex-wrap justify-content-between align-items-center">
                    <h3 class="mb-3"><?php echo e(translate('Google Recapcha Information')); ?></h3>
                    <a class="btn-sm btn btn-outline-primary p-2 cursor-pointer" data-toggle="modal" data-target="#instructionsModal">
                        <i class="tio-info-outined"></i>
                        <?php echo e(translate('Credentials_Setup')); ?>

                    </a>
                </div>

                <div class="badge-soft-secondary rounded my-5 p-3">
                    <h5 class="m-0"><?php echo e(translate('V3 Version is available now. Must setup for ReCAPTCHA V3')); ?></h5>
                    <p class="m-0"><?php echo e(translate('You must setup for V3 version and active the status. Otherwise the default reCAPTCHA will be displayed automatically')); ?></p>
                </div>

                <div class="mt-4">
                    <?php ($config=\App\CentralLogics\Helpers::get_business_settings('recaptcha')); ?>
                    <form
                        action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.third-party.recaptcha_update',['recaptcha']):'javascript:'); ?>"
                        method="post">
                        <?php echo csrf_field(); ?>
                        <div class="mb-4">
                           <h4><?php echo e(translate('status')); ?></h4>
                        </div>
                        <div class="d-flex flex-wrap mb-4">
                            <label class="form-check form--check mr-2 mr-md-4">
                                <input type="radio" class="form-check-input" name="status"
                                    value="1" <?php echo e(isset($config) && $config['status']==1?'checked':''); ?>>
                                <span class="form-check-label text--title pl-2"><?php echo e(translate('active')); ?></span>
                            </label>
                            <label class="form-check form--check">
                                <input type="radio" class="form-check-input" name="status"
                                    value="0" <?php echo e(isset($config) && $config['status']==0?'checked':''); ?>>
                                <span class="form-check-label text--title pl-2"><?php echo e(translate('inactive')); ?> </span>
                            </label>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('Site Key')); ?></label>
                                    <input type="text" class="form-control" name="site_key"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$config['site_key']??"":''); ?>">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(translate('Secret Key')); ?></label>
                                    <input type="text" class="form-control" name="secret_key"
                                            value="<?php echo e(env('APP_MODE')!='demo'?$config['secret_key']??"":''); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="text-right">
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                            class="btn btn--primary px-5 call-demo"><?php echo e(translate('save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="instructionsModal" tabindex="-1" aria-labelledby="instructionsModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-end">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center my-5">
                        <img src="<?php echo e(asset('public/assets/admin/svg/components/instruction.svg')); ?>">
                    </div>

                    <h5 class="modal-title my-3" id="instructionsModalLabel"><?php echo e(translate('Instructions')); ?></h5>

                    <ol class="d-flex flex-column __gap-5px __instructions">
                        <li><?php echo e(translate('To get site key and secret key go to the Credentials page')); ?>

                            (<?php echo e(translate('Click')); ?> <a
                                href="https://www.google.com/recaptcha/admin/create"
                                target="_blank"><?php echo e(translate('here')); ?></a>)
                        </li>
                        <li><?php echo e(translate('Add a ')); ?>

                            <b><?php echo e(translate('label')); ?></b> <?php echo e(translate('(Ex: Test Label)')); ?>

                        </li>
                        <li>
                            <?php echo e(translate('Select reCAPTCHA v3 as ')); ?>

                            <b><?php echo e(translate('reCAPTCHA Type')); ?></b>
                        </li>
                        <li>
                            <?php echo e(translate('Add')); ?>

                            <b><?php echo e(translate('domain')); ?></b>
                            <?php echo e(translate('(For ex: demo.6amtech.com)')); ?>

                        </li>
                        <li>
                            <?php echo e(translate('Press')); ?>

                            <b><?php echo e(translate('Submit')); ?></b>
                        </li>
                        <li><?php echo e(translate('Copy')); ?> <b>Site
                                Key</b> <?php echo e(translate('and')); ?> <b>Secret
                                Key</b>, <?php echo e(translate('paste in the input filed below and')); ?>

                            <b>Save</b>.
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/recaptcha-index.blade.php ENDPATH**/ ?>