<?php $__env->startSection('title', translate('clean database')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/cloud-database.png')); ?>" class="w--26" alt="">
                </span>
                <span>
                    <?php echo e(translate('system settings')); ?>

                </span>
            </h1>
            <ul class="nav nav-tabs border-0 mb-3">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.business-settings.web-app.system-setup.language.index')); ?>">
                        <?php echo e(translate('Language Setup')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.business-settings.web-app.system-setup.app_setting')); ?>">
                        <?php echo e(translate('App Settings')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo e(route('admin.business-settings.web-app.system-setup.db-index')); ?>">
                        <?php echo e(translate('Clean Database')); ?>

                    </a>
                </li>
            </ul>
        </div>
        <div class="alert alert--danger alert-danger mb-3" role="alert">
            <span class="alert--icon"><i class="tio-info"></i></span>
                <strong class="text--title"><?php echo e(translate('Note :')); ?></strong>
            <span>
                <?php echo e(translate('This_page_contains_sensitive_information.Make_sure_before_changing.')); ?>

            </span>
        </div>

        <div class="card">
            <div class="card-body p-20">
                <form action="<?php echo e(route('admin.business-settings.web-app.system-setup.clean-db')); ?>" method="post"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="check--item-wrapper clean--database-checkgroup mt-0">
                        <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="check-item">
                                <div class="form-group form-check form--check">
                                    <input type="checkbox" name="tables[]" value="<?php echo e($table); ?>"
                                        class="form-check-input"
                                        id="<?php echo e($table); ?>">
                                    <label class="form-check-label text-dark"
                                        for="<?php echo e($table); ?>"><?php echo e(translate(Str::limit($table, 20))); ?>

                                    <span class="badge-pill badge-secondary mx-2"><?php echo e($rows[$key]); ?></span></label>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="btn--container justify-content-end">
                        <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                        <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                            class="btn btn-primary mb-2 call-demo"><?php echo e(translate('clean')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        "use strict";

        $("form").on('submit',function(e) {
            e.preventDefault();
            Swal.fire({
                title: '<?php echo e(translate('Are you sure?')); ?>',
                text: "<?php echo e(translate('Sensitive_data! Make_sure_before_changing.')); ?>",
                type: 'warning',
                showCancelButton: true,
                cancelButtonColor: 'default',
                confirmButtonColor: '#FC6A57',
                cancelButtonText: '<?php echo e(translate('No')); ?>',
                confirmButtonText: '<?php echo e(translate('Yes')); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    this.submit();
                }else{
                    e.preventDefault();
                    toastr.success("<?php echo e(translate('Cancelled')); ?>");
                    location.reload();
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/db-index.blade.php ENDPATH**/ ?>