<?php $__env->startSection('title', translate('Firebase OTP Verification')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <?php echo $__env->make('admin-views.business-settings.partial.third-party-api-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.business-settings.web-app.third-party.firebase-otp-verification-update')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6" style="padding-top: 30px;">
                                    <?php
                                    $firebaseOtp=\App\CentralLogics\Helpers::get_business_settings('firebase_otp_verification');
                                    ?>
                                    <div class="form-group">
                                        <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                                <span class="line--limit-1">
                                                    <strong><?php echo e(translate('Firebase Auth Verification Status')); ?></strong>
                                                </span>
                                            </span>
                                            <input type="checkbox" class="toggle-switch-input" name="status" <?php echo e(isset($firebaseOtp) && $firebaseOtp['status'] == 1 ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label text-capitalize"><?php echo e(translate('web_api_key')); ?></label>
                                        <input type="text" value="<?php echo e($firebaseOtp && env('APP_MODE')!='demo' ? $firebaseOtp['web_api_key'] : ''); ?>" name="web_api_key" class="form-control" placeholder="">
                                    </div>
                                </div>
                            </div>
                            <div class="btn--container justify-content-end mt-2">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('clear')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn--primary call-demo"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/firebase-otp-verification.blade.php ENDPATH**/ ?>