<?php $__env->startSection('title', translate('Review List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/star.png')); ?>" class="w--20" alt="<?php echo e(translate('image')); ?>">
                </span>
                <span>
                    <?php echo e(translate('Review List')); ?>

                </span>
            </h1>
        </div>

        <div class="card">
            <div class="card-header flex-between">
                <div class="card--header">
                    <h5 class="card-title"><?php echo e(translate('Review list Table')); ?> <span class="badge badge-soft-secondary badge-pill"><?php echo e($reviews->total()); ?></span> </h5>
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group">
                            <input id="datatableSearch_" type="search" name="search"
                                    class="form-control"
                                    placeholder="<?php echo e(translate('Search')); ?>" aria-label="Search"
                                    value="<?php echo e($search); ?>" required autocomplete="off">
                            <div class="input-group-append">
                                <button type="submit" class="input-group-text">
                                    <?php echo e(__('Search')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo e(translate('#')); ?></th>
                        <th><?php echo e(translate('deliveryman')); ?></th>
                        <th><?php echo e(translate('customer')); ?></th>
                        <th><?php echo e(translate('review')); ?></th>
                        <th><?php echo e(translate('rating')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($reviews->firstItem()+$key); ?></td>
                            <td>
                                <span class="d-block font-size-sm text-body">
                                    <?php if($review->delivery_man): ?>
                                        <a href="<?php echo e(route('admin.delivery-man.preview',[$review['delivery_man_id']])); ?>">
                                            <?php echo e($review->delivery_man->f_name.' '.$review->delivery_man->l_name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="badge-pill badge-soft-dark text-muted text-sm small">
                                            <?php echo e(translate('DeliveryMan unavailable')); ?>

                                        </span>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td>
                                <?php if(isset($review->customer)): ?>
                                    <a href="<?php echo e(route('admin.customer.view',[$review->user_id])); ?>">
                                        <?php echo e($review->customer->f_name." ".$review->customer->l_name); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="badge-pill badge-soft-dark text-muted text-sm small">
                                        <?php echo e(translate('Customer unavailable')); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="max-200px line--limit-3">
                                    <?php echo e($review->comment); ?>

                                </div>
                            </td>
                            <td>
                                <label class="badge rating">
                                    <?php echo e($review->rating); ?> <i class="tio-star"></i>
                                </label>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <table>
                    <tfoot>
                    <?php echo $reviews->links(); ?>

                    </tfoot>
                </table>
                <?php if(count($reviews)==0): ?>
                    <div class="text-center p-4">
                        <img class="w-120px mb-3" src="<?php echo e(asset('public/assets/admin')); ?>/svg/illustrations/sorry.svg" alt="<?php echo e(translate('image')); ?>">
                        <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/delivery-man/reviews-list.blade.php ENDPATH**/ ?>