<?php $__env->startSection('title', translate('Update category')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/category.png')); ?>" class="w--24" alt="<?php echo e(translate('category')); ?>">
                </span>
                <span>
                    <?php if($category->parent_id == 0): ?>
                        <?php echo e(translate('category Update')); ?>

                    <?php else: ?>
                    <?php echo e(translate('Sub Category Update')); ?>

                    <?php endif; ?>
                </span>
            </h1>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.category.update',[$category['id']])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php ($data = Helpers::get_business_settings('language')); ?>
                    <?php ($defaultLanguage = Helpers::get_default_language()); ?>

                    <?php if($data && array_key_exists('code', $data[0])): ?>
                            <ul class="nav nav-tabs d-inline-flex <?php echo e($category->parent_id == 0 ? 'mb--n-30' : 'mb-4'); ?>">
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item">
                                    <a class="nav-link lang_link <?php echo e($lang['default'] == true? 'active':''); ?>" href="#"
                                    id="<?php echo e($lang['code']); ?>-link"><?php echo e(Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?></a>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                    <?php endif; ?>

                    <?php if($data && array_key_exists('code', $data[0])): ?>
                    <div class="row align-items-end g-4">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                if (count($category['translations'])) {
                                    $translate = [];
                                    foreach ($category['translations'] as $t) {
                                        if ($t->locale == $lang['code'] && $t->key == "name") {
                                            $translate[$lang['code']]['name'] = $t->value;
                                        }
                                    }
                                }
                            ?>
                            <div class="col-sm-6 <?php echo e($lang['default'] == false ? 'd-none':''); ?> lang_form" id="<?php echo e($lang['code']); ?>-form">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?>

                                    (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                <input type="text" name="name[]" maxlength="255" value="<?php echo e($lang['code'] == 'en' ? $category['name'] : ($translate[$lang['code']]['name']??'')); ?>"
                                       class="form-control" <?php if($lang['status'] == true): ?>
                                           oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>
                                       placeholder="<?php echo e(translate('New Category')); ?>" <?php echo e($lang['status'] == true ? 'required':''); ?>>
                            </div>
                            <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="col-sm-6 lang_form" id="<?php echo e($defaultLanguage); ?>-form">
                                <label class="input-label"
                                        for="exampleFormControlInput1"><?php echo e(translate('name')); ?>

                                    (<?php echo e(strtoupper($defaultLanguage)); ?>)</label>
                                <input type="text" name="name[]" value="<?php echo e($category['name']); ?>"
                                        class="form-control" oninvalid="document.getElementById('en-link').click()"
                                        placeholder="<?php echo e(translate('New Category')); ?>" required>
                            </div>
                            <input type="hidden" name="lang[]" value="<?php echo e($defaultLanguage); ?>">
                        <?php endif; ?>
                        <input name="position" value="0" hidden>
                        <?php if($category->parent_id == 0): ?>
                        <div class="col-sm-6">
                            <div class="text-center">
                                <img class="img--105" id="viewer"
                                    src="<?php echo e($category->imageFullPath); ?>"
                                     alt="<?php echo e(translate('category')); ?>"/>
                            </div>
                            <label><?php echo e(translate('image')); ?></label><small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 3:1 )</small>
                            <div class="custom-file">
                                <input type="file" name="image" id="customFileEg1" class="custom-file-input"
                                        accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                <label class="custom-file-label" for="customFileEg1"><?php echo e(translate('choose')); ?> <?php echo e(translate('file')); ?></label>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-12">
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/category.js')); ?>"></script>
    <script>
        "use strict";

        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#"+lang+"-form").removeClass('d-none');
            if(lang == '<?php echo e($defaultLanguage); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/category/edit.blade.php ENDPATH**/ ?>