<?php $__env->startSection('title', translate('Refund policy')); ?>


<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <?php echo $__env->make('admin-views.business-settings.partial.page-setup-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h5 class="d-flex flex-wrap justify-content-end">
                        <label class="switch--custom-label toggle-switch toggle-switch-sm d-inline-flex">
                            <span class="mr-2 switch--custom-label-text text-primary on text-uppercase"><?php echo e(translate('on')); ?></span>
                            <span class="mr-2 switch--custom-label-text off text-uppercase"><?php echo e(translate('Status')); ?></span>
                            <input type="checkbox"
                                   data-route="<?php echo e(route('admin.business-settings.page-setup.refund-policy.status', [$status['value'] ? 0 : 1])); ?>"
                                   data-message="<?php echo e($status['value']? translate('you want to disable this page'): translate('you want to active this page')); ?>"
                                   class="toggle-switch-input status-change-alert" id="stocksCheckbox"
                                <?php echo e($status['value'] ? 'checked' : ''); ?>>
                            <span class="toggle-switch-label text">
                                <span class="toggle-switch-indicator"></span>
                            </span>
                        </label>
                    </h5>
                </div>
            </div>
        </div>
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <form action="<?php echo e(route('admin.business-settings.page-setup.refund-policy')); ?>" method="post" id="refund-form">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div id="editor" class="min-h-116px"><?php echo $data['value']; ?></div>
                        <textarea name="refund_policy" id="hiddenArea" style="display:none;"></textarea>
                    </div>

                    <div class="btn--container justify-content-end">
                        <button type="reset" class="btn btn--reset" id="reset"><?php echo e(translate('reset')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/quill-editor.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            var bn_quill = new Quill('#editor', {
                theme: 'snow'
            });

            $('#refund-form').on('submit', function () {
                var myEditor = document.querySelector('#editor');
                $('#hiddenArea').val(myEditor.children[0].innerHTML);
            });
        });
        $('#reset').click(function() {
            location.reload();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/refund-policy.blade.php ENDPATH**/ ?>