<?php $__env->startSection('title', translate('Update Category Discount')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/coupon.png')); ?>" class="w--20" alt="<?php echo e(translate('discount')); ?>">
                </span>
                <span>
                    <?php echo e(translate('discount update')); ?>

                </span>
            </h1>
        </div>
        <div class="card mb-3">
            <div class="card-body">
                <form action="<?php echo e(route('admin.discount.update', [$discount['id']])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="form-group mb-0">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?></label>
                                <input type="text" name="name" value="<?php echo e($discount->name); ?>" class="form-control" placeholder="<?php echo e(translate('New discount')); ?>" maxlength="255" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group mb-0" id="type-category">
                                <label class="input-label" for="exampleFormControlSelect1"><?php echo e(translate('category')); ?> <span
                                        class="input-label-secondary">*</span></label>
                                <select name="category_id" class="form-control js-select2-custom">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category['id']); ?>" <?php echo e($category['id'] == $discount['category_id'] ? 'selected' : ''); ?>><?php echo e($category['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('start')); ?> <?php echo e(translate('date')); ?></label>
                                <label class="input-date">
                                    <input type="text" name="start_date" value="<?php echo e(date('Y/m/d',strtotime($discount['start_date']))); ?>"
                                           id="start_date"
                                           class="js-flatpickr form-control flatpickr-custom"
                                           placeholder="<?php echo e(translate('dd/mm/yy')); ?>"
                                           data-hs-flatpickr-options='{ "dateFormat": "Y/m/d", "minDate": "today" }' required>
                                </label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('expire')); ?> <?php echo e(translate('date')); ?></label>
                                <label class="input-date">
                                    <input type="text" name="expire_date" value="<?php echo e(date('Y/m/d',strtotime($discount['expire_date']))); ?>"
                                           id="expire_date"
                                           class="js-flatpickr form-control flatpickr-custom"
                                           placeholder="<?php echo e(translate('dd/mm/yy')); ?>"
                                           data-hs-flatpickr-options='{ "dateFormat": "Y/m/d", "minDate": "today" }' required>
                                </label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group mb-0">
                                <label class="input-label" for="exampleFormControlSelect1"><?php echo e(translate('discount')); ?> <?php echo e(translate('type')); ?><span
                                        class="input-label-secondary">*</span></label>
                                <select name="discount_type" class="form-control change-discount-type" id="discount_type">
                                    <option value="percent" <?php echo e($discount['discount_type'] == 'percent'? 'selected' : ''); ?>><?php echo e(translate('percent')); ?></option>
                                    <option value="amount" <?php echo e($discount['discount_type'] == 'amount'? 'selected' : ''); ?>><?php echo e(translate('amount')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group mb-0">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('discount_amount')); ?></label>
                                <input type="number" step="0.1" name="discount_amount" value="<?php echo e($discount['discount_amount']); ?>" class="form-control" placeholder="<?php echo e(translate('discount_amount')); ?>" required>
                            </div>
                        </div>
                        <div class="col-6" id="max_amount_div">
                            <div class="form-group mb-0">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('maximum_amount')); ?></label>
                                <input type="number" step="0.1" name="maximum_amount" value="<?php echo e($discount['maximum_amount']); ?>" class="form-control" placeholder="<?php echo e(translate('maximum_amount')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="btn--container justify-content-end">
                            <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/discount.js')); ?>"></script>
    <script>
        let selected_type = $("#discount_type").val();
        $(document).ready(function() {
            if (selected_type === 'amount') {
                $("#max_amount_div").hide();
            } else {
                $("#max_amount_div").show();
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/discount/edit.blade.php ENDPATH**/ ?>