<?php $__env->startSection('title', translate('Customer_Search_Analytics')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/analytics_logo.png')); ?>" class="w--20" alt="<?php echo e(translate('analytics')); ?>">
                </span>
                <span>
                    <?php echo e(translate('Customer_Search_Analytics')); ?>

                </span>
            </h1>
        </div>

        <div class="row gy-3">
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex flex-wrap justify-content-between gap-3 mb-4">
                            <div class="">
                                <h4 class="mb-1"><?php echo e(translate('Top 5 Customer')); ?></h4>
                                <p class="fs-12"><?php echo e(translate('According to search volume')); ?></p>
                            </div>
                            <div class="select-wrap d-flex flex-wrap gap-10">
                                <select class="form-control js-select2-custom min-w180 h-30 top-customers__select">
                                    <option value="today" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='today'?'selected':''); ?>><?php echo e(translate('Today')); ?></option>
                                    <option value="all_time" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='all_time'?'selected':''); ?>><?php echo e(translate('All_Time')); ?></option>
                                    <option value="this_week" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_week'?'selected':''); ?>><?php echo e(translate('This_Week')); ?></option>
                                    <option value="last_week" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_week'?'selected':''); ?>><?php echo e(translate('Last_Week')); ?></option>
                                    <option value="this_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_month'?'selected':''); ?>><?php echo e(translate('This_Month')); ?></option>
                                    <option value="last_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_month'?'selected':''); ?>><?php echo e(translate('Last_Month')); ?></option>
                                    <option value="last_15_days" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_15_days'?'selected':''); ?>><?php echo e(translate('Last_15_Days')); ?></option>
                                    <option value="this_year" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year'?'selected':''); ?>><?php echo e(translate('This_Year')); ?></option>
                                    <option value="last_year" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_year'?'selected':''); ?>><?php echo e(translate('Last_Year')); ?></option>
                                    <option value="last_6_month" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='last_6_month'?'selected':''); ?>><?php echo e(translate('Last_6_Month')); ?></option>
                                    <option value="this_year_1st_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_1st_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_1st_Quarter')); ?></option>
                                    <option value="this_year_2nd_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_2nd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_2nd_Quarter')); ?></option>
                                    <option value="this_year_3rd_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_3rd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_3rd_Quarter')); ?></option>
                                    <option value="this_year_4th_quarter" <?php echo e(array_key_exists('date_range', $queryParams) && $queryParams['date_range']=='this_year_4th_quarter'?'selected':''); ?>><?php echo e(translate('this_year_4th_quarter')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="">
                            <?php if(count($graphData['search_volume']) < 1 && count($graphData['top_customers']) < 1): ?>
                                <span><?php echo e(translate('No data available')); ?></span>
                            <?php endif; ?>
                            <div id="apex_donut-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex flex-wrap justify-content-between gap-3">
                            <div class="">
                                <h4 class="mb-1"><?php echo e(translate('Top Products')); ?></h4>
                                <p class="fs-12"><?php echo e(translate('According to search volume')); ?></p>
                            </div>
                            <div class="select-wrap d-flex flex-wrap gap-10">
                                <select class="form-control js-select2-custom min-w180 h-30 top-services__select">
                                    <option value="today" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='today'?'selected':''); ?>><?php echo e(translate('Today')); ?></option>
                                    <option value="all_time" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='all_time'?'selected':''); ?>><?php echo e(translate('All_Time')); ?></option>
                                    <option value="this_week" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_week'?'selected':''); ?>><?php echo e(translate('This_Week')); ?></option>
                                    <option value="last_week" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_week'?'selected':''); ?>><?php echo e(translate('Last_Week')); ?></option>
                                    <option value="this_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_month'?'selected':''); ?>><?php echo e(translate('This_Month')); ?></option>
                                    <option value="last_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_month'?'selected':''); ?>><?php echo e(translate('Last_Month')); ?></option>
                                    <option value="last_15_days" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_15_days'?'selected':''); ?>><?php echo e(translate('Last_15_Days')); ?></option>
                                    <option value="this_year" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year'?'selected':''); ?>><?php echo e(translate('This_Year')); ?></option>
                                    <option value="last_year" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_year'?'selected':''); ?>><?php echo e(translate('Last_Year')); ?></option>
                                    <option value="last_6_month" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='last_6_month'?'selected':''); ?>><?php echo e(translate('Last_6_Month')); ?></option>
                                    <option value="this_year_1st_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_1st_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_1st_Quarter')); ?></option>
                                    <option value="this_year_2nd_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_2nd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_2nd_Quarter')); ?></option>
                                    <option value="this_year_3rd_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_3rd_quarter'?'selected':''); ?>><?php echo e(translate('This_Year_3rd_Quarter')); ?></option>
                                    <option value="this_year_4th_quarter" <?php echo e(array_key_exists('date_range_2', $queryParams) && $queryParams['date_range_2']=='this_year_4th_quarter'?'selected':''); ?>><?php echo e(translate('this_year_4th_quarter')); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="mt-4">
                            <div class="">
                                <ul class="common-list after-none gap-10 d-flex flex-column list-unstyled">
                                    <?php $__empty_1 = true; $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($item->product): ?>
                                            <li>
                                                <div class="mb-2 d-flex align-items-center justify-content-between gap-10 flex-wrap">
                                                    <span class="zone-name"><?php echo e($item->product->name); ?></span>
                                                    <span class="booking-count"><?php echo e(number_format(($item['count']*100)/$total)); ?>%</span>
                                                </div>
                                                <div class="progress">
                                                    <div class="progress-bar" role="progressbar"
                                                         style="width: <?php echo e(($item['count']*100)/$total); ?>%"
                                                         aria-valuenow="25" aria-valuemin="0"
                                                         aria-valuemax="100"></div>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <li>
                                            <div class="mb-2 d-flex align-items-center justify-content-between gap-10 flex-wrap">
                                                <span class="zone-name"><?php echo e(translate('No data available')); ?></span>
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div class="card--header">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group">
                            <input id="datatableSearch_" type="search" name="search"
                                   class="form-control"
                                   placeholder="<?php echo e(translate('search_by_Customer_Info')); ?>"
                                   aria-label="Search"
                                   value="<?php echo e($search??''); ?>" required autocomplete="off">
                            <div class="input-group-append">
                                <button type="submit" class="input-group-text">
                                    <?php echo e(translate('Search')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div>
                    <button type="button" class="btn btn-outline--primary text-nowrap btn-block"
                            data-toggle="dropdown">
                        <i class="tio-download-to"></i>
                        <?php echo e(translate('Export')); ?>

                        <i class="tio-chevron-down"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-right">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('admin.analytics.customer.export.excel')); ?>"><?php echo e(translate('Excel')); ?></a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table
                    class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('Customer')); ?></th>
                        <th class="text-center"><?php echo e(translate('Search')); ?> <br> <?php echo e(translate('Volume')); ?></th>
                        <th class="text-center"><?php echo e(translate('Related')); ?> <br> <?php echo e(translate('Categories')); ?></th>
                        <th class="text-center"><?php echo e(translate('Related')); ?> <br> <?php echo e(translate('Products')); ?></th>
                        <th class="text-center"><?php echo e(translate('Times Product')); ?> <br> <?php echo e(translate('Visited')); ?></th>
                        <th class="text-center"><?php echo e(translate('Total')); ?> <br> <?php echo e(translate('Orders')); ?></th>
                        <th class="text-center"><?php echo e(translate('Action')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $customersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($customersData->firstitem()+$key); ?></td>
                            <td>
                                <div class="media align-items-center gap-3 max-content">
                                    <div class="avatar avatar-lg">
                                        <a href="<?php echo e($value->customer ? route('admin.customer.view',[$value->customer['id']]) : '#'); ?>" class="product-list-media">
                                            <img class="rounded-full"
                                                 src="<?php echo e($value->customer->imageFullPath ?? asset('public/assets/admin/img/160x160/2.png')); ?>"
                                                alt="<?php echo e(translate('customer')); ?>">
                                        </a>
                                    </div>
                                    <div class="media-body">
                                        <h5 class="title m-0">
                                            <?php echo e($value->customer ? $value->customer['f_name']." ".$value->customer['l_name'] : 'Customer Deleted'); ?>

                                        </h5>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center"><?php echo e($value->search_volume??0); ?></td>
                            <td class="text-center">
                                <a href="#" data-toggle="tooltip" data-html="true" data-placement="right" title="
                                        <?php
                                           if (isset($value->related_category)){
                                                $categories = json_decode($value->related_category);
                                                foreach ($categories as $category) {
                                                    echo $category->category? $category->category->name. '<br>' : '' ;
                                                }
                                           }
                                        ?>">
                                    <?php echo e($value->related_category_count??0); ?>

                                </a>
                            </td>
                            <td class="text-center"><?php echo e($value->related_product_count??0); ?></td>
                            <td class="text-center"><?php echo e($value->visited_products_count??0); ?></td>
                            <td class="text-center"><?php echo e($value->orders_count??0); ?></td>
                            <td>
                                <div class="table-actions d-flex justify-content-center">
                                    <button class="btn btn-sm btn-white" id="customer-<?php echo e($value->user_id); ?>" type="button"
                                            data-toggle="modal" data-target="#customer-view-<?php echo e($value->user_id); ?>"
                                            title="<?php echo e(translate('view')); ?>">
                                        <i class="tio-visible"></i><?php echo e(translate('view')); ?>

                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <table>
                    <tfoot>
                    <?php echo $customersData->links(); ?>

                    </tfoot>
                    <?php if(count($customersData) == 0): ?>
                        <div class="text-center p-4">
                            <img class="w-120px mb-3"
                                 src="<?php echo e(asset('/public/assets/admin/svg/illustrations/sorry.svg')); ?>"
                                 alt="<?php echo e(translate('image')); ?>">
                            <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                        </div>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>

    <?php $__currentLoopData = $customersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="customer-view-<?php echo e($customer->user_id); ?>" tabindex="-1">

            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e($customer->Customer ? $customer->Customer['f_name'].' '.$customer->Customer['l_name'] : 'Customer Deleted'); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="rest-part">
                        </div>
                        <div class="card-body pt-0">
                            <div>
                                <p><strong><?php echo e(translate('Search Volume')); ?>:</strong> <?php echo e($customer->search_volume); ?></p>
                                <p><strong><?php echo e(translate('Related Categories')); ?>:</strong> <?php echo e($customer->related_category_count); ?></p>
                                <ul>
                                        <?php
                                        if (isset($customer->related_category)){
                                            $categories = json_decode($customer->related_category);
                                            foreach ($categories as $cat) {
                                                echo $cat->category? $cat->category->name. '<br>' : '' ;
                                            }
                                        }
                                        ?>
                                </ul>
                                <p><strong><?php echo e(translate('Related Products')); ?>:</strong> <?php echo e($customer->related_product_count); ?></p>
                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="button" class="btn btn--danger text-white" data-dismiss="modal" aria-label="Close">
                                    <?php echo e(translate('close')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('/public/assets/admin/js/apex-charts/apexcharts.js')); ?>"></script>
    <script>
        "use strict";

        var options = {
            series: <?php echo json_encode($graphData['search_volume'], 15, 512) ?>,
            chart: {
                type: 'donut',
                width: "100%",
                height: 400
            },
            labels: <?php echo json_encode(count($graphData['top_customers']) > 0 ? $graphData['top_customers'] : '', 15, 512) ?>,
            legend: {
                show: true,
                floating: false,
                fontSize: '14px',
                position: 'right',
                horizontalAlign: 'center',
                offsetY: -10,
                itemMargin: {
                    horizontal: 5,
                    vertical: 10
                },
            },
            responsive: [{
                breakpoint: 1400,
                options: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }]
        };

        var chart = new ApexCharts(document.querySelector("#apex_donut-chart"), options);
        chart.render();
    </script>

    <script>
        $(".top-customers__select").on('change', function () {
            if (this.value !== "") location.href = "<?php echo e(route('admin.analytics.customer-search')); ?>" + '?date_range=' + this.value + '&date_range_2=' + '<?php echo e($queryParams['date_range_2']??'all_time'); ?>';
        });
        $(".top-services__select").on('change', function () {
            if (this.value !== "") location.href = "<?php echo e(route('admin.analytics.customer-search')); ?>" + '?date_range=' + '<?php echo e($queryParams['date_range']??'all_time'); ?>' + '&date_range_2=' + this.value;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/analytics/customer-search.blade.php ENDPATH**/ ?>