<?php $__env->startSection('title', translate('invoice')); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid initial-38">
        <div class="row justify-content-center" id="printableArea">
            <div class="col-md-12">
                <div class="text-center">
                    <input type="button" class="btn btn--primary non-printable text-white" data-type="printableArea" id="printableSection"
                           value="<?php echo e(translate('Proceed, If thermal printer is ready.')); ?>"/>
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn--danger non-printable text-white"><?php echo e(translate('Back')); ?></a>
                </div>
                <hr class="non-printable">
            </div>
            <?php ($logo=\App\Model\BusinessSetting::where(['key'=>'logo'])->first()->value); ?>
            <div class="initial-38-1">
                <div class="pt-3">
                    <div class="pt-3">
                        <img class="initial-38-2"
                             src="<?php echo e(App\CentralLogics\Helpers::onErrorImage($logo, asset('storage/app/public/restaurant') . '/' . $logo, asset('/public/assets/admin/img/food.png'), 'restaurant/')); ?>"
                             alt="<?php echo e(translate('logo')); ?>">
                    </div>
                </div>
                <div class="text-center pt-2 mb-3">
                    <h2  class="initial-38-3"><?php echo e($order->branch->name); ?></h2>
                    <h5 class="text-break initial-38-4">
                        <?php echo e($order->branch->address); ?>

                    </h5>
                    <h5 class="initial-38-4 initial-38-3">
                        <?php echo e(translate('Phone')); ?> : <?php echo e(\App\Model\BusinessSetting::where(['key'=>'phone'])->first()->value); ?>

                    </h5>
                    <?php if($order->branch->gst_status): ?>
                        <h5 class="initial-38-4 initial-38-3 fz-12px">
                            <?php echo e(translate('Gst No')); ?> : <?php echo e($order->branch->gst_code); ?>

                        </h5>
                    <?php endif; ?>
                </div>
                <span class="initial-38-5">---------------------------------------------------------------------------------</span>
                <div class="row mt-3">
                    <div class="col-6">
                        <h5><?php echo e(translate('Order ID')); ?> :
                            <span class="font-light"> <?php echo e($order['id']); ?></span>
                        </h5>
                    </div>
                    <div class="col-6">
                        <h5>
                            <span class="font-light">
                            <?php echo e(date('d M Y h:i a',strtotime($order['created_at']))); ?>

                            </span>
                        </h5>
                    </div>
                    <div class="col-12">
                        <?php if($order->is_guest == 0): ?>
                            <?php if(isset($order->customer)): ?>
                                <h5>
                                    <?php echo e(translate('Customer Name')); ?> :<span class="font-light"><?php echo e($order->customer['f_name'].' '.$order->customer['l_name']); ?></span>
                                </h5>
                                <h5>
                                    <?php echo e(translate('phone')); ?> :<span class="font-light"><?php echo e($order->customer['phone']); ?></span>
                                </h5>
                                <?php ($address=\App\Model\CustomerAddress::find($order['delivery_address_id'])); ?>
                                <h5 class="text-break">
                                    <?php echo e(translate('address')); ?> :<span class="font-light"><?php echo e(isset($address)?$address['address']:''); ?></span>
                                </h5>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if($order->order_type == 'delivery'): ?>
                                <?php if(isset($order->delivery_address)): ?>
                                    <h5>
                                        <?php echo e(translate('Customer Name')); ?> :<span class="font-light"><?php echo e($order->delivery_address['contact_person_name']); ?></span>
                                    </h5>
                                    <h5>
                                        <?php echo e(translate('Customer Name')); ?> :<span class="font-light"><?php echo e($order->delivery_address['contact_person_number']); ?></span>
                                    </h5>
                                    <h5 class="text-break">
                                        <?php echo e(translate('address')); ?> :<span class="font-light"><?php echo e($order->delivery_address['address']); ?></span>
                                    </h5>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($order['bring_change_amount']): ?>
                    <h6><strong><?php echo e(translate('Bring Change Note')); ?></strong>: <span class=""><?php echo e(translate('Please ensure the Deliveryman has '). \App\CentralLogics\Helpers::set_symbol($order['bring_change_amount']) . translate(' in change ready for the customer')); ?></span></h6>
                <?php endif; ?>
                <h5 class="text-uppercase"></h5>
                <span class="initial-38-5">---------------------------------------------------------------------------------</span>
                <table class="table table-bordered mt-3">
                    <thead>
                    <tr>
                        <th class="initial-38-6 border-top-0 border-bottom-0"><?php echo e(translate('QTY')); ?></th>
                        <th class="initial-38-7 border-top-0 border-bottom-0"><?php echo e(translate('DESC')); ?></th>
                        <th class="initial-38-7 border-top-0 border-bottom-0"><?php echo e(translate('Price')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php ($subTotal=0); ?>
                    <?php ($totalTax=0); ?>
                    <?php ($total_dis_on_pro=0); ?>
                    <?php ($updatedTotalTax=0); ?>
                    <?php ($vatStatus = ''); ?>
                    <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if($detail->product_details !=null): ?>
                            <?php ($product = json_decode($detail->product_details, true)); ?>
                            <tr>
                                <td class="">
                                    <?php echo e($detail['quantity']); ?>

                                </td>
                                <td class="">
                                    <?php echo e($product['name']); ?> <br>
                                    <?php if(count(json_decode($detail['variation'],true))>0): ?>
                                        <strong><u>Variation : </u></strong>
                                        <?php $__currentLoopData = json_decode($detail['variation'],true)[0] ?? json_decode($detail['variation'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="font-size-sm text-body">
                                                <span class="text-capitalize"><?php echo e($key1); ?> :  </span>
                                                <span class="font-weight-bold"><?php echo e($variation); ?> <?php echo e($key1=='price'?\App\CentralLogics\Helpers::currency_symbol():''); ?></span>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    <span><?php echo e(translate('Unit Price')); ?> : <?php echo e(Helpers::set_symbol($detail['price'])); ?></span><br>
                                    <span><?php echo e(translate('Qty')); ?> : <?php echo e($detail['quantity']); ?></span><br>
                                    <span><?php echo e(translate('Discount')); ?> : <?php echo e(Helpers::set_symbol($detail['discount_on_product'])); ?></span>

                                </td>
                                <td class="w-28p">
                                    <?php ($amount=($detail['price']-$detail['discount_on_product'])*$detail['quantity']); ?>
                                    <?php echo e(Helpers::set_symbol($amount)); ?>

                                </td>
                            </tr>

                            <?php ($subTotal+=$amount); ?>
                            <?php ($totalTax+=$detail['tax_amount']*$detail['quantity']); ?>
                            <?php ($updatedTotalTax+= $detail['vat_status'] === 'included' ? 0 : $detail['tax_amount']*$detail['quantity']); ?>
                            <?php ($vatStatus = $detail['vat_status']); ?>

                        <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="px-3">
                    <dl class="row text-right justify-content-center">
                        <dt class="col-6"><?php echo e(translate('Items Price')); ?>:</dt>
                        <dd class="col-6"><?php echo e(Helpers::set_symbol($subTotal)); ?></dd>
                        <dt class="col-6"><?php echo e(translate('Tax / VAT')); ?> <?php echo e($vatStatus == 'included' ? translate('(included)') : ''); ?>:</dt>
                        <dd class="col-6"><?php echo e(Helpers::set_symbol($totalTax)); ?></dd>

                        <dt class="col-6"><?php echo e(translate('Subtotal')); ?>:</dt>
                        <dd class="col-6">
                            <?php echo e(Helpers::set_symbol($subTotal+$updatedTotalTax)); ?></dd>
                        <dt class="col-6"><?php echo e(translate('Coupon Discount')); ?>:</dt>
                        <dd class="col-6">
                            - <?php echo e(Helpers::set_symbol($order['coupon_discount_amount'])); ?></dd>
                        <dt class="col-6"><?php echo e(translate('extra Discount')); ?>:</dt>
                        <dd class="col-6">
                            - <?php echo e(Helpers::set_symbol($order['extra_discount'])); ?></dd>
                        <dt class="col-6"><?php echo e(translate('Delivery Fee')); ?>:</dt>
                        <dd class="col-6">
                            <?php if($order['order_type']=='take_away'): ?>
                                <?php ($del_c=0); ?>
                            <?php else: ?>
                                <?php ($del_c=$order['delivery_charge']); ?>
                            <?php endif; ?>
                            <?php echo e(Helpers::set_symbol($del_c+$order['weight_charge_amount'])); ?>

                            <hr>
                        </dd>

                        <dt class="col-6 font-20px"><?php echo e(translate('Total')); ?>:</dt>
                        <dd class="col-6 font-20px"><?php echo e(Helpers::set_symbol($subTotal+$del_c+$updatedTotalTax-$order['coupon_discount_amount']-$order['extra_discount']+$order['weight_charge_amount'])); ?></dd>

                        <?php if($order->order_change_amount()->exists()): ?>
                            <dt class="col-6"><?php echo e(translate('Paid Amount')); ?><span>:</span></dt>
                            <dd class="col-6"><?php echo e(\App\CentralLogics\Helpers::set_symbol($order->order_change_amount?->paid_amount)); ?></dd>

                            <?php ($changeOrDueAmount = $order->order_change_amount?->paid_amount - $order->order_change_amount?->order_amount); ?>
                            <dt class="col-6"><?php echo e($changeOrDueAmount < 0 ? translate('Due Amount') : translate('Change Amount')); ?><span>:</span></dt>
                            <dd class="col-6"><?php echo e(\App\CentralLogics\Helpers::set_symbol($changeOrDueAmount)); ?></dd>
                        <?php endif; ?>
                    </dl>
                    <span class="initial-38-5">---------------------------------------------------------------------------------</span>
                    <h5 class="text-center pt-1">
                        <span class="d-block">"""<?php echo e(translate('THANK YOU')); ?>"""</span>
                    </h5>
                    <span class="initial-38-5">---------------------------------------------------------------------------------</span>
                    <span class="d-block text-center"><?php echo e($footer_text->value); ?></span>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/jquery.js')); ?>"></script>
    <script>
        "use strict";

        $(document).ready(function() {
            "use strict";
            $('#printableSection').on('click', function() {
                var type = $(this).data('type');
                printDiv(type);
            });

            function printDiv(divName) {
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/order/invoice.blade.php ENDPATH**/ ?>