<?php $__env->startSection('title', translate('Product Setup')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <?php echo $__env->make('admin-views.business-settings.partial.business-settings-navmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="business-setting">
            <div class="card">

                <div class="card-body">
                    <form action="<?php echo e(route('admin.business-settings.store.order-setup-update')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-4 pt-5">
                                <?php
                                $max_amount_status=\App\CentralLogics\Helpers::get_business_settings('maximum_amount_for_cod_order_status');
                                $max_status = $max_amount_status == 1 ? 0 : 1;
                                ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                                <span class="line--limit-1">
                                                    <strong><?php echo e(translate('Maximum Amount for COD Order Status')); ?></strong>
                                                </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right" data-original-title="<?php echo e(translate('If this field is active the maximum amount for Cash on Delivery order is apply')); ?>"><img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" class="toggle-switch-input" name="maximum_amount_for_cod_order_status" <?php echo e($max_amount_status == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>
                            <?php ($maximum_amount_for_cod_order=\App\CentralLogics\Helpers::get_business_settings('maximum_amount_for_cod_order')); ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group mb-0">
                                    <label class="input-label text-capitalize"><?php echo e(translate('Maximum Amount for COD Order')); ?>

                                        <i class="tio-info-outined"
                                           data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?php echo e(translate('The maximum amount for Cash on Delivery order.')); ?>"></i>
                                    </label>
                                    <input type="number" value="<?php echo e($maximum_amount_for_cod_order); ?>"  step="0.1" name="maximum_amount_for_cod_order" class="form-control" placeholder=""
                                           <?php echo e($max_amount_status == 0 ? 'readonly' : ''); ?> required>
                                </div>
                            </div>

                            <?php ($mov=\App\Model\BusinessSetting::where('key','minimum_order_value')->first()->value); ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('min order value')); ?>( <?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?> )</label>
                                    <input type="number" min="1" value="<?php echo e($mov); ?>"
                                         step="0.1"  name="minimum_order_value" class="form-control" placeholder="" required>
                                </div>
                            </div>

                            <div class="col-md-4 pt-5">
                                <?php
                                $orderImageStatus=\App\CentralLogics\Helpers::get_business_settings('order_image_status');
                                ?>
                                <div class="form-group">
                                    <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between border rounded px-3 py-0 form-control">
                                            <span class="pr-1 d-flex align-items-center switch--label">
                                                <span class="line--limit-1">
                                                    <strong><?php echo e(translate('Order Image Status')); ?></strong>
                                                </span>
                                                <span class="form-label-secondary text-danger d-flex ml-1" data-toggle="tooltip" data-placement="right"
                                                      data-original-title="<?php echo e(translate('If this field is active the users can add image while placing an order')); ?>">
                                                    <img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                                </span>
                                            </span>
                                        <input type="checkbox" class="toggle-switch-input" name="order_image_status" <?php echo e($orderImageStatus == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                    </label>
                                </div>
                            </div>
                            <?php ($orderImageLabelName=\App\CentralLogics\Helpers::get_business_settings('order_image_label_name')); ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group mb-0">
                                    <label class="input-label text-capitalize"><?php echo e(translate('Order Image Label Name')); ?>

                                        <i class="tio-info-outined"
                                           data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?php echo e(translate('Order image label name. (ex: Prescription Image)')); ?>"></i>
                                    </label>
                                    <input type="text" value="<?php echo e($orderImageLabelName ?? ''); ?>" name="order_image_label_name" class="form-control"
                                           placeholder="<?php echo e(translate('prescription_image')); ?>" maxlength="30">
                                </div>
                            </div>
                        </div>

                        <div class="btn--container justify-content-end">
                            <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                    class="btn btn--primary call-demo"><?php echo e(translate('save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/order-setup-index.blade.php ENDPATH**/ ?>