<?php
ini_set('memory_limit', '-1');

?>


<?php $__env->startSection('title', translate('Order Report')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="media align-items-center mb-2">
                <div class="">
                    <img src="<?php echo e(asset('public/assets/admin/img/order-img.png')); ?>" class="w--20" alt="">
                </div>

                <div class="media-body pl-3">
                    <div class="row">
                        <div class="col-lg mb-3 mb-lg-0">
                            <h1 class="page-header-title"><?php echo e(translate('order')); ?> <?php echo e(translate('report')); ?> <?php echo e(translate('overview')); ?></h1>

                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <span><?php echo e(translate('admin')); ?>:</span>
                                    <a href="#"  class="text--primary-2"><?php echo e(auth('admin')->user()->f_name.' '.auth('admin')->user()->l_name); ?></a>
                                </div>

                                <div class="col-auto">
                                    <div class="row align-items-center g-0">
                                        <div class="col-auto pr-2"><?php echo e(translate('date :')); ?></div>
                                        <div class="text--primary-2">
                                            <?php echo e(session('from_date')); ?> - <?php echo e(session('to_date')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form action="<?php echo e(route('admin.report.set-date')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-12">
                            <div>
                                <label class="form-label mb-0 font-semibold"><?php echo e(translate('show')); ?> <?php echo e(translate('data')); ?> <?php echo e(translate('by')); ?> <?php echo e(translate('date')); ?>

                                    <?php echo e(translate('range')); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label"><?php echo e(translate('start')); ?> <?php echo e(translate('date')); ?></label>
                            <label class="input-date">
                                <input type="text" name="from" id="from_date"
                                       class="js-flatpickr form-control flatpickr-custom flatpickr-input" placeholder="<?php echo e(session('from_date')); ?>" required>
                            </label>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label"><?php echo e(translate('end')); ?> <?php echo e(translate('date')); ?></label>
                            <label class="input-date">
                                <input type="text" name="to" id="to_date"
                                       class="js-flatpickr form-control flatpickr-custom flatpickr-input" placeholder="<?php echo e(session('to_date')); ?>" required>
                            </label>
                        </div>
                        <div class="col-md-4">
                            <label class="input-label d-none d-md-block">&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn--primary min-h-45px btn-block"><?php echo e(translate('show')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row g-3 mt-3">

                    <?php
                        $from = session('from_date');
                        $to = session('to_date');
                        $total=\App\Model\Order::whereBetween('created_at', [$from, $to])->count();
                        if($total==0){
                        $total=.01;
                        }
                    ?>
                    <div class="col-sm-6 col-lg-3">
                    <?php
                        $delivered=\App\Model\Order::where(['order_status'=>'delivered'])->whereBetween('created_at', [$from, $to])->count()
                    ?>
                        <div class="card card-sm bg--2 border-0 shadow-none">
                            <div class="card-body py-5 px-xxl-5">
                                <div class="row g-2">
                                    <div class="col">
                                        <div class="media">
                                            <i class="tio-shopping-cart nav-icon"></i>

                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('delivered')); ?></h4>
                                                <span class="text-success">
                                                <i class="tio-trending-up"></i> <?php echo e($delivered); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                            "value": <?php echo e(round(($delivered/$total)*100)); ?>,
                                            "maxValue": 100,
                                            "duration": 2000,
                                            "isViewportInit": true,
                                            "colors": ["#a5e1cb", "#60d3a9"],
                                            "radius": 25,
                                            "width": 3,
                                            "fgStrokeLinecap": "round",
                                            "textFontSize": 14,
                                            "additionalText": "%",
                                            "textClass": "circle-custom-text",
                                            "textColor": "#60d3a9"
                                            }'></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                    <?php
                        $returned=\App\Model\Order::where(['order_status'=>'returned'])->whereBetween('created_at', [$from, $to])->count()
                    ?>
                        <div class="card card-sm bg--3 border-0 shadow-none">
                            <div class="card-body py-5 px-xxl-5">
                                <div class="row g-2">
                                    <div class="col">
                                        <div class="media">
                                            <i class="tio-shopping-cart-off nav-icon"></i>

                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('returned')); ?></h4>
                                                <span class="text-warning">
                                                <i class="tio-trending-up"></i> <?php echo e($returned); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                "value": <?php echo e(round(($returned/$total)*100)); ?>,
                                "maxValue": 100,
                                "duration": 2000,
                                "isViewportInit": true,
                                "colors": ["#ffc5c5", "#ff6e6e"],
                                "radius": 25,
                                "width": 3,
                                "fgStrokeLinecap": "round",
                                "textFontSize": 14,
                                "additionalText": "%",
                                "textClass": "circle-custom-text",
                                "textColor": "#ff6e6e"
                                }'></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                    <?php
                        $failed=\App\Model\Order::where(['order_status'=>'failed'])->whereBetween('created_at', [$from, $to])->count()
                    ?>
                        <div class="card card-sm bg--1 border-0 shadow-none">
                            <div class="card-body py-5 px-xxl-5">
                                <div class="row g-2">
                                    <div class="col">
                                        <div class="media">
                                            <i class="tio-message-failed nav-icon"></i>
                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('failed')); ?></h4>
                                                <span class="text-danger">
                                                <i class="tio-trending-up"></i> <?php echo e($failed); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                "value": <?php echo e(round(($failed/$total)*100)); ?>,
                                "maxValue": 100,
                                "duration": 2000,
                                "isViewportInit": true,
                                "colors": ["#abdcff", "#5bbbff"],
                                "radius": 25,
                                "width": 3,
                                "fgStrokeLinecap": "round",
                                "textFontSize": 14,
                                "additionalText": "%",
                                "textClass": "circle-custom-text",
                                "textColor": "#5bbbff"
                                }'></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                    <?php
                        $canceled=\App\Model\Order::where(['order_status'=>'canceled'])->whereBetween('created_at', [$from, $to])->count()
                    ?>
                        <div class="card card-sm bg--4 border-0 shadow-none">
                            <div class="card-body py-5 px-xxl-5">
                                <div class="row g-2">
                                    <div class="col">
                                        <div class="media">
                                            <i class="tio-flight-cancelled nav-icon"></i>

                                            <div class="media-body">
                                                <h4 class="mb-1"><?php echo e(translate('canceled')); ?></h4>
                                                <span class="text-muted">
                                                <i class="tio-trending-up"></i> <?php echo e($canceled); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-auto">
                                        <div class="js-circle"
                                            data-hs-circles-options='{
                                "value": <?php echo e(round(($canceled/$total)*100)); ?>,
                                "maxValue": 100,
                                "duration": 2000,
                                "isViewportInit": true,
                                "colors": ["#ffd4ae", "#ff7800"],
                                "radius": 25,
                                "width": 3,
                                "fgStrokeLinecap": "round",
                                "textFontSize": 14,
                                "additionalText": "%",
                                "textClass": "circle-custom-text",
                                "textColor": "#ff7800"
                                }'></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card mb-3 border-bottom border-right border-left border-top">
            <div class="card-header">
                <?php
                    $x=1;
                    $y=12;
                    $total=\App\Model\Order::whereBetween('created_at', [date('Y-'.$x.'-01'), date('Y-'.$y.'-30')])->count()
                ?>
                <h6 class="card-subtitle mb-0"><?php echo e(translate('total')); ?> <?php echo e(translate('orders')); ?> of <?php echo e(date('Y')); ?>: <span
                        class="h3 ml-sm-2"><?php echo e(round($total)); ?></span>
                </h6>

            </div>
        <?php
            $delivered=[];
                for ($i=1;$i<=12;$i++){
                    $from = date('Y-'.$i.'-01');
                    $to = date('Y-'.$i.'-30');
                    $delivered[$i]=\App\Model\Order::where(['order_status'=>'delivered'])->whereBetween('created_at', [$from, $to])->count();
                }
        ?>

        <?php
            $ret=[];
                for ($i=1;$i<=12;$i++){
                    $from = date('Y-'.$i.'-01');
                    $to = date('Y-'.$i.'-30');
                    $ret[$i]=\App\Model\Order::where(['order_status'=>'returned'])->whereBetween('created_at', [$from, $to])->count();
                }
        ?>

        <?php
            $fai=[];
                for ($i=1;$i<=12;$i++){
                    $from = date('Y-'.$i.'-01');
                    $to = date('Y-'.$i.'-30');
                    $fai[$i]=\App\Model\Order::where(['order_status'=>'failed'])->whereBetween('created_at', [$from, $to])->count();
                }
        ?>

        <?php
            $can=[];
                for ($i=1;$i<=12;$i++){
                    $from = date('Y-'.$i.'-01');
                    $to = date('Y-'.$i.'-30');
                    $can[$i]=\App\Model\Order::where(['order_status'=>'canceled'])->whereBetween('created_at', [$from, $to])->count();
                }
        ?>

            <div class="card-body">
                <div class="chartjs-custom h-18rem">
                    <canvas class="js-chart"
                            data-hs-chartjs-options='{
                        "type": "line",
                        "data": {
                           "labels": ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],
                           "datasets": [{
                            "data": [<?php echo e($delivered[1]); ?>,<?php echo e($delivered[2]); ?>,<?php echo e($delivered[3]); ?>,<?php echo e($delivered[4]); ?>,<?php echo e($delivered[5]); ?>,<?php echo e($delivered[6]); ?>,<?php echo e($delivered[7]); ?>,<?php echo e($delivered[8]); ?>,<?php echo e($delivered[9]); ?>,<?php echo e($delivered[10]); ?>,<?php echo e($delivered[11]); ?>,<?php echo e($delivered[12]); ?>],
                            "backgroundColor": ["rgba(55, 125, 255, 0)", "rgba(255, 255, 255, 0)"],
                            "borderColor": "#60d3a9",
                            "borderWidth": 2,
                            "pointRadius": 0,
                            "pointBorderColor": "#fff",
                            "pointBackgroundColor": "#60d3a9",
                            "pointHoverRadius": 0,
                            "hoverBorderColor": "#fff",
                            "hoverBackgroundColor": "#60d3a9"
                          },
                          {
                            "data": [<?php echo e($ret[1]); ?>,<?php echo e($ret[2]); ?>,<?php echo e($ret[3]); ?>,<?php echo e($ret[4]); ?>,<?php echo e($ret[5]); ?>,<?php echo e($ret[6]); ?>,<?php echo e($ret[7]); ?>,<?php echo e($ret[8]); ?>,<?php echo e($ret[9]); ?>,<?php echo e($ret[10]); ?>,<?php echo e($ret[11]); ?>,<?php echo e($ret[12]); ?>],
                            "backgroundColor": ["rgba(0, 201, 219, 0)", "rgba(255, 255, 255, 0)"],
                            "borderColor": "#ff6e6e",
                            "borderWidth": 2,
                            "pointRadius": 0,
                            "pointBorderColor": "#fff",
                            "pointBackgroundColor": "#ff6e6e",
                            "pointHoverRadius": 0,
                            "hoverBorderColor": "#fff",
                            "hoverBackgroundColor": "#ff6e6e"
                          },
                          {
                            "data": [<?php echo e($fai[1]); ?>,<?php echo e($fai[2]); ?>,<?php echo e($fai[3]); ?>,<?php echo e($fai[4]); ?>,<?php echo e($fai[5]); ?>,<?php echo e($fai[6]); ?>,<?php echo e($fai[7]); ?>,<?php echo e($fai[8]); ?>,<?php echo e($fai[9]); ?>,<?php echo e($fai[10]); ?>,<?php echo e($fai[11]); ?>,<?php echo e($fai[12]); ?>],
                            "backgroundColor": ["rgba(0, 201, 219, 0)", "rgba(255, 255, 255, 0)"],
                            "borderColor": "darkred",
                            "borderWidth": 2,
                            "pointRadius": 0,
                            "pointBorderColor": "#fff",
                            "pointBackgroundColor": "#00c9db",
                            "pointHoverRadius": 0,
                            "hoverBorderColor": "#fff",
                            "hoverBackgroundColor": "#00c9db"
                          },
                          {
                            "data": [<?php echo e($can[1]); ?>,<?php echo e($can[2]); ?>,<?php echo e($can[3]); ?>,<?php echo e($can[4]); ?>,<?php echo e($can[5]); ?>,<?php echo e($can[6]); ?>,<?php echo e($can[7]); ?>,<?php echo e($can[8]); ?>,<?php echo e($can[9]); ?>,<?php echo e($can[10]); ?>,<?php echo e($can[11]); ?>,<?php echo e($can[12]); ?>],
                            "backgroundColor": ["rgba(0, 201, 219, 0)", "rgba(255, 255, 255, 0)"],
                            "borderColor": "gray",
                            "borderWidth": 2,
                            "pointRadius": 0,
                            "pointBorderColor": "#fff",
                            "pointBackgroundColor": "#ff7800",
                            "pointHoverRadius": 0,
                            "hoverBorderColor": "#fff",
                            "hoverBackgroundColor": "#ff7800"
                          }]
                        },
                        "options": {
                          "gradientPosition": {"y1": 200},
                           "scales": {
                              "yAxes": [{
                                "gridLines": {
                                  "color": "#e7eaf3",
                                  "drawBorder": false,
                                  "zeroLineColor": "#e7eaf3"
                                },
                                "ticks": {
                                  "min": 0,
                                  "max": <?php echo e(\App\CentralLogics\Helpers::max_orders()); ?>,
                                  "stepSize": <?php echo e(round(\App\CentralLogics\Helpers::max_orders()/4)); ?>,
                                  "fontColor": "#97a4af",
                                  "fontFamily": "Open Sans, sans-serif",
                                  "padding": 10,
                                  "postfix": ""
                                }
                              }],
                              "xAxes": [{
                                "gridLines": {
                                  "display": false,
                                  "drawBorder": false
                                },
                                "ticks": {
                                  "fontSize": 12,
                                  "fontColor": "#97a4af",
                                  "fontFamily": "Open Sans, sans-serif",
                                  "padding": 5
                                }
                              }]
                          },
                          "tooltips": {
                            "prefix": "",
                            "postfix": "",
                            "hasIndicator": true,
                            "mode": "index",
                            "intersect": false,
                            "lineMode": true,
                            "lineWithLineColor": "rgba(19, 33, 68, 0.075)"
                          },
                          "hover": {
                            "mode": "nearest",
                            "intersect": true
                          }
                        }
                      }'>
                    </canvas>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 mb-3 mb-lg-12">
                <div class="card h-100">
                    <div class="card-header flex-wrap __gap-2">
                        <h4 class="card-header-title"><?php echo e(translate('weekly')); ?> <?php echo e(translate('report')); ?></h4>
                        <ul class="nav nav-segment" id="eventsTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="this-week-tab" data-toggle="tab" href="#this-week"
                                   role="tab">
                                    <?php echo e(translate('this')); ?> <?php echo e(translate('week')); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="last-week-tab" data-toggle="tab" href="#last-week" role="tab">
                                    <?php echo e(translate('last')); ?> <?php echo e(translate('week')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body card-body-height">
                    <?php
                        $orders= \App\Model\Order::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->get();
                    ?>
                        <div class="tab-content" id="eventsTabContent">
                            <div class="tab-pane fade show active" id="this-week" role="tabpanel"
                                 aria-labelledby="this-week-tab">
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="card card-border-left border-left-primary shadow-none rounded-0"
                                       href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>">
                                        <div class="card-body py-0">
                                            <div class="row">
                                                <div class="col-sm mb-2 mb-sm-0">
                                                    <h2 class="font-weight-normal mb-1">#<?php echo e($order['id']); ?> <small
                                                            class="text-body text-uppercase"><?php echo e(translate('id')); ?></small>
                                                    </h2>
                                                    <h5 class="text-hover-primary mb-0"><?php echo e(translate('order')); ?> <?php echo e(translate('amount')); ?>

                                                        : <?php echo e(Helpers::set_symbol($order['order_amount'])); ?></h5>
                                                    <small
                                                        class="text-body"><?php echo e(date('d M Y',strtotime($order['created_at']))); ?></small>
                                                </div>

                                                <div class="col-sm-auto align-self-sm-end">
                                                    <div class="">
                                                        <?php echo e(translate('status')); ?> <strong> : <?php echo e($order['order_status'] == 'processing' ? translate('packaging') : translate($order['order_status'])); ?> <br></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <hr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php
                                $orders= \App\Model\Order::whereBetween('created_at', [now()->subDays(7)->startOfWeek(), now()->subDays(7)->endOfWeek()])->get();
                            ?>

                            <div class="tab-pane fade" id="last-week" role="tabpanel" aria-labelledby="last-week-tab">
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="card card-border-left border-left-primary shadow-none rounded-0"
                                       href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>">
                                        <div class="card-body py-0">
                                            <div class="row">
                                                <div class="col-sm mb-2 mb-sm-0">
                                                    <h2 class="font-weight-normal mb-1">#<?php echo e($order['id']); ?> <small
                                                            class="text-body text-uppercase"><?php echo e(translate('id')); ?></small>
                                                    </h2>
                                                    <h5 class="text-hover-primary mb-0"><?php echo e(translate('order')); ?> <?php echo e(translate('amount')); ?>

                                                        : <?php echo e(Helpers::set_symbol($order['order_amount'])); ?></h5>
                                                    <small
                                                        class="text-body"><?php echo e(date('d M Y',strtotime($order['created_at']))); ?></small>
                                                </div>

                                                <div class="col-sm-auto align-self-sm-end">
                                                    <div class="">
                                                        <?php echo e(translate('status')); ?> <strong> : <?php echo e($order['order_status'] == 'processing' ? translate('packaging') : translate($order['order_status'])); ?> <br></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <hr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>

    <script src="<?php echo e(asset('public/assets/admin')); ?>/vendor/chart.js/dist/Chart.min.js"></script>
    <script
        src="<?php echo e(asset('public/assets/admin')); ?>/vendor/chartjs-chart-matrix/dist/chartjs-chart-matrix.min.js"></script>
    <script src="<?php echo e(asset('public/assets/admin')); ?>/js/hs.chartjs-matrix.js"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/flatpicker.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/order-report.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/report/order-index.blade.php ENDPATH**/ ?>