<?php $__env->startSection('title', translate('Update Coupon')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/edit.png')); ?>" class="w--20" alt="<?php echo e(translate('coupon')); ?>">
                </span>
                <span>
                    <?php echo e(translate('coupon')); ?> <?php echo e(translate('update')); ?>

                </span>
            </h1>
        </div>
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-body p-xl-30">
                        <form action="<?php echo e(route('admin.coupon.update',[$coupon['id']])); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row gx--3">
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('coupon')); ?> <?php echo e(translate('type')); ?></label>
                                        <select name="coupon_type" class="form-control coupon-type">
                                            <option value="default" <?php echo e($coupon['coupon_type']=='default'?'selected':''); ?>><?php echo e(translate('default')); ?></option>
                                            <option value="first_order" <?php echo e($coupon['coupon_type']=='first_order'?'selected':''); ?>><?php echo e(translate('first')); ?> <?php echo e(translate('order')); ?></option>
                                            <option value="free_delivery" <?php echo e($coupon['coupon_type']=='free_delivery'?'selected':''); ?>><?php echo e(translate('free_delivery')); ?></option>
                                            <option value="customer_wise" <?php echo e($coupon['coupon_type']=='customer_wise'?'selected':''); ?>><?php echo e(translate('customer_wise')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('coupon title')); ?></label>
                                        <input type="text" name="title" value="<?php echo e($coupon['title']); ?>" class="form-control"
                                            placeholder="New coupon" required>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('coupon code')); ?></label>
                                        <input type="text" name="code" class="form-control" value="<?php echo e($coupon['code']); ?>"
                                            placeholder="<?php echo e(\Illuminate\Support\Str::random(8)); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6" id="limit-for-user" style="display: <?php echo e($coupon['coupon_type']=='first_order'?'none':'block'); ?>">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('limit')); ?> <?php echo e(translate('for')); ?> <?php echo e(translate('same')); ?> <?php echo e(translate('user')); ?></label>
                                        <input type="number" name="limit" id="user-limit" min="1" value="<?php echo e($coupon['limit']); ?>" class="form-control" <?php echo e($coupon['coupon_type']!='first_order' ? 'required' : ''); ?>

                                            placeholder="<?php echo e(translate('EX: 10')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6" id="discount_type_div" style="display: <?php echo e($coupon['coupon_type']=='free_delivery'?'none':'block'); ?>">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('discount')); ?> <?php echo e(translate('type')); ?></label>
                                        <select name="discount_type" id="discount_type" class="form-control">
                                            <option value="amount" <?php echo e($coupon['discount_type']=='amount'?'selected':''); ?>><?php echo e(translate('amount')); ?></option>
                                            <option value="percent" <?php echo e($coupon['discount_type']=='percent'?'selected':''); ?>><?php echo e(translate('percent')); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4 col-sm-6" id="discount_amount_div" style="display: <?php echo e($coupon['coupon_type']=='free_delivery'?'none':'block'); ?>">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('discount')); ?></label>
                                        <input type="number" min="0" max="10000" step="any" value="<?php echo e($coupon['discount']); ?>"
                                            name="discount" class="form-control" >
                                    </div>
                                </div>

                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('min')); ?> <?php echo e(translate('purchase')); ?></label>
                                        <input type="number" name="min_purchase" step="any" value="<?php echo e($coupon['min_purchase']); ?>"
                                            min="0" max="100000" class="form-control"
                                            placeholder="<?php echo e(translate('100')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6 <?php echo e($coupon['coupon_type']=='free_delivery' || $coupon->discount_type == 'amount'?'d-none':'d-block'); ?>" id="max_discount_div" >
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('max')); ?> <?php echo e(translate('discount')); ?></label>
                                        <input type="number" min="0" max="1000000" step="any"
                                            value="<?php echo e($coupon['max_discount']??0); ?>" name="max_discount" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label"
                                               for=""><?php echo e(translate('start')); ?> <?php echo e(translate('date')); ?></label>
                                        <label class="input-date">
                                            <input type="text" name="start_date" id="start_date"
                                                   class="js-flatpickr form-control flatpickr-custom"
                                                   placeholder="<?php echo e(translate('Select dates')); ?>"
                                                   value="<?php echo e(date('Y/m/d',strtotime($coupon['start_date']))); ?>"
                                                   data-hs-flatpickr-options='{
                                                "dateFormat": "Y/m/d", "minDate": "today"
                                            }'>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group">
                                        <label class="input-label"
                                               for=""><?php echo e(translate('expire')); ?> <?php echo e(translate('date')); ?></label>
                                        <label class="input-date">
                                            <input type="text" name="expire_date" id="expire_date"
                                                   class="js-flatpickr form-control flatpickr-custom"
                                                   placeholder="<?php echo e(translate('Select dates')); ?>"
                                                   value="<?php echo e(date('Y/m/d',strtotime($coupon['expire_date']))); ?>"
                                                   data-hs-flatpickr-options='{
                                                "dateFormat": "Y/m/d", "minDate": "today"
                                            }'>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4 col-6" id="customer_div" style="display: <?php echo e($coupon['coupon_type']=='customer_wise'?'block':'none'); ?>">
                                    <div class="form-group">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('customer')); ?></label>
                                        <select name="customer_id" id="customer_id" class="form-control js-select2-custom">
                                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($customer->id); ?>" <?php echo e($customer->id == $coupon['customer_id'] ? 'selected' : ''); ?>><?php echo e($customer->f_name.' '. $customer->l_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                    </div>
                                </div>
                            </div>

                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/coupon-edit.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/coupon/edit.blade.php ENDPATH**/ ?>