<?php $__env->startSection('title', translate('Add new delivery-man')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/employee.png')); ?>" class="w--24" alt="<?php echo e(translate('deliveryman')); ?>">
                </span>
                <span>
                    <?php echo e(translate('add new deliveryman')); ?>

                </span>
            </h1>
        </div>

        <form action="<?php echo e(route('admin.delivery-man.store')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">
                        <span class="card-header-icon">
                            <i class="tio-user"></i>
                        </span> <?php echo e(translate('General Information')); ?>

                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('First Name')); ?></label>
                                            <input type="text" name="f_name" value="<?php echo e(old('f_name')); ?>" class="form-control"
                                                   placeholder="<?php echo e(translate('Ex : First Name')); ?>" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('Last Name')); ?></label>
                                            <input type="text" name="l_name" value="<?php echo e(old('l_name')); ?>" class="form-control"
                                                   placeholder="<?php echo e(translate('Ex : Last Name')); ?>" required>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-md-12">
                                    <div>
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('phone')); ?></label>
                                        <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" class="form-control"
                                               placeholder="<?php echo e(translate('Ex : 017********')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div>
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('branch')); ?></label>
                                        <select name="branch_id" class="form-control">
                                            <option value="0"><?php echo e(translate('all')); ?></option>
                                            <?php $__currentLoopData = \App\Model\Branch::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($branch['id']); ?>"><?php echo e($branch['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div>
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('identity')); ?> <?php echo e(translate('type')); ?></label>
                                        <select name="identity_type" class="form-control">
                                            <option value="passport"><?php echo e(translate('passport')); ?></option>
                                            <option value="driving_license"><?php echo e(translate('driving')); ?> <?php echo e(translate('license')); ?></option>
                                            <option value="nid"><?php echo e(translate('nid')); ?></option>
                                            <option value="restaurant_id"><?php echo e(translate('store Id')); ?> <?php echo e(translate('id')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div>
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('identity')); ?> <?php echo e(translate('number')); ?></label>
                                        <input type="text" name="identity_number" class="form-control" value="<?php echo e(old('identity_number')); ?>"
                                                placeholder="<?php echo e(translate('Ex : DH-23434-LS')); ?>" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label d-none d-md-block ">
                                </label>
                                <div class="mb-4 text-center">
                                    <img class="initial-24" id="viewer"
                                         src="<?php echo e(asset('public/assets/admin/img/upload-vertical.png')); ?>" alt="<?php echo e(translate('deliveryman')); ?>"/>
                                </div>
                                <div class="form-group mb-0">
                                    <label class="form-label d-block">
                                        <?php echo e(translate('Deliveryman Image')); ?> <span class="text-danger"><?php echo e(translate('(Ratio 1:1)')); ?></span>
                                    </label>
                                    <div class="custom-file">
                                        <input type="file" name="image" id="customFileUpload" class="custom-file-input h--45px" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" required>
                                        <label class="custom-file-label h--45px" for="customFileUpload"></label>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="form-label d-block mb-2">
                                    <?php echo e(translate('Identity Image')); ?>

                                </label>
                                <div class="product--coba">
                                    <div class="row g-2" id="coba"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title">
                        <span class="card-header-icon">
                            <i class="tio-user"></i>
                        </span> <?php echo e(translate('Account Information')); ?>

                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('email')); ?></label>
                            <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control" placeholder="<?php echo e(translate('Ex : ex@example.com')); ?>"
                                    required>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('password')); ?></label>
                            <input type="text" name="password" class="form-control" placeholder="<?php echo e(translate('7+ Characters')); ?>" required>
                        </div>
                        <div class="col-md-4 col-sm-6">
                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('Confirm password')); ?></label>
                            <input type="text" name="password_confirmation" class="form-control" placeholder="<?php echo e(translate('7+ Characters')); ?>" required>
                        </div>
                    </div>
                </div>
            </div>

            <div class="btn--container justify-content-end mt-3">
                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileUpload").change(function () {
            readURL(this);
        });
    </script>

    <script src="<?php echo e(asset('public/assets/admin/js/spartan-multi-image-picker.js')); ?>"></script>

    <script type="text/javascript">
        $(function () {
            $("#coba").spartanMultiImagePicker({
                fieldName: 'identity_image[]',
                maxCount: 2,
                rowHeight: '140px',
                groupClassName: 'two__item',
                maxFileSize: '',
                placeholderImage: {
                    image: '<?php echo e(asset('public/assets/admin/img/upload-vertical.png')); ?>',
                    width: '100%'
                },
                dropFileLabel: "Drop Here",
                onAddRow: function (index, file) {

                },
                onRenderedPreview: function (index) {

                },
                onRemoveRow: function (index) {

                },
                onExtensionErr: function (index, file) {
                    toastr.error('<?php echo e(translate("Please only input png or jpg type file")); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function (index, file) {
                    toastr.error('<?php echo e(translate("File size too big")); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/delivery-man/index.blade.php ENDPATH**/ ?>