<?php $__env->startSection('title', translate('Update product')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('public/assets/admin/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/edit.png')); ?>" class="w--24" alt="">
                </span>
                <span>
                    <?php echo e(translate('product')); ?> <?php echo e(translate('update')); ?>

                </span>
            </h1>
        </div>
        <!-- End Page Header -->
        <form action="javascript:" method="post" id="product_form"
              enctype="multipart/form-data" class="row g-2">
            <?php echo csrf_field(); ?>
            <?php ($data = Helpers::get_business_settings('language')); ?>
            <?php ($default_lang = Helpers::get_default_language()); ?>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body pt-2">
                        <?php if($data && array_key_exists('code', $data[0])): ?>
                            <ul class="nav nav-tabs mb-4">

                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link lang_link <?php echo e($lang['code'] == 'en'? 'active':''); ?>" href="#" id="<?php echo e($lang['code']); ?>-link"><?php echo e(Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    if(count($product['translations'])){
                                        $translate = [];
                                        foreach($product['translations'] as $t)
                                        {
                                            if($t->locale == $lang['code'] && $t->key=="name"){
                                                $translate[$lang['code']]['name'] = $t->value;
                                            }
                                            if($t->locale == $lang['code'] && $t->key=="description"){
                                                $translate[$lang['code']]['description'] = $t->value;
                                            }

                                        }
                                    }
                                    ?>
                                <div class="<?php echo e($lang['code'] != 'en'? 'd-none':''); ?> lang_form" id="<?php echo e($lang['code']); ?>-form">
                                    <div class="form-group">
                                        <label class="input-label" for="<?php echo e($lang['code']); ?>_name"><?php echo e(translate('name')); ?> (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                        <input type="text" <?php echo e($lang['status'] == true ? 'required':''); ?> name="name[]" id="<?php echo e($lang['code']); ?>_name" value="<?php echo e($translate[$lang['code']]['name']??$product['name']); ?>" class="form-control" placeholder="<?php echo e(translate('New Product')); ?>" >
                                    </div>
                                    <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                    <div class="form-group mb-0">
                                        <label class="input-label" for="<?php echo e($lang['code']); ?>_description"><?php echo e(translate('short')); ?> <?php echo e(translate('description')); ?>  (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                        <textarea name="description[]" class="form-control h--172px summernote" id="<?php echo e($lang['code']); ?>_hiddenArea"><?php echo e($translate[$lang['code']]['description']??$product['description']); ?></textarea>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div id="english-form">
                                <div class="form-group">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?> (EN)</label>
                                    <input type="text" name="name[]" value="<?php echo e($product['name']); ?>" class="form-control" placeholder="<?php echo e(translate('New Product')); ?>" required>
                                </div>
                                <input type="hidden" name="lang[]" value="en">
                                <div class="form-group mb-0">
                                    <label class="input-label"
                                           for="exampleFormControlInput1"><?php echo e(translate('short')); ?> <?php echo e(translate('description')); ?> (EN)</label>
                                    <textarea name="description[]" class="form-control h--172px summernote" id="hiddenArea"><?php echo e($product['description']); ?></textarea>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">
                            <span class="card-header-icon">
                                <i class="tio-user"></i>
                            </span>
                            <span>
                                <?php echo e(translate('category')); ?>

                            </span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label"
                                           for="exampleFormControlSelect1"><?php echo e(translate('category')); ?><span
                                            class="input-label-secondary">*</span></label>
                                    <select name="category_id" id="category-id" class="form-control js-select2-custom"
                                            onchange="getRequest('<?php echo e(url('/')); ?>/admin/product/get-categories?parent_id='+this.value,'sub-categories')">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                value="<?php echo e($category['id']); ?>" <?php echo e($category->id==$productCategory[0]->id ? 'selected' : ''); ?> ><?php echo e($category['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label"
                                           for="exampleFormControlSelect1"><?php echo e(translate('sub_category')); ?><span
                                            class="input-label-secondary"></span></label>
                                    <select name="sub_category_id" id="sub-categories"
                                            data-id="<?php echo e(count($productCategory)>=2?$productCategory[1]->id:''); ?>"
                                            class="form-control js-select2-custom"
                                            onchange="getRequest('<?php echo e(url('/')); ?>/admin/product/get-categories?parent_id='+this.value,'sub-sub-categories')">

                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label"
                                           for="exampleFormControlInput1"><?php echo e(translate('unit')); ?></label>
                                    <select name="unit" class="form-control js-select2-custom">
                                        <option value="kg" <?php echo e($product['unit']=='kg'?'selected':''); ?>><?php echo e(translate('kg')); ?></option>
                                        <option value="gm" <?php echo e($product['unit']=='gm'?'selected':''); ?>><?php echo e(translate('gm')); ?></option>
                                        <option value="ltr" <?php echo e($product['unit']=='ltr'?'selected':''); ?>><?php echo e(translate('ltr')); ?></option>
                                        <option value="pc" <?php echo e($product['unit']=='pc'?'selected':''); ?>><?php echo e(translate('pc')); ?></option>
                                        <option value="ml" <?php echo e($product['unit']=='ml'?'selected':''); ?>><?php echo e(translate('ml')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label"
                                           for="exampleFormControlInput1"><?php echo e(translate('capacity')); ?></label>
                                    <input type="number" min="0" step="0.01" value="<?php echo e($product['capacity']); ?>"  name="capacity"
                                           class="form-control"
                                           placeholder="<?php echo e(translate('Ex : 5')); ?>" required>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label"
                                           for="exampleFormControlInput1"><?php echo e(translate('maximum_order_quantity')); ?></label>
                                    <input type="number" min="1" step="1" value="<?php echo e($product['maximum_order_quantity']); ?>" name="maximum_order_quantity"
                                           class="form-control"
                                           placeholder="<?php echo e(translate('Ex : 3')); ?>" required>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('weight')); ?>

                                        <span>(<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</span>
                                    </label>
                                    <input type="number" min="0.01" step=".01" value="<?php echo e($product['weight']); ?>" name="weight"
                                           class="form-control"
                                           placeholder="<?php echo e(translate('Ex : 1')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-2">
                    <div class="card min-h-116px">
                        <div class="card-body d-flex flex-column justify-content-center">
                            <div class="d-flex flex-wrap-reverse justify-content-between">
                                <div class="w-200 flex-grow-1 mr-3">
                                    <?php echo e(translate('Turning Visibility off will not show this product in the user app and website')); ?>

                                </div>
                                <div class="d-flex align-items-center mb-2 mb-sm-0">
                                    <h5 class="mb-0 mr-2"><?php echo e(translate('Visibility')); ?></h5>
                                    <label class="toggle-switch my-0">
                                        <input type="checkbox" class="toggle-switch-input" name="status" value="1" <?php echo e($product['status']==1?'checked':''); ?>>
                                        <span class="toggle-switch-label mx-auto text">
                                            <span class="toggle-switch-indicator"></span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="mb-3"><?php echo e(translate('product')); ?> <?php echo e(translate('image')); ?> <small
                                class="text-danger">* ( <?php echo e(translate('ratio')); ?> 1:1 )</small></h5>
                        <div class="product--coba">
                            <div class="row g-2" id="coba">
                                <?php if(!empty(json_decode($product['image'],true))): ?>
                                    <?php $__currentLoopData = $product->identityImageFullPath; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $identification_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="spartan_item_wrapper position-relative">
                                            <img class="img-150 border rounded p-3"  src="<?php echo e($identification_image); ?>" alt="<?php echo e(translate('identity_image')); ?>">
                                            <a href="<?php echo e(route('admin.product.remove-image',[$product['id'],basename($identification_image)])); ?>" class="spartan__close"><i class="tio-add-to-trash"></i></a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">
                            <span class="card-header-icon">
                                <i class="tio-label"></i>
                            </span>
                            <span>
                                <?php echo e(translate('tags')); ?>

                            </span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="p-2">
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="tags" placeholder="Enter tags" value="<?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($c->tag.','); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>" data-role="tagsinput">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <h5 class="card-title">
                            <span class="card-header-icon">
                                <i class="tio-dollar"></i>
                            </span>
                            <span>
                                <?php echo e(translate('price_information')); ?>

                            </span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="p-2">
                            <div class="row g-3">
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('default_unit_price')); ?></label>
                                        <input type="number" value="<?php echo e($product['price']); ?>" min="0" max="100000000" name="price" class="form-control" step="any" placeholder="<?php echo e(translate('Ex : 100')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label"
                                               for="exampleFormControlInput1"><?php echo e(translate('stock')); ?></label>
                                        <input type="number" min="0" max="100000000" value="<?php echo e($product['total_stock']); ?>" name="total_stock" class="form-control"
                                               placeholder="<?php echo e(translate('Ex : 100')); ?>">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label"
                                               for="exampleFormControlInput1"><?php echo e(translate('discount')); ?> <?php echo e(translate('type')); ?></label>
                                        <select name="discount_type" id="discount_type" class="form-control js-select2-custom">
                                            <option value="percent" <?php echo e($product['discount_type']=='percent'?'selected':''); ?>>
                                                <?php echo e(translate('percent')); ?>

                                            </option>
                                            <option value="amount" <?php echo e($product['discount_type']=='amount'?'selected':''); ?>>
                                                <?php echo e(translate('amount')); ?>

                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label"
                                               for="exampleFormControlInput1"><?php echo e(translate('discount')); ?> <span id="discount_symbol"><?php echo e($product['discount_type']=='amount'?'':'(%)'); ?></span></label>
                                        <input type="number" min="0" value="<?php echo e($product['discount']); ?>" max="100000"
                                               name="discount" class="form-control" step="any"
                                               placeholder="<?php echo e(translate('Ex : 100')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label"
                                               for="exampleFormControlInput1"><?php echo e(translate('tax_type')); ?></label>
                                        <select name="tax_type" id="tax_type" class="form-control js-select2-custom">
                                            <option
                                                value="percent" <?php echo e($product['tax_type']=='percent'?'selected':''); ?>><?php echo e(translate('percent')); ?>

                                            </option>
                                            <option
                                                value="amount" <?php echo e($product['tax_type']=='amount'?'selected':''); ?>><?php echo e(translate('amount')); ?>

                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group mb-0">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('tax_rate')); ?> <span id="tax_symbol"><?php echo e($product['tax_type']=='amount'?'':'(%)'); ?></span></label>
                                        <input type="number" value="<?php echo e($product['tax']); ?>" min="0" max="100000" name="tax" class="form-control" step="any" placeholder="<?php echo e(translate('Ex : 7')); ?>" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <h5 class="card-title">
                            <span class="card-header-icon">
                                <i class="tio-puzzle"></i>
                            </span>
                            <span>
                                <?php echo e(translate('attribute')); ?>

                            </span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="p-2">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group __select-attr">
                                        <label class="input-label"
                                               for="exampleFormControlSelect1"><?php echo e(translate('select attribute')); ?><span
                                                class="input-label-secondary"></span></label>
                                        <select name="attribute_id[]" id="choice_attributes"
                                                class="form-control js-select2-custom"
                                                multiple="multiple">
                                            <?php $__currentLoopData = \App\Model\Attribute::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($attribute['id']); ?>" <?php echo e(in_array($attribute->id,json_decode($product['attributes'],true))?'selected':''); ?>><?php echo e($attribute['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-2 mb-2">
                                    <div class="customer_choice_options" id="customer_choice_options">
                                        <?php echo $__env->make('admin-views.product.partials._choices',['choice_no'=>json_decode($product['attributes']),'choice_options'=>json_decode($product['choice_options'],true)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-2 mb-2">
                                    <div class="variant_combination" id="variant_combination">
                                        <?php echo $__env->make('admin-views.product.partials._edit-combinations',['combinations'=>json_decode($product['variations'],true)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="btn--container justify-content-end">
                    <button type="reset" class="btn btn--reset"><?php echo e(translate('clear')); ?></button>
                    <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?></button>
                </div>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/spartan-multi-image-picker.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.summernote').summernote({
                height: 200
            });
        });
    </script>
    <script>
        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#"+lang+"-form").removeClass('d-none');
            if(lang == 'en')
            {
                $("#from_part_2").removeClass('d-none');
            }
            else
            {
                $("#from_part_2").addClass('d-none');
            }


        })
    </script>
    <script type="text/javascript">
        $(function () {
            $("#coba").spartanMultiImagePicker({
                fieldName: 'images[]',
                maxCount: 4,
                rowHeight: '150px',
                groupClassName: '',
                maxFileSize: '',
                placeholderImage: {
                    image: '<?php echo e(asset('/public/assets/admin/img/upload-en.png')); ?>',
                    width: '100%'
                },
                dropFileLabel: "Drop Here",
                onAddRow: function (index, file) {

                },
                onRenderedPreview: function (index) {

                },
                onRemoveRow: function (index) {

                },
                onExtensionErr: function (index, file) {
                    toastr.error('Please only input png or jpg type file', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function (index, file) {
                    toastr.error('File size too big', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        });
    </script>

    <script>
        function getRequest(route, id) {
            $.get({
                url: route,
                dataType: 'json',
                success: function (data) {
                    $('#' + id).empty().append(data.options);
                },
            });
        }

        $(document).ready(function () {
            setTimeout(function () {
                let category = $("#category-id").val();
                let sub_category = '<?php echo e(count($productCategory)>=2?$productCategory[1]->id:''); ?>';
                let sub_sub_category = '<?php echo e(count($productCategory)>=3?$productCategory[2]->id:''); ?>';
                getRequest('<?php echo e(url('/')); ?>/admin/product/get-categories?parent_id=' + category + '&&sub_category=' + sub_category, 'sub-categories');
                getRequest('<?php echo e(url('/')); ?>/admin/product/get-categories?parent_id=' + sub_category + '&&sub_category=' + sub_sub_category, 'sub-sub-categories');
            }, 1000)
        });
    </script>

    <script>
        $(document).on('ready', function () {
            $('.js-select2-custom').each(function () {
                var select2 = $.HSCore.components.HSSelect2.init($(this));
            });
        });
    </script>

    <script src="<?php echo e(asset('public/assets/admin')); ?>/js/tags-input.min.js"></script>

    <script>
        $('#choice_attributes').on('change', function () {
            $('#customer_choice_options').html(null);
            $.each($("#choice_attributes option:selected"), function () {
                add_more_customer_choice_option($(this).val(), $(this).text());
            });
        });

        function add_more_customer_choice_option(i, name) {
            let n = name.split(' ').join('');
            $('#customer_choice_options').append('<div class="row"><div class="col-md-3"><input type="hidden" name="choice_no[]" value="' + i + '"><input type="text" class="form-control" name="choice[]" value="' + n + '" placeholder="Choice Title" readonly></div><div class="col-lg-9"><input type="text" class="form-control" name="choice_options_' + i + '[]" placeholder="Enter choice values" data-role="tagsinput" onchange="combination_update()"></div></div>');
            $("input[data-role=tagsinput], select[multiple][data-role=tagsinput]").tagsinput();
        }

        function combination_update() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('admin.product.variant-combination')); ?>',
                data: $('#product_form').serialize(),
                success: function (data) {
                    $('#variant_combination').html(data.view);
                    if (data.length > 1) {
                        $('#quantity').hide();
                    } else {
                        $('#quantity').show();
                    }
                }
            });
        }
    </script>

    

    <script>


        $('#product_form').on('submit', function () {



            var formData = new FormData(this);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('admin.product.update',[$product['id']])); ?>',
                // data: $('#product_form').serialize(),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    if (data.errors) {
                        for (var i = 0; i < data.errors.length; i++) {
                            toastr.error(data.errors[i].message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        }
                    } else {
                        toastr.success('<?php echo e(translate('product updated successfully!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function () {
                            location.href = '<?php echo e(route('admin.product.list')); ?>';
                        }, 2000);
                    }
                }
            });
        });
    </script>

    <script>

        $('#discount_type').change(function(){
            if($('#discount_type').val() == 'percent') {
                $("#discount_symbol").html('(%)')
            } else {
                $("#discount_symbol").html('')
            }
        });

        $('#tax_type').change(function(){
            if($('#tax_type').val() == 'percent') {
                $("#tax_symbol").html('(%)')
            } else {
                $("#tax_symbol").html('')
            }
        });

    </script>

    <script>
        function update_qty() {
            var total_qty = 0;
            var qty_elements = $('input[name^="stock_"]');
            for(var i=0; i<qty_elements.length; i++)
            {
                total_qty += parseInt(qty_elements.eq(i).val());
            }
            if(qty_elements.length > 0)
            {
                $('input[name="total_stock"]').attr("readonly", true);
                $('input[name="total_stock"]').val(total_qty);
                console.log(total_qty)
            }
            else{
                $('input[name="total_stock"]').attr("readonly", false);
            }
        }
    </script>

<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/product/edit.blade.php ENDPATH**/ ?>