<?php $__env->startSection('title', translate('Add new sub category')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/category.png')); ?>" class="w--24" alt="<?php echo e(translate('category')); ?>">
                </span>
                <span>
                    <?php echo e(translate('sub_category_setup')); ?>

                </span>
            </h1>
        </div>
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.category.store')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <?php ($data = Helpers::get_business_settings('language')); ?>
                            <?php ($defaultLanguage = Helpers::get_default_language()); ?>

                            <?php if($data && array_key_exists('code', $data[0])): ?>

                                <ul class="nav nav-tabs mb-4 d-inline-flex">
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a class="nav-link lang_link <?php echo e($lang['default'] == true? 'active':''); ?>" href="#" id="<?php echo e($lang['code']); ?>-link"><?php echo e(\App\CentralLogics\Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <div class="row">
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-6 <?php echo e($lang['default'] == false ? 'd-none':''); ?> lang_form" id="<?php echo e($lang['code']); ?>-form">
                                        <label class="form-label" for="exampleFormControlInput1"><?php echo e(translate('sub_category')); ?> <?php echo e(translate('name')); ?> (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                        <input type="text" name="name[]" class="form-control" maxlength="255" placeholder="<?php echo e(translate('New Sub Category')); ?>" <?php echo e($lang['status'] == true ? 'required':''); ?>

                                        <?php if($lang['status'] == true): ?> oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>>
                                    </div>
                                    <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <div class="col-sm-6 lang_form" id="<?php echo e($defaultLanguage); ?>-form">
                                    <label class="form-label" for="exampleFormControlInput1"><?php echo e(translate('sub_category')); ?> <?php echo e(translate('name')); ?>(<?php echo e(strtoupper($defaultLanguage)); ?>)</label>
                                    <input type="text" name="name[]" class="form-control" placeholder="<?php echo e(translate('New Sub Category')); ?>" required>
                                </div>
                                <input type="hidden" name="lang[]" value="<?php echo e($defaultLanguage); ?>">
                                <?php endif; ?>
                                <input name="position" value="1" hidden>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="form-label"
                                            for="exampleFormControlSelect1"><?php echo e(translate('main')); ?> <?php echo e(translate('category')); ?>

                                            <span class="input-label-secondary">*</span></label>
                                        <select id="exampleFormControlSelect1" name="parent_id" class="form-control" required>
                                            <?php $__currentLoopData = \App\Model\Category::where(['position'=>0])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category['id']); ?>"><?php echo e($category['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="btn--container justify-content-end">
                                        <a href="" class="btn btn--reset min-w-120px"><?php echo e(translate('reset')); ?></a>
                                        <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-header border-0">
                        <div class="card--header">
                            <h5 class="card-title"><?php echo e(translate('Sub Category Table')); ?> <span class="badge badge-soft-secondary"><?php echo e($categories->total()); ?></span> </h5>
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search"
                                            class="form-control pl-5"
                                           placeholder="<?php echo e(translate('Search_by_Name')); ?>" aria-label="Search"
                                            value="<?php echo e($search); ?>" required autocomplete="off">
                                           <i class="tio-search tio-input-search"></i>
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text">
                                            <?php echo e(translate('search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive datatable-custom">
                        <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center"><?php echo e(translate('#')); ?></th>
                                <th><?php echo e(translate('main')); ?> <?php echo e(translate('category')); ?></th>
                                <th><?php echo e(translate('sub_category')); ?></th>
                                <th><?php echo e(translate('status')); ?></th>
                                <th class="text-center"><?php echo e(translate('action')); ?></th>
                            </tr>

                            </thead>

                            <tbody id="set-rows">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"><?php echo e($categories->firstItem()+$key); ?></td>
                                    <td>
                                        <span class="d-block font-size-sm text-body">
                                            <?php echo e($category->parent['name']); ?>

                                        </span>
                                    </td>

                                    <td>
                                        <span class="d-block font-size-sm text-body">
                                            <?php echo e($category['name']); ?>

                                        </span>
                                    </td>

                                    <td>

                                        <label class="toggle-switch">
                                            <input type="checkbox" class="toggle-switch-input status-change-alert" id="stocksCheckbox<?php echo e($category->id); ?>"
                                                   data-route="<?php echo e(route('admin.category.status', [$category->id, $category->status ? 0 : 1])); ?>"
                                                   data-message="<?php echo e($category->status? translate('you_want_to_disable_this_category'): translate('you_want_to_active_this_category')); ?>"
                                                <?php echo e($category->status ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                        </label>

                                    </td>
                                    <td>
                                        <div class="btn--container justify-content-center">
                                            <a class="action-btn"
                                                href="<?php echo e(route('admin.category.edit',[$category['id']])); ?>">
                                            <i class="tio-edit"></i></a>
                                            <a class="action-btn btn--danger btn-outline-danger form-alert" href="javascript:"
                                               data-id="category-<?php echo e($category['id']); ?>"
                                               data-message="<?php echo e(translate("Want to delete this")); ?>?">
                                                <i class="tio-delete-outlined"></i>
                                            </a>
                                        </div>
                                        <form action="<?php echo e(route('admin.category.delete',[$category['id']])); ?>"
                                                method="post" id="category-<?php echo e($category['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <?php if(count($categories) == 0): ?>
                        <div class="text-center p-4">
                            <img class="w-120px mb-3" src="<?php echo e(asset('/public/assets/admin/svg/illustrations/sorry.svg')); ?>" alt="<?php echo e(translate('image')); ?>">
                            <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                        </div>
                        <?php endif; ?>

                        <div class="page-area">
                            <table>
                                <tfoot>
                                <?php echo $categories->links(); ?>

                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#"+lang+"-form").removeClass('d-none');
            if(lang == '<?php echo e($defaultLanguage); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/category/sub-index.blade.php ENDPATH**/ ?>