<?php $__env->startSection('title', translate('New Joining Request')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/employee.png')); ?>" class="w--24" alt="<?php echo e(translate('deliveryman')); ?>">
                </span>
                <span>
                    <?php echo e(translate('New Joining Request')); ?>

                </span>
                <span class="badge badge-soft-info badge-pill"><?php echo e($deliverymen->total()); ?></span>
            </h1>
            <ul class="nav nav-tabs border-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Request::is('admin/delivery-man/pending/list')?'active':''); ?>"  href="<?php echo e(route('admin.delivery-man.pending')); ?>"><?php echo e(translate('Pending Delivery Man')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Request::is('admin/delivery-man/denied/list')?'active':''); ?>"  href="<?php echo e(route('admin.delivery-man.denied')); ?>"><?php echo e(translate('Denied Delivery Man')); ?></a>
                </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header">
                <div class="card--header">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group">
                            <input id="datatableSearch_" type="search" name="search"
                                    class="form-control"
                                    placeholder="<?php echo e(translate('Search by Name or Phone or Email')); ?>" aria-label="Search"
                                    value="<?php echo e($search); ?>" required autocomplete="off">
                            <div class="input-group-append">
                                <button type="submit" class="input-group-text">
                                    <?php echo e(translate('Search')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo e(translate('#')); ?></th>
                        <th><?php echo e(translate('name')); ?></th>
                        <th><?php echo e(translate('Contact Info')); ?></th>
                        <th class="text-center"><?php echo e(translate('Branch')); ?></th>
                        <th class="text-center"><?php echo e(translate('Identity Type')); ?></th>
                        <th class="text-center"><?php echo e(translate('Identity Number')); ?></th>
                        <th class="text-center"><?php echo e(translate('Identity Image')); ?></th>
                        <th class="text-center"><?php echo e(translate('Status')); ?></th>
                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                    </tr>
                    </thead>

                    <tbody id="set-rows">
                    <?php $__currentLoopData = $deliverymen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$deliveryman): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($deliverymen->firstItem()+$key); ?></td>
                            <td>
                                <div class="table--media">
                                    <img class="rounded-full"
                                         src="<?php echo e($deliveryman->imageFullPath); ?>" alt="<?php echo e(translate('deliveryman')); ?>">
                                    <div class="table--media-body">
                                        <h5 class="title">
                                            <?php echo e($deliveryman['f_name']); ?> <?php echo e($deliveryman['l_name']); ?>

                                        </h5>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <h5 class="m-0">
                                    <a href="mailto:<?php echo e($deliveryman['email']); ?>" class="text-hover"><?php echo e($deliveryman['email']); ?></a>
                                </h5>
                                <div>
                                    <a href="tel:<?php echo e($deliveryman['phone']); ?>" class="text-hover"><?php echo e($deliveryman['phone']); ?></a>
                                </div>
                            </td>
                            <td class="text-center">
                                <?php if($deliveryman->branch_id == 0): ?>
                                    <label class="badge badge-soft-primary"><?php echo e(translate('All Branch')); ?></label>
                                <?php else: ?>
                                    <label class="badge badge-soft-primary"><?php echo e($deliveryman->branch?$deliveryman->branch->name:'Branch deleted!'); ?></label>
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><?php echo e(translate($deliveryman->identity_type)); ?></td>
                            <td class="text-center"><?php echo e($deliveryman->identity_number); ?></td>
                            <td class="text-center">
                                <div class="d-flex gap-2" data-toggle="" data-placement="top" title="<?php echo e(translate('click for bigger view')); ?>">
                                    <?php $__currentLoopData = $deliveryman->identityImageFullPath; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $identification_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mx-h80 overflow-hidden">
                                            <img class="cursor-pointer rounded img-fit p-2 w-100px mh-80px show-image-modal"
                                                 src="<?php echo e($identification_image); ?>"
                                                 data-image="<?php echo e($identification_image); ?>"
                                                alt="<?php echo e(translate('identity_image')); ?>">
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </td>
                            <td class="text-center">
                                <strong class="text-danger text-capitalize"><?php echo e(translate($deliveryman->application_status)); ?></strong>
                            </td>
                            <td class="text-center">

                                <div class="btn--container justify-content-center">
                                    <a class="btn btn-sm btn--primary btn-outline-primary action-btn change-request-status"
                                       data-toggle="tooltip" data-placement="top" title="<?php echo e(translate('Approve')); ?>"
                                       data-url="<?php echo e(route('admin.delivery-man.application', [$deliveryman['id'], 'approved'])); ?>"
                                       data-message="<?php echo e(translate('you_want_to_approve_this_application')); ?>"
                                       href="javascript:"><i class="tio-done font-weight-bold"></i></a>
                                    <?php if($deliveryman->application_status != 'denied'): ?>
                                        <a class="btn btn-sm btn--danger btn-outline-danger action-btn change-request-status"
                                           data-toggle="tooltip" data-placement="top" title="<?php echo e(translate('Deny')); ?>"
                                           data-url="<?php echo e(route('admin.delivery-man.application', [$deliveryman['id'], 'denied'])); ?>"
                                           data-message="<?php echo e(translate('you_want_to_deny_this_application')); ?>"
                                           href="javascript:"><i
                                                class="tio-clear"></i></a>
                                    <?php endif; ?>

                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="page-area">
                    <table>
                        <tfoot>
                        <?php echo $deliverymen->links(); ?>

                        </tfoot>
                    </table>
                </div>
                <?php if(count($deliverymen)==0): ?>
                    <div class="text-center p-4">
                        <img class="w-120px mb-3" src="<?php echo e(asset('public/assets/admin')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>

            </div>
            <div class="modal fade bd-example-modal-lg" id="identification_image_view_modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-body p-0">
                            <div data-dismiss="modal">
                                <img src="" alt="<?php echo e(translate('image')); ?>"
                                     class="w-100" id="identification_image_element">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $('.change-request-status').on('click', function (){
            let url = $(this).data('url');
            let message = $(this).data('message');
            request_alert(url, message)
        });

        function request_alert(url, message) {
            Swal.fire({
                title: '<?php echo e(translate('are_you_sure')); ?>',
                text: message,
                type: 'warning',
                showCancelButton: true,
                cancelButtonColor: 'default',
                confirmButtonColor: '#FC6A57',
                cancelButtonText: '<?php echo e(translate('no')); ?>',
                confirmButtonText: '<?php echo e(translate('yes')); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    location.href = url;
                }
            })
        }

        $('.show-image-modal').on('click', function(){
            let image_location = $(this).data('image')
            $('#identification_image_view_modal').modal('show');
            if(image_location != null || image_location !== '') {
                $('#identification_image_element').attr("src", image_location);
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/delivery-man/denied-list.blade.php ENDPATH**/ ?>