<?php $__env->startSection('title', translate('app settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('/public/assets/admin/img/app.png')); ?>" class="w--20" alt="">
                </span>
                <span>
                    <?php echo e(translate('system settings')); ?>

                </span>
            </h1>
            <ul class="nav nav-tabs border-0 mb-3">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.business-settings.web-app.system-setup.language.index')); ?>">
                        <?php echo e(translate('Language Setup')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo e(route('admin.business-settings.web-app.system-setup.app_setting')); ?>">
                        <?php echo e(translate('App Settings')); ?>

                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.business-settings.web-app.system-setup.db-index')); ?>">
                        <?php echo e(translate('Clean Database')); ?>

                    </a>
                </li>
            </ul>
        </div>

        <div class="row g-3">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h2 class="text-center"><?php echo e(translate('Android')); ?></h2>
                        <?php ($config=\App\CentralLogics\Helpers::get_business_settings('play_store_config')); ?>
                        <form
                            action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.system-setup.app_setting',['platform' => 'android']):'javascript:'); ?>"
                            method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mt-4">
                                <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between mb-2">
                                    <span
                                        class="pr-1 d-flex align-items-center switch--label">
                                        <span class="line--limit-1 text--title font-semibold">
                                            <?php echo e(translate('Enable download link for web footer')); ?>

                                        </span>
                                    </span>
                                        <input class="toggle-switch-input status" type="checkbox" name="play_store_status"
                                               value="1" <?php echo e((isset($config) && $config['status']==1)?'checked':''); ?> hidden>
                                    <span class="toggle-switch-label text">
                                        <span class="toggle-switch-indicator"></span>
                                    </span>
                                </label>

                                <div class="form-group">
                                    <input type="text" id="play_store_link" name="play_store_link"
                                           value="<?php echo e($config['link']??''); ?>" class="form-control" placeholder="">
                                </div>

                                <div class="mt-3">
                                    <label class="form-label"
                                           for="ios_min_version">
                                           <span><?php echo e(translate('Minimum version for force update')); ?></span>
                                           <span class="form-label-secondary ml-1" data-toggle="tooltip" data-placement="right" data-original-title="<?php echo e(translate("If there is any update available in the admin panel and for that, the previous user app will not work, you can force the customer from here by providing the minimum version for force update. That means if a customer has an app below this version the customers must need to update the app first. If you don't need a force update just insert here zero (0) and ignore it.")); ?>"><img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                           </span>
                                    </label>
                                    <input type="number" min="0" step=".1" id="android_min_version" name="android_min_version"
                                           value="<?php echo e($config['min_version']??''); ?>" class="form-control"
                                           placeholder="<?php echo e(translate('EX: 4.0')); ?>">
                                </div>

                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                        class="btn btn--primary mb-2 call-demo"><?php echo e(translate('save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h2 class="text-center"><?php echo e(translate('IOS')); ?></h2>
                        <?php ($config=\App\CentralLogics\Helpers::get_business_settings('app_store_config')); ?>
                        <form
                            action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.system-setup.app_setting',['platform' => 'ios']):'javascript:'); ?>"
                            method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mt-4">
                                <label class="toggle-switch h--45px toggle-switch-sm d-flex justify-content-between mb-2">
                                    <span
                                        class="pr-1 d-flex align-items-center switch--label">
                                        <span class="line--limit-1 text--title font-semibold">
                                            <?php echo e(translate('Enable download link for web footer')); ?>

                                        </span>
                                    </span>
                                        <input class="toggle-switch-input" type="checkbox" class="status" name="app_store_status"
                                               value="1" <?php echo e((isset($config) && $config['status']==1)?'checked':''); ?> hidden>
                                    <span class="toggle-switch-label text">
                                        <span class="toggle-switch-indicator"></span>
                                    </span>
                                </label>

                                <div class="form-group">
                                    <input type="text" id="app_store_link" name="app_store_link"
                                           value="<?php echo e($config['link']??''); ?>" class="form-control" placeholder="">
                                </div>

                                <div class="mt-3">
                                    <label class="form-label"
                                           for="ios_min_version">
                                           <span><?php echo e(translate('Minimum version for force update')); ?></span>
                                           <span class="form-label-secondary ml-1" data-toggle="tooltip" data-placement="right" data-original-title='<?php echo e(translate("If there is any update available in the admin panel and for that, the previous user app will not work, you can force the customer from here by providing the minimum version for force update. That means if a customer has an app below this version the customers must need to update the app first. If you don't need a force update just insert here zero (0) and ignore it.")); ?>'><img src="<?php echo e(asset('public/assets/admin/img/info-circle.svg')); ?>" alt="info">
                                           </span>
                                    </label>
                                    <input type="number" min="0" step=".1" id="ios_min_version" name="ios_min_version"
                                           value="<?php echo e($config['min_version']??''); ?>" class="form-control"
                                           placeholder="<?php echo e(translate('EX: 4.0')); ?>">
                                </div>

                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                    class="btn btn--primary call-demo"><?php echo e(translate('save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/app-setting-index.blade.php ENDPATH**/ ?>