<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo e(translate('Customer Password Reset')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap');
        body {
            font-family: 'Roboto', sans-serif;
            width: 100% !important;
            height: 100% !important;
            padding: 0 !important;
            margin: 0 !important;
            color: #334257;
            font-size: 13px;
            line-height: 1.5;
            display: flex;align-items: center;justify-content: center;
            min-height: 100vh;

        }

        table {
            border-collapse: collapse !important;
        }
        .border-top {
            border-top: 1px solid rgba(0, 170, 109, 0.3);
            padding: 15px 0 10px;
            display: block;
        }
        .d-block {
            display: block;
        }
        .privacy {
            display: flex;
            align-items: center;
            justify-content: center;

        }
        .privacy a {
            text-decoration: none;
            color: #334257;
            position: relative;
        }
        .privacy a:not(:last-child)::after {
            content:'';
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: #334257;
            display: inline-block;
            margin: 0 15px
        }
        .social {
            margin: 15px 0 8px;
            display: block;
        }
        .copyright{
            text-align: center;
            display: block;
        }
        .text-base {
            color: var(--base);
font-weight: 700
        }

    </style>
</head>

<body style="background-color: #e9ecef;padding:15px">

<?php ($logo=\App\Model\BusinessSetting::where(['key'=>'logo'])->first()->value); ?>
<?php ($business_name=\App\Model\BusinessSetting::where(['key'=>'restaurant_name'])->first()->value); ?>
<?php ($footer=\App\Model\BusinessSetting::where(['key'=>'footer_text'])->first()->value); ?>
<?php
$socialMediaList = \App\Model\SocialMedia::active()->get();
$platforms = ['facebook', 'pinterest', 'linkedin', 'instagram', 'twitter'];
$socialMediaLinks = [];

foreach ($socialMediaList as $social) {
    $social_name = $social['name'];
    $link = $social['link'];

    if (in_array($social_name, $platforms)) {
        $socialMediaLinks[$social_name] = $link;
    }
}
?>

    <table style="width:100%;max-width:500px;margin:0 auto;text-align:center;background:#fff">
        <tr>
            <td style="padding:30px 30px 0">
                <img src="<?php echo e(asset('/public/assets/admin/img/email-templates/forgot-password.png')); ?>" alt="forgot/png">
                <h3 style="font-size:17px;font-weight:500"><?php echo e(translate('Change password request')); ?></h3>
            </td>
        </tr>
        <tr>
            <td style="padding:0 30px 30px; text-align:left">
                <span style="font-weight:500;display:block;margin: 20px 0 11px;"><?php echo e(translate('Hi ')); ?> <?php echo e($name); ?>,</span>
                <span style="display:block;margin-bottom:14px"><?php echo e(translate('Your Verification Code is')); ?></span>
                <h2 style="font-size: 26px;margin: 0;letter-spacing:4px;text-align:center"><?php echo e($token ?? '123456'); ?></h2>
                <br>
                <span class="border-top"></span>
                <span class="d-block" style="margin-bottom:14px"><?php echo e(translate('Please contact us for any queries, we’re always happy to help.')); ?></span>
                <span class="d-block"><?php echo e(translate('Thanks & Regards')); ?>,</span>
                <span class="d-block" style="margin-bottom:20px"> <?php echo e($business_name); ?></span>

                <img style="width:120px;display:block;margin:10px auto" onerror="this.src='<?php echo e(asset('/public/assets/admin/img//logo/main-logo.png')); ?>'"
                     src="<?php echo e(asset('storage/app/public/restaurant/' . $logo)); ?>" alt="public/img">
                <span class="privacy">
                    <a href="<?php echo e(route('pages.privacy-policy')); ?>"><?php echo e(translate('Privacy Policy')); ?></a><a href="<?php echo e(route('pages.about-us')); ?>"><?php echo e(translate('About Us')); ?></a>
                </span>
                <span class="social" style="text-align:center">
                    <a href="<?php echo e($socialMediaLinks['pinterest'] ?? '#'); ?>" style="margin: 0 5px;text-decoration:none">
                        <img src="<?php echo e(asset('/public/assets/admin/img/img/pinterest.png')); ?>" alt="pinterest">
                    </a>
                    <a href="<?php echo e($socialMediaLinks['instagram'] ?? '#'); ?>" style="margin: 0 5px;text-decoration:none">
                        <img src="<?php echo e(asset('/public/assets/admin/img/img/instagram.png')); ?>" alt="instagram">
                    </a>
                    <a href="<?php echo e($socialMediaLinks['facebook'] ?? '#'); ?>" style="margin: 0 5px;text-decoration:none">
                        <img src="<?php echo e(asset('/public/assets/admin/img/img/facebook.png')); ?>" alt="facebook">
                    </a>
                    <a href="<?php echo e($socialMediaLinks['linkedin'] ?? '#'); ?>" style="margin: 0 5px;text-decoration:none">
                        <img src="<?php echo e(asset('/public/assets/admin/img/img/linkedin.png')); ?>" alt="linkedin">
                    </a>
                    <a href="<?php echo e($socialMediaLinks['twitter'] ?? '#'); ?>" style="margin: 0 5px;text-decoration:none">
                        <img src="<?php echo e(asset('/public/assets/admin/img/img/twitter.png')); ?>" alt="twitter">
                    </a>
                </span>
                <span class="copyright">
                    <?php echo e($footer); ?>

                </span>
            </td>
        </tr>
    </table>

</body>

</html>
<?php /**PATH /home/forbuy/public_html/resources/views/email-templates/customer/password-reset.blade.php ENDPATH**/ ?>