<?php $__env->startSection('title', translate('Update Branch')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/add_branch.png')); ?>" class="w--24" alt="<?php echo e(translate('branch')); ?>">
                </span>
                <span>
                    <?php echo e(translate('branch')); ?> <?php echo e(translate('update')); ?>

                </span>
            </h1>
        </div>

        <?php ($branchCount=\App\Model\Branch::count()); ?>
        <form action="<?php echo e(route('admin.branch.update',[$branch['id']])); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row g-2">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">
                                <i class="tio-user"></i>
                                <?php echo e(translate('store_information')); ?>

                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="row g-3">
                                        <div class="col-12">
                                            <div class="form-group mb-0">
                                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?></label>
                                                <input type="text" name="name" value="<?php echo e($branch['name']); ?>" class="form-control" placeholder="<?php echo e(translate('New branch')); ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group mb-0">
                                                <label class="input-label" for=""><?php echo e(translate('address')); ?></label>
                                                <textarea type="text" name="address" class="form-control h--90px" placeholder="<?php echo e(translate('Ex: 666/668 DOHS Mirpur, Dhaka, Bangladesh')); ?>" value="<?php echo e($branch['address']); ?>" required><?php echo e($branch['address']); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                        <div class="d-flex flex-column justify-content-center h-100">
                                            <div class="text-center mb-3 text--title">
                                                <?php echo e(translate('Branch Image')); ?>

                                                <small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 1:1 )</small>
                                            </div>
                                            <label class="upload--squire">
                                                <input type="file" name="image" id="customFileEg1" value="<?php echo e($branch['image']); ?>" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" hidden>
                                                <img id="viewer" src="<?php echo e($branch->imageFullPath); ?>"
                                                    alt="branch image"/>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-3 mt-3">
                                    <div class="col-sm-6 col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('phone')); ?></label>
                                            <input type="phone" name="phone" value="<?php echo e($branch['phone']); ?>" class="form-control"
                                                    placeholder="<?php echo e(translate('EX : +09853834')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('email')); ?></label>
                                            <input type="email" name="email" value="<?php echo e($branch['email']); ?>" class="form-control"
                                                    placeholder="<?php echo e(translate('EX : example@example.com')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-4">
                                        <div class="form-group mb-0">
                                            <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('password')); ?> <span class="text-danger font-size-sm">* ( <?php echo e(translate('input if you want to reset.')); ?> )</span></label>
                                            <div class="position-relative">
                                                <input type="password" name="password" class="form-control" placeholder="">
                                                <div class="__right-eye">
                                                    <i class="tio-hidden-outlined"></i>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php ($googleMapStatus = \App\CentralLogics\Helpers::get_business_settings('google_map_status')); ?>
                <?php if($googleMapStatus): ?>
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="tio-poi"></i>
                                    <?php echo e(translate('store_location')); ?>

                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="row  g-3">
                                            <div class="col-12">
                                                <div class="form-group mb-0">
                                                    <label class="form-label text-capitalize"
                                                           for="latitude"><?php echo e(translate('latitude')); ?><span
                                                            class="form-label-secondary pl-1" data-toggle="tooltip" data-placement="right"
                                                            data-original-title="<?php echo e(translate('click_on_the_map_select_your_default_location')); ?>"><img
                                                                src="<?php echo e(asset('/public/assets/admin/img/info-circle.svg')); ?>"
                                                                alt="<?php echo e(translate('click_on_the_map_select_your_default_location')); ?>"></span></label>
                                                    <input type="text" id="latitude" name="latitude" class="form-control"
                                                           placeholder="<?php echo e(translate('Ex:')); ?> 23.8118428"
                                                           value="<?php echo e($branch['latitude']); ?>" required readonly>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group mb-0">
                                                    <label class="form-label text-capitalize"
                                                           for="longitude"><?php echo e(translate('longitude')); ?><span
                                                            class="form-label-secondary pl-1" data-toggle="tooltip" data-placement="right"
                                                            data-original-title="<?php echo e(translate('messages.click_on_the_map_select_your_default_location')); ?>"><img
                                                                src="<?php echo e(asset('/public/assets/admin/img/info-circle.svg')); ?>"
                                                                alt="<?php echo e(translate('click_on_the_map_select_your_default_location')); ?>"></span></label>
                                                    <input type="text" name="longitude" class="form-control"
                                                           placeholder="<?php echo e(translate('Ex:')); ?> 90.356331" id="longitude"
                                                           value="<?php echo e($branch['longitude']); ?>" required readonly>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group mb-0">
                                                    <label class="input-label" for="">
                                                        <i class="tio-info-outined"
                                                           data-toggle="tooltip"
                                                           data-placement="top"
                                                           title="This value is the radius from your branch location, and customer can order food inside  the circle calculated by this radius."></i>
                                                        <?php echo e(translate('coverage')); ?> ( <?php echo e(translate('km')); ?> )
                                                    </label>
                                                    <input type="number" name="coverage" min="1" value="<?php echo e($branch['coverage']); ?>" max="1000" class="form-control" placeholder="<?php echo e(translate('Ex : 3')); ?>"
                                                        <?php echo e($branchCount>1?'required':''); ?> >
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6" id="location_map_div">
                                        <input id="pac-input" class="controls rounded" data-toggle="tooltip"
                                               data-placement="right"
                                               data-original-title="<?php echo e(translate('search_your_location_here')); ?>"
                                               type="text" placeholder="<?php echo e(translate('search_here')); ?>" />
                                        <div id="location_map_canvas" class="overflow-hidden rounded h-100"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>

            </div>
            <div class="btn--container justify-content-end mt-3">
                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?></button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(Helpers::get_business_settings('map_api_client_key')); ?>&libraries=places&v=3.45.8"></script>


    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this);
        });


        $( document ).ready(function() {
            function initAutocomplete() {
                var myLatLng = {

                    lat: <?php echo e($branch->latitude); ?> ?? 23.811842872190343,
                    lng: <?php echo e($branch->longitude); ?> ?? 90.356331
                };
                const map = new google.maps.Map(document.getElementById("location_map_canvas"), {
                    center: {
                        lat: <?php echo e($branch->latitude); ?> ?? 23.811842872190343,
                        lng: <?php echo e($branch->longitude); ?> ?? 90.356331
                    },
                    zoom: 13,
                    mapTypeId: "roadmap",
                });

                var marker = new google.maps.Marker({
                    position: myLatLng,
                    map: map,
                });

                marker.setMap(map);
                var geocoder = geocoder = new google.maps.Geocoder();
                google.maps.event.addListener(map, 'click', function(mapsMouseEvent) {
                    var coordinates = JSON.stringify(mapsMouseEvent.latLng.toJSON(), null, 2);
                    var coordinates = JSON.parse(coordinates);
                    var latlng = new google.maps.LatLng(coordinates['lat'], coordinates['lng']);
                    marker.setPosition(latlng);
                    map.panTo(latlng);

                    document.getElementById('latitude').value = coordinates['lat'];
                    document.getElementById('longitude').value = coordinates['lng'];


                    geocoder.geocode({
                        'latLng': latlng
                    }, function(results, status) {
                        if (status == google.maps.GeocoderStatus.OK) {
                            if (results[1]) {
                                document.getElementById('address').innerHtml = results[1].formatted_address;
                            }
                        }
                    });
                });
                // Create the search box and link it to the UI element.
                const input = document.getElementById("pac-input");
                const searchBox = new google.maps.places.SearchBox(input);
                map.controls[google.maps.ControlPosition.TOP_CENTER].push(input);
                // Bias the SearchBox results towards current map's viewport.
                map.addListener("bounds_changed", () => {
                    searchBox.setBounds(map.getBounds());
                });
                let markers = [];
                // Listen for the event fired when the user selects a prediction and retrieve
                // more details for that place.
                searchBox.addListener("places_changed", () => {
                    const places = searchBox.getPlaces();

                    if (places.length == 0) {
                        return;
                    }
                    // Clear out the old markers.
                    markers.forEach((marker) => {
                        marker.setMap(null);
                    });
                    markers = [];
                    // For each place, get the icon, name and location.
                    const bounds = new google.maps.LatLngBounds();
                    places.forEach((place) => {
                        if (!place.geometry || !place.geometry.location) {
                            console.log("Returned place contains no geometry");
                            return;
                        }
                        var mrkr = new google.maps.Marker({
                            map,
                            title: place.name,
                            position: place.geometry.location,
                        });
                        google.maps.event.addListener(mrkr, "click", function(event) {
                            document.getElementById('latitude').value = this.position.lat();
                            document.getElementById('longitude').value = this.position.lng();
                        });

                        markers.push(mrkr);

                        if (place.geometry.viewport) {
                            // Only geocodes have viewport.
                            bounds.union(place.geometry.viewport);
                        } else {
                            bounds.extend(place.geometry.location);
                        }
                    });
                    map.fitBounds(bounds);
                });
            };
            initAutocomplete();
        });


        $('.__right-eye').on('click', function(){
            if($(this).hasClass('active')) {
                $(this).removeClass('active')
                $(this).find('i').removeClass('tio-invisible')
                $(this).find('i').addClass('tio-hidden-outlined')
                $(this).siblings('input').attr('type', 'password')
            }else {
                $(this).addClass('active')
                $(this).siblings('input').attr('type', 'text')


                $(this).find('i').addClass('tio-invisible')
                $(this).find('i').removeClass('tio-hidden-outlined')
            }
        })

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/branch/edit.blade.php ENDPATH**/ ?>