<div class="card mt-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center border rounded px-3 py-3">
            <div>
                <h5 class="mb-0"><?php echo e(translate('Setup Fixed Delivery Charge')); ?></h5>
                <p class="mb-0"><?php echo e(translate('Setup fixed delivery charge you want to deliver from store')); ?></p>
            </div>

            <label class="toggle-switch h--45px toggle-switch-sm rounded">
                <input type="checkbox" class="toggle-switch-input change-delivery-charge-type-<?php echo e($branch->id); ?>" name="delivery_charge_type"
                       <?php echo e($branch?->delivery_charge_setup?->delivery_charge_type == 'fixed' ? 'checked' : ''); ?>

                       data-type="fixed"
                       data-branch-id="<?php echo e($branch->id); ?>"
                       id="toggleFixed-<?php echo e($branch->id); ?>">
                <span class="toggle-switch-label">
                    <span class="toggle-switch-indicator"></span>
                </span>
            </label>
        </div>
    </div>
</div>

<div class="card mt-4" id="fixedDeliverySection-<?php echo e($branch->id); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('admin.business-settings.store.store-fixed-delivery-charge')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <input type="hidden" name="branch_id" id="" value="<?php echo e($branch->id); ?>">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="fixed_delivery_charge"><?php echo e(translate('Fixed Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                        <input type="number" class="form-control" name="fixed_delivery_charge" min="0" max="99999999" step="0.001"
                               value="<?php echo e($branch?->delivery_charge_setup?->fixed_delivery_charge); ?>" id="fixed_delivery_charge" placeholder="Ex: 10" required>
                    </div>
                </div>
            </div>
            <div class="btn--container mt-4 justify-content-end">
                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary call-demo"><?php echo e(translate('Save')); ?></button>
            </div>
        </form>
    </div>
</div>


<div class="card mt-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center border rounded px-3 py-3">
            <div>
                <h5 class="mb-0"><?php echo e(translate('Setup Kilometer Wise Delivery Charge')); ?></h5>
                <p class="mb-0"><?php echo e(translate('Setup delivery charges for per km  and how far you want to deliver from store')); ?></p>
            </div>

            <label class="toggle-switch h--45px toggle-switch-sm rounded">
                <input type="checkbox" class="toggle-switch-input change-delivery-charge-type-<?php echo e($branch->id); ?>" name="delivery_charge_type"
                       <?php echo e($branch?->delivery_charge_setup?->delivery_charge_type == 'distance' ? 'checked' : ''); ?>

                       data-type="distance"
                       data-branch-id="<?php echo e($branch->id); ?>"
                       id="toggleKilometerWise-<?php echo e($branch->id); ?>">
                <span class="toggle-switch-label text">
                    <span class="toggle-switch-indicator"></span>
                </span>
            </label>
        </div>
    </div>
</div>

<div class="card mt-4" id="kilometerWiseSection-<?php echo e($branch->id); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('admin.business-settings.store.store-kilometer-wise-delivery-charge')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <input type="hidden" name="branch_id" id="" value="<?php echo e($branch->id); ?>">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="per_km_charge"><?php echo e(translate('Per KM Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                        <input type="number" class="form-control" name="delivery_charge_per_kilometer" min="0" max="99999999" step="0.001"
                               value="<?php echo e($branch?->delivery_charge_setup?->delivery_charge_per_kilometer); ?>" id="delivery_charge_per_kilometer" placeholder="Ex: 10" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="min_delivery_charge"><?php echo e(translate('Minimum Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                        <input type="number" class="form-control" name="minimum_delivery_charge" min="0" max="99999999" step="0.001"
                               value="<?php echo e($branch?->delivery_charge_setup?->minimum_delivery_charge); ?>" id="minimum_delivery_charge" placeholder="Ex: 10" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="min_distance_free_delivery"><?php echo e(translate('Distance Area for Free Delivery')); ?> (Km)</label>
                        <input type="number" class="form-control" name="minimum_distance_for_free_delivery" min="0" max="99999999" step="0.001"
                               value="<?php echo e($branch?->delivery_charge_setup?->minimum_distance_for_free_delivery); ?>" id="minimum_distance_for_free_delivery" placeholder="Ex: 10" required>
                    </div>
                </div>
            </div>
            <div class="btn--container mt-4 justify-content-end">
                <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary call-demo"><?php echo e(translate('Save')); ?></button>
            </div>
        </form>
    </div>
</div>

<?php
$areaCount = $branch->delivery_charge_by_area->count()
?>
<div class="card my-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center border rounded mb-2 px-3 py-3">
            <div>
                <h5 class="mb-0"><?php echo e(translate('Setup Area/Zip Code Wise Delivery Charge')); ?></h5>
                <p class="mb-0"><?php echo e(translate('Create Area/Zip Code wise delivery region and specify the charges for each region')); ?></p>
            </div>

            <label class="toggle-switch h--45px toggle-switch-sm rounded">
                <input type="checkbox" class="toggle-switch-input  <?php if($areaCount > 0): ?> change-delivery-charge-type-<?php echo e($branch->id); ?> <?php else: ?> change-delivery-charge-to-area-<?php echo e($branch->id); ?> <?php endif; ?>"
                       name="delivery_charge_type"
                       <?php echo e($branch?->delivery_charge_setup?->delivery_charge_type == 'area' ? 'checked' : ''); ?>

                       data-type="area"
                       data-branch-id="<?php echo e($branch->id); ?>"
                       id="toggleAreaWise-<?php echo e($branch->id); ?>">
                <span class="toggle-switch-label text">
                    <span class="toggle-switch-indicator"></span>
                </span>
            </label>
        </div>

        <div id="areaWiseSection-<?php echo e($branch->id); ?>">
            <div class="d-flex flex-wrap gap-2 align-items-center my-4">
                <h4 class="mb-0 d-flex align-items-center gap-2">
                    <?php echo e(translate('Area/Zip Code List')); ?>

                </h4>
                <span class="badge badge-soft-dark rounded-circle fz-12"><?php echo e($branch->delivery_charge_by_area->count()); ?></span>
            </div>

            <div class="row gx-2 gx-lg-3">
                <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                    <div class="card">
                        <div class="card-top px-card pt-4">
                            <div class="d-flex flex-column flex-md-row flex-wrap gap-3 justify-content-md-between align-items-md-center">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group">
                                        <input id="datatableSearch_" type="search" name="search" class="form-control min-width-300px"
                                               placeholder="<?php echo e(translate('Search by area name or zip code')); ?>"
                                               aria-label="Search" value="<?php echo e(request()->input('search')); ?>"  autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn--primary">
                                                <?php echo e(translate('Search')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>

                                <div class="d-flex flex-wrap justify-content-md-end gap-3">
                                    <div>
                                        <a type="button" class="btn btn-outline-primary text-nowrap"
                                           href="<?php echo e(route('admin.business-settings.store.export-area-delivery-charge',[$branch->id]).  (request('search') ? '?search=' . request('search') : '')); ?>">
                                            <i class="tio-upload"></i>
                                            <?php echo e(translate('Export')); ?>

                                        </a>
                                    </div>
                                    <div>
                                        <button type="button" class="btn btn-outline-primary text-nowrap" data-toggle="modal" data-target="#importConfirmModal-<?php echo e($branch->id); ?>">
                                            <i class="tio-download-to"></i>
                                            <?php echo e(translate('Import')); ?>

                                        </button>
                                    </div>
                                    <button type="button" class="btn btn--primary" data-toggle="modal" data-target="#addAreaModal-<?php echo e($branch->id); ?>" data-id="<?php echo e($branch->id); ?>">
                                        <i class="tio-add"></i>
                                        <?php echo e(translate('Add Area/Zip Code')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="py-4">
                            <div class="table-responsive datatable-custom">
                                <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                    <thead class="thead-light">
                                    <tr>
                                        <th><?php echo e(translate('SL')); ?></th>
                                        <th><?php echo e(translate('Area Name/Zip Code')); ?></th>
                                        <th><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</th>
                                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                                    </tr>
                                    </thead>

                                    <tbody id="set-rows">
                                        <?php $__empty_1 = true; $__currentLoopData = $branch->delivery_charge_by_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $deliveryArea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td><?php echo e($deliveryArea->area_name); ?></td>
                                                <td><?php echo e(Helpers::set_symbol($deliveryArea->delivery_charge)); ?></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-3">
                                                        <a class="btn btn-outline-info btn-sm edit square-btn edit-area"
                                                           data-toggle="modal" data-target="#editDeliveryChargeModal-<?php echo e($branch->id); ?>"
                                                           data-id="<?php echo e($deliveryArea->id); ?>"
                                                           href="#">
                                                            <i class="tio-edit"></i>
                                                        </a>
                                                        <button type="button" class="btn btn-outline-danger btn-sm delete square-btn form-alert"
                                                                data-id="area-<?php echo e($deliveryArea->id); ?>" data-message="<?php echo e(translate('Want to remove this Area')); ?>?">
                                                            <i class="tio-delete"></i>
                                                        </button>
                                                        <form action="<?php echo e(route('admin.business-settings.store.delete-area-delivery-charge',[$deliveryArea->id, 'branch_id' => $deliveryArea->branch_id])); ?>"
                                                              method="post" id="area-<?php echo e($deliveryArea->id); ?>">
                                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="4" class="text-center">
                                                    <img class="my-4" src="<?php echo e(asset('public/assets/admin/svg/components/map.svg')); ?>" alt="<?php echo e(translate('info icon')); ?>">
                                                    <h4><?php echo e(translate('Create Area/Zip Code')); ?></h4>
                                                    <p><?php echo e(translate('Create area/zip code and setup delivery charge')); ?></p>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-body">
        <div>
            <form id="weightChargeForm-<?php echo e($branch->id); ?>" action="<?php echo e(route('admin.business-settings.store.weight-settings.change-extra-charge-on-weight-status')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="branch_id" value="<?php echo e($branch->id); ?>">
                <input type="hidden" name="status" id="weightChargeStatus-<?php echo e($branch->id); ?>" value="0"> <!-- Hidden input to store status -->

                <div class="d-flex justify-content-between align-items-center border rounded px-3 py-3">
                    <div>
                        <h5 class="mb-0"><?php echo e(translate('Add Extra Delivery Charge on Weight')); ?></h5>
                        <p class="mb-0"><?php echo e(translate('To work properly Weight based delivery charge need to update your product weight from ')); ?> <a class="text-decoration-underline" href="<?php echo e(route('admin.product.list')); ?>" target="_blank"><?php echo e(translate('Product List')); ?></a></p>
                    </div>
                    <label class="toggle-switch h--45px toggle-switch-sm rounded" for="toggleWeightCharge-<?php echo e($branch->id); ?>">
                        <input type="checkbox" class="toggle-switch-input toggleWeightCharge-<?php echo e($branch->id); ?>" name="extra_charge_on_weight"
                               <?php echo e($branch?->weight_settings_status?->value == 1 ? 'checked' : ''); ?>

                               data-branch-id="<?php echo e($branch->id); ?>"
                               id="toggleWeightCharge-<?php echo e($branch->id); ?>">
                        <span class="toggle-switch-label">
                        <span class="toggle-switch-indicator"></span>
                    </span>
                    </label>
                </div>
            </form>

        </div>
        <div class="mt-5">
            <div id="weightChargeSection-<?php echo e($branch->id); ?>" style="display : <?php echo e($branch?->weight_settings_status?->value == 0 ? 'none' :'block'); ?>;">
                <div class="mb-5">
                    <div class="row g-3">
                        <div class="col-sm-6">
                            <label class="border rounded p-2 pr-3 d-block cursor-pointer">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="weight_charge_type-<?php echo e($branch->id); ?>" id="chargePerKg-<?php echo e($branch->id); ?>" value="unit"
                                        <?php echo e($branch?->weight_charge_type?->value != 'range' ? 'checked' : ''); ?>>
                                    <span class="form-check-label">
                                            <?php echo e(translate('Setup Charge Per Unit')); ?> <span>(<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</span>
                                        </span>
                                </div>
                            </label>
                        </div>
                        <div class="col-sm-6">
                            <label class="border rounded p-2 pr-3 d-block cursor-pointer">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="weight_charge_type-<?php echo e($branch->id); ?>" id="chargeByRange-<?php echo e($branch->id); ?>" value="range"
                                        <?php echo e($branch?->weight_charge_type?->value == 'range' ? 'checked' : ''); ?>>
                                    <span class="form-check-label">
                                            <?php echo e(translate('Setup Charge by Range')); ?> <span>(<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</span>
                                        </span>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>

                <form action="<?php echo e(route('admin.business-settings.store.weight-settings.store-weight-charge')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div id="perKgSection-<?php echo e($branch->id); ?>">
                        <div class="row mb-3">
                            <input type="hidden" name="branch_id" id="" value="<?php echo e($branch->id); ?>">
                            <input type="hidden" name="weight_charge_type" value="unit">
                            <div class="col-md-6">
                                <label for="countFrom" class="form-label"><?php echo e(translate('Count charge from')); ?> <span>(<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</span></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="countFrom" name="count_charge_from" step="0.001" min="0"
                                           value="<?php echo e(collect($branch->weight_unit)->firstWhere('key', 'count_charge_from')['value'] ?? ''); ?>"
                                           placeholder="Ex: 5kg" required>
                                    <?php
                                        $selectedOperation = collect($branch->weight_unit)->firstWhere('key', 'count_charge_from_operation')['value'] ?? '';
                                    ?>
                                    <div class="">
                                        <div class="input-group">
                                            <span></span>
                                            <select class="form-control" id="minWeight" name="count_charge_from_operation">
                                                <option value="greater_or_equal" <?php echo e($selectedOperation == 'greater_or_equal' ? 'selected' : ''); ?>><?php echo e(translate('Greater or Equal')); ?></option>
                                                <option value="greater" <?php echo e($selectedOperation == 'greater' ? 'selected' : ''); ?>><?php echo e(translate('Greater')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="additionalCharge" class="form-label"> <?php echo e(translate('Additional charge per')); ?> <?php echo e(Helpers::get_business_settings('product_weight_unit')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                <input type="number" class="form-control" id="additionalCharge" name="additional_charge_per_unit" step="0.001"
                                       value="<?php echo e(collect($branch->weight_unit)->firstWhere('key', 'additional_charge_per_unit')['value'] ?? ''); ?>"
                                       placeholder="Ex: $1.5" min="0" required>
                            </div>
                        </div>
                        <div class="btn--container mt-4 justify-content-end">
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </div>
                </form>

                <form action="<?php echo e(route('admin.business-settings.store.weight-settings.store-weight-charge')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div id="weightRangeSection-<?php echo e($branch->id); ?>" style="display:none;">
                        <input type="hidden" name="branch_id" id="" value="<?php echo e($branch->id); ?>">
                        <input type="hidden" name="weight_charge_type" value="range">
                        <div class="row g-3">
                            <div class="col-lg-9">
                                <div id="weightRows-<?php echo e($branch->id); ?>">
                                    <?php
                                        $weightRanges = $branch->weight_range ? json_decode($branch->weight_range->value, true) : [];
                                    ?>

                                    <?php $__empty_1 = true; $__currentLoopData = $weightRanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $range): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="weight-range-item weight-row-<?php echo e($branch->id); ?>">
                                            <div class="weight-rows">
                                                <div class="row g-3">
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="minWeight" class="form-label"><?php echo e(translate('Min Weight')); ?> (<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</label>
                                                        <input type="hidden" value="<?php echo e($range['min_operation']); ?>" name="min_operation[]">
                                                        <div class="input-group">
                                                            <select class="form-control" id="minWeight" name="min_operation[]" <?php if($index > 0): ?> disabled <?php endif; ?>>
                                                                <option value="greater_or_equal" <?php echo e($range['min_operation'] == 'greater_or_equal' ? 'selected' : ''); ?>><?php echo e(translate('Greater or Equal')); ?></option>
                                                                <option value="greater" <?php echo e($range['min_operation'] == 'greater' ? 'selected' : ''); ?>><?php echo e(translate('Greater')); ?></option>
                                                            </select>
                                                            <input type="number" class="form-control" name="min_weight[]" placeholder="Ex: X kg" min="0" step="0.01" value="<?php echo e($range['min_weight']); ?>" required <?php if($index > 0): ?> readonly <?php endif; ?>>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="maxWeight" class="form-label"><?php echo e(translate('Max Weight')); ?> (<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</label>
                                                        <div class="input-group">
                                                            <select class="form-control" name="max_operation[]" id="maxWeight">
                                                                <option value="less_or_equal" <?php echo e($range['max_operation'] == 'less_or_equal' ? 'selected' : ''); ?>><?php echo e(translate('Less or Equal')); ?></option>
                                                                <option value="less" <?php echo e($range['max_operation'] == 'less' ? 'selected' : ''); ?>><?php echo e(translate('Less')); ?></option>
                                                            </select>
                                                            <input type="number" class="form-control" name="max_weight[]" placeholder="Ex: X kg"
                                                                   min="0" step="0.01" value="<?php echo e($range['max_weight']); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label for="deliveryCharge" class="form-label"><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                                        <input type="number" class="form-control" id="deliveryCharge" name="delivery_charge[]" placeholder="Ex: $5.00"
                                                               min="0" step="0.01" value="<?php echo e($range['delivery_charge']); ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="btn-grp">
                                                <label class="form-label d-none d-sm-block">&nbsp;</label>
                                                <div class="d-flex align-items-end gap-10px pt-2 justify-content-end justify-content-sm-start">
                                                    <button type="button" class="btn btn-success add-row-<?php echo e($branch->id); ?>"><i class="tio-add"></i></button>
                                                    <button type="button" class="btn btn-soft-danger remove-row-<?php echo e($branch->id); ?>"><i class="tio-clear"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="weight-range-item weight-row-<?php echo e($branch->id); ?>">
                                            <div class="weight-rows">
                                                <div class="row g-3">
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="minWeight" class="form-label"><?php echo e(translate('Min Weight')); ?> (<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</label>
                                                        <div class="input-group">
                                                            <select class="form-control" id="minWeight" name="min_operation[]">
                                                                <option value="greater_or_equal"><?php echo e(translate('Greater or Equal')); ?></option>
                                                                <option value="greater"><?php echo e(translate('Greater')); ?></option>
                                                            </select>
                                                            <input type="number" class="form-control" name="min_weight[]" min="0" step="0.01" placeholder="Ex: X kg" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="maxWeight" class="form-label"><?php echo e(translate('Max Weight')); ?> (<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>)</label>
                                                        <div class="input-group">
                                                            <select class="form-control" name="max_operation[]" id="maxWeight">
                                                                <option value="less_or_equal"><?php echo e(translate('Less or Equal')); ?></option>
                                                                <option value="less"><?php echo e(translate('Less')); ?></option>
                                                            </select>
                                                            <input type="number" class="form-control" name="max_weight[]" min="0" step="0.01" placeholder="Ex: X kg" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label for="deliveryCharge" class="form-label"><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                                        <input type="number" class="form-control" id="deliveryCharge" name="delivery_charge[]"
                                                               min="0" step="0.01" placeholder="Ex: $5.00" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="btn-grp">
                                                <label class="form-label d-none d-sm-block">&nbsp;</label>
                                                <div class="d-flex align-items-end gap-10px pt-2 justify-content-end justify-content-sm-start">
                                                    <button type="button" class="btn btn-success add-row-<?php echo e($branch->id); ?>"><i class="tio-add"></i></button>
                                                    <button type="button" class="btn btn-soft-danger remove-row-<?php echo e($branch->id); ?>"><i class="tio-clear"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="card h-100 shadow-none bg-soft-secondary fs-12">
                                    <div class="card-body">
                                        <h4><?php echo e(translate('Rules')); ?>

                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('Extra delivery charges based on weight will be 0 if the products weight are not within the following weight ranges.')); ?>">
                                            </i></h4>
                                        <ul class="pl-4" id="weight-range-rules-<?php echo e($branch->id); ?>">
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="btn--container mt-4 justify-content-end">
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="confirmChangeModalToArea-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="confirmChangeModalToArea" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <img src="<?php echo e(asset('public/assets/admin/svg/components/info.svg')); ?>" alt="<?php echo e(translate('image')); ?>" class="mb-4">
                    <h4><?php echo e(translate('Are You Sure')); ?>?</h4>
                    <p><?php echo e(translate('Do you want to change the delivery charge setup? You can only use one setup at a time. When you switch to a new setup, the previous one is automatically deactivated.')); ?></p>

                    <p><?php echo e(translate('You must create at least one Zipcode & Its Delivery Charge to enable this delivery charge option.')); ?></p>

                </div>

                <div class="text-center mb-4">
                    <h5 id="addAreaModalLabel"><?php echo e(translate('Add New Area/Zip Code & Delivery Charge')); ?></h5>
                </div>
                <div class="my-2">
                    <form action="<?php echo e(route('admin.business-settings.store.store-delivery-wise-delivery-charge', ['change_status' => 1])); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row bg-soft-secondary py-3">
                            <input type="hidden" name="branch_id" class="branchIdInput" id="branchIdInput-<?php echo e($branch->id); ?>" value="<?php echo e($branch->id); ?>">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="areaName"><?php echo e(translate('Zip Code / Area Name')); ?></label>
                                    <input type="text" class="form-control" id="areaName" name="area_name" placeholder="Ex: 1216" maxlength="255" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="deliveryCharge"><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                    <input type="number" class="form-control" id="deliveryCharge" name="delivery_charge" min="0" step="0.001" max="99999999" placeholder="Ex: $20" required>
                                </div>
                            </div>
                        </div>

                        <div class="btn--container mt-4 justify-content-center">
                            <button type="reset" class="btn btn--reset" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Structure -->
<div class="modal fade" id="editDeliveryChargeModal-<?php echo e($branch->id); ?>" tabindex="-1" aria-labelledby="editDeliveryChargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

                <div class="modal-body">
                    <div class="text-center mb-4">
                        <h5 id="editDeliveryChargeModalLabel"><?php echo e(translate('Edit Area Name/Zip Code & Delivery Charge')); ?></h5>
                    </div>
                    <div class="my-2">
                        <form id="editDeliveryChargeForm-<?php echo e($branch->id); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row bg-soft-secondary py-3">
                                <div class="col-md-6">
                                    <label for="areaName" class="form-label"><?php echo e(translate('Zip Code / Area Name')); ?></label>
                                    <input type="text" class="form-control" id="areaName-<?php echo e($branch->id); ?>" name="area_name" placeholder="Enter area name or zip code">
                                </div>
                                <div class="col-md-6">
                                    <label for="deliveryCharge" class="form-label"><?php echo e(translate('Delivery Charge')); ?>(<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                    <input type="number" class="form-control" id="deliveryCharge-<?php echo e($branch->id); ?>" name="delivery_charge" min="0" step="0.001" max="9999999" placeholder="Enter delivery charge">
                                </div>
                            </div>
                            <div class="btn--container mt-4 justify-content-center">
                                <button type="reset" class="btn btn--reset" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                                <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary call-demo" id="saveChangesButton"><?php echo e(translate('Update')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="addAreaModal-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="addAreaModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-4">
                    <h5 id="addAreaModalLabel"><?php echo e(translate('Add New Area/Zip Code & Delivery Charge')); ?></h5>
                </div>
                <div class="my-2">
                    <form action="<?php echo e(route('admin.business-settings.store.store-delivery-wise-delivery-charge')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row bg-soft-secondary py-3">
                            <input type="hidden" name="branch_id" class="branchIdInput" id="branchIdInput-<?php echo e($branch->id); ?>">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="areaName"><?php echo e(translate('Zip Code / Area Name')); ?></label>
                                    <input type="text" class="form-control" id="areaName" name="area_name" placeholder="Ex: 1216" maxlength="255" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="deliveryCharge"><?php echo e(translate('Delivery Charge')); ?> (<?php echo e(Helpers::currency_symbol()); ?>)</label>
                                    <input type="number" class="form-control" id="deliveryCharge" name="delivery_charge" placeholder="Ex: $20" min="0" max="99999999" step="0.001" required>
                                </div>
                            </div>
                        </div>
                        <div class="btn--container mt-4 justify-content-center">
                            <button type="reset" class="btn btn--reset" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                            <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary call-demo"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- import Modal -->
<div class="modal fade" id="importConfirmModal-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="confirmChangeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="importForm-<?php echo e($branch->id); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="text-center my-4">
                        <img src="<?php echo e(asset('public/assets/admin/svg/components/file.svg')); ?>" alt="<?php echo e(translate('image')); ?>" class="mb-4">
                        <h4><?php echo e(translate('Add New or Replace in the List')); ?></h4>
                        <p><?php echo e(translate('You can download the example file to understand how the file must be filled with proper data.')); ?>

                            <a href="<?php echo e(asset('public/assets/area_bulk_format.xlsx')); ?>" download="" class="fz-16 btn-link">
                                <?php echo e(translate('Download Format')); ?>

                            </a>
                        </p>
                        <p><?php echo e(translate('To upload and add new data to your list, click the "Add New" button. To replace the existing list, click the "Replace" button.')); ?></p>
                    </div>
                    <div class="form-group">
                        <label for="area_list"><?php echo e(translate('Import Area/Zip Code')); ?></label>
                        <input type="file" class="form-control" id="area_list-<?php echo e($branch->id); ?>" name="area_file" accept=".xlsx, .xls" required>
                    </div>
                </div>
                <div class="btn--container mb-4 justify-content-center">
                    <button type="button" data-type="replace" class="btn btn--secondary import-button-<?php echo e($branch->id); ?>" id="replace-<?php echo e($branch->id); ?>"><?php echo e(translate('Replace')); ?></button>
                    <button type="button" data-type="new" class="btn btn--primary import-button-<?php echo e($branch->id); ?>" id="addNew-<?php echo e($branch->id); ?>"><?php echo e(translate('Add New')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Confirmation Modal for Turning On a New Setup -->
<div class="modal fade" id="confirmChangeModal-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="confirmChangeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <img src="<?php echo e(asset('public/assets/admin/svg/components/info.svg')); ?>" alt="<?php echo e(translate('image')); ?>" class="mb-4">
                <h4><?php echo e(translate('Are You Sure')); ?>?</h4>
                <p><?php echo e(translate('Do you want to change the delivery charge setup? You can only use one setup at a time. When you switch to a new setup, the previous one is automatically deactivated.')); ?></p>
            </div>
            <div class="btn--container mb-4 justify-content-center">
                <button type="button" class="btn btn--secondary" id="cancelChange-<?php echo e($branch->id); ?>"><?php echo e(translate('Cancel')); ?></button>
                <button type="button" class="btn btn--primary" id="confirmChange-<?php echo e($branch->id); ?>"><?php echo e(translate('Yes')); ?>, <?php echo e(translate('Change')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Choosing New Setup When Turning Off -->
<div class="modal fade" id="deactivationModal-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="deactivationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <img src="<?php echo e(asset('public/assets/admin/svg/components/info.svg')); ?>" alt="<?php echo e(translate('image')); ?>" class="mb-4">
                    <h4><?php echo e(translate('To Turn Off, Select an Option Below.')); ?></h4>
                    <p><?php echo e(translate('If you want to turn off all setup, you need to choose one of the options below and continue. Without this, the delivery charge can’t work.')); ?></p>
                </div>
                <!-- Delivery charge options -->
                <div class="bg-soft-secondary mx-6 p-3">
                    <div id="option-fixed-<?php echo e($branch->id); ?>" class="delivery-option mt-2">
                        <div class="custom-control custom-radio">
                            <input type="radio" id="option-fixed-radio-<?php echo e($branch->id); ?>" name="new_delivery_charge_type" value="fixed" class="custom-control-input">
                            <label class="custom-control-label" for="option-fixed-radio-<?php echo e($branch->id); ?>"><?php echo e(translate('Fixed Delivery Charge Setup')); ?></label>
                        </div>
                    </div>

                    <div id="option-distance-<?php echo e($branch->id); ?>" class="delivery-option mt-2">
                        <div class="custom-control custom-radio">
                            <input type="radio" id="option-distance-radio-<?php echo e($branch->id); ?>" name="new_delivery_charge_type" value="distance" class="custom-control-input">
                            <label class="custom-control-label" for="option-distance-radio-<?php echo e($branch->id); ?>"><?php echo e(translate('Kilometer Wise Delivery Charge Setup')); ?></label>
                        </div>
                    </div>

                    <div id="option-area-<?php echo e($branch->id); ?>" class="delivery-option mt-2">
                        <div class="custom-control custom-radio">
                            <input type="radio" id="option-area-radio-<?php echo e($branch->id); ?>" name="new_delivery_charge_type" value="area" class="custom-control-input">
                            <label class="custom-control-label" for="option-area-radio-<?php echo e($branch->id); ?>"><?php echo e(translate('Area/Zip Code Wise Delivery Charge Setup')); ?></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="btn--container mb-4 justify-content-center">
                <button type="button" class="btn btn--secondary" id="cancelDeactivation-<?php echo e($branch->id); ?>"><?php echo e(translate('Cancel')); ?></button>
                <button type="button" class="btn btn--primary" id="confirmDeactivation-<?php echo e($branch->id); ?>"><?php echo e(translate('Continue')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- change Weight status Modal -->
<div class="modal fade" id="weightChargeModal-<?php echo e($branch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="weightChargeModalLabel-<?php echo e($branch->id); ?>" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <img src="<?php echo e(asset('public/assets/admin/svg/components/info.svg')); ?>" alt="<?php echo e(translate('image')); ?>" class="mb-4">
                <h4><?php echo e(translate('Need to Update Product Weight')); ?></h4>
                <p><?php echo e(translate('To apply a delivery charge based on weight, update the product weight in the product details. Without this, the delivery charge will not work correctly.')); ?></p>
            </div>

            <div class="btn--container mb-4 justify-content-center">
                <button type="button" class="btn btn--secondary" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                <button type="button" class="btn btn--primary" id="confirmWeightCharge-<?php echo e($branch->id); ?>"><?php echo e(translate('Yes')); ?>, <?php echo e(translate('Confirm')); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).ready(function() {
            $('#kilometerWiseSection-<?php echo e($branch->id); ?>').toggle($('#toggleKilometerWise-<?php echo e($branch->id); ?>').is(':checked'));
            $('#toggleKilometerWise-<?php echo e($branch->id); ?>').change(function() {
                $('#kilometerWiseSection-<?php echo e($branch->id); ?>').toggle(this.checked);
            });

            $('#areaWiseSection-<?php echo e($branch->id); ?>').toggle($('#toggleAreaWise-<?php echo e($branch->id); ?>').is(':checked'));
            $('#toggleAreaWise-<?php echo e($branch->id); ?>').change(function() {
                $('#areaWiseSection-<?php echo e($branch->id); ?>').toggle(this.checked);
            });

            $('#fixedDeliverySection-<?php echo e($branch->id); ?>').toggle($('#toggleFixed-<?php echo e($branch->id); ?>').is(':checked'));
            $('#toggleFixed-<?php echo e($branch->id); ?>').change(function() {
                $('#fixedDeliverySection-<?php echo e($branch->id); ?>').toggle(this.checked);
            });
        });

        $(document).ready(function() {
            $('[data-toggle="modal"]').on('click', function() {
                var branchId = $(this).data('id');
                $('#addAreaModal-' + branchId).on('shown.bs.modal', function () {
                    $(this).find('.branchIdInput').val(branchId);
                });
            });
        });

        $(document).ready(function() {
            $('.edit-area').on('click', function() {
                var deliveryAreaId = $(this).data('id');
                var branchId = $(this).data('target').split('-').pop();

                var actionUrl = '/admin/business-settings/store/update-area-delivery-charge/' + deliveryAreaId;
                $('#editDeliveryChargeForm-' + branchId).attr('action', actionUrl);

                $.ajax({
                    url: '/admin/business-settings/store/edit-area-delivery-charge/' + deliveryAreaId,
                    method: 'GET',
                    success: function(data) {
                        $('#areaName-' + branchId).val(data.area_name);
                        $('#deliveryCharge-' + branchId).val(data.delivery_charge);
                    },
                    error: function(xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
        });

        $(document).ready(function() {
            let checkbox = null;
            let previousState = null;

            function showDeactivationModal() {
                const currentType = checkbox.data('type');

                $('.delivery-option').hide();
                $('input[name="new_delivery_charge_type"]').prop('checked', false);

                if (currentType === 'fixed') {
                    $('#option-distance-<?php echo e($branch->id); ?>, #option-area-<?php echo e($branch->id); ?>').show();
                    $('#option-distance-radio-<?php echo e($branch->id); ?>').prop('checked', true);
                } else if (currentType === 'distance') {
                    $('#option-fixed-<?php echo e($branch->id); ?>, #option-area-<?php echo e($branch->id); ?>').show();
                    $('#option-fixed-radio-<?php echo e($branch->id); ?>').prop('checked', true);
                } else if (currentType === 'area') {
                    $('#option-fixed-<?php echo e($branch->id); ?>, #option-distance-<?php echo e($branch->id); ?>').show();
                    $('#option-fixed-radio-<?php echo e($branch->id); ?>').prop('checked', true);
                }

                $('#deactivationModal-<?php echo e($branch->id); ?>').modal('show');
            }

            function confirmDeactivation() {
                if (checkbox) {
                    let deliveryChargeType = checkbox.data('type');
                    let branchId = checkbox.data('branch-id');
                    let status = 0;

                    // Get the selected new delivery charge type
                    let newDeliveryChargeType = $('input[name="new_delivery_charge_type"]:checked').val();

                    $.ajax({
                        url: "<?php echo e(route('admin.business-settings.store.change-delivery-charge-type')); ?>",
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            delivery_charge_type: deliveryChargeType,
                            branch_id: branchId,
                            status: status,
                            new_delivery_charge_type: newDeliveryChargeType
                        },
                        success: function(response) {
                            if(response.status != false){
                                toastr.success(response.message);
                                location.reload();
                            }else {
                                toastr.error(response.error);
                                checkbox.prop('checked', previousState);
                            }
                        },
                        error: function() {
                            checkbox.prop('checked', previousState);
                        }
                    });
                }
            }

            $('.change-delivery-charge-type-<?php echo e($branch->id); ?>').change(function() {
                checkbox = $(this);
                previousState = checkbox.is(':checked');

                if (!previousState) {
                    showDeactivationModal();
                } else {
                    // Show the existing modal for activation
                    $('#confirmChangeModal-<?php echo e($branch->id); ?>').modal('show');
                }
            });

            $('#confirmChange-<?php echo e($branch->id); ?>').click(function() {
                if (checkbox) {
                    let deliveryChargeType = checkbox.data('type');
                    let branchId = checkbox.data('branch-id');
                    let status = 1; // We're activating a new type

                    $.ajax({
                        url: "<?php echo e(route('admin.business-settings.store.change-delivery-charge-type')); ?>",
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            delivery_charge_type: deliveryChargeType,
                            branch_id: branchId,
                            status: status
                        },
                        success: function(response) {
                            console.log(response)
                            if(response.status != false){
                                toastr.success(response.message);
                                location.reload();
                            }else {
                                toastr.error(response.error);
                                checkbox.prop('checked', previousState);
                            }
                        },
                        error: function() {
                            checkbox.prop('checked', previousState);
                        }
                    });
                }
            });

            $('#confirmDeactivation-<?php echo e($branch->id); ?>').click(function() {
                confirmDeactivation();
            });

            $('#cancelChange-<?php echo e($branch->id); ?>').click(function() {
                if (checkbox) {
                    checkbox.prop('checked', previousState);
                }
                $('#confirmChangeModal-<?php echo e($branch->id); ?>').modal('hide');
            });

            $('#cancelDeactivation-<?php echo e($branch->id); ?>').click(function() {
                if (checkbox) {
                    checkbox.prop('checked', previousState);
                }
                $('#deactivationModal-<?php echo e($branch->id); ?>').modal('hide');
            });

            $('#deactivationModal-<?php echo e($branch->id); ?>, #confirmChangeModal-<?php echo e($branch->id); ?>').on('hidden.modal', function () {
                if (checkbox) {
                    checkbox.prop('checked', previousState);
                }
            });

            $('.change-delivery-charge-to-area-<?php echo e($branch->id); ?>').change(function() {
                checkbox = $(this);
                previousState = checkbox.is(':checked');

                if (!previousState) {
                    showDeactivationModal();
                } else {
                    $('#confirmChangeModalToArea-<?php echo e($branch->id); ?>').modal('show');
                }

                $('#confirmChangeModalToArea-<?php echo e($branch->id); ?>').on('hidden.bs.modal', function () {
                    if (checkbox) {
                        checkbox.prop('checked', !previousState);
                    }
                });

            });
        });

        $(document).ready(function() {
            $('.import-button-<?php echo e($branch->id); ?>').on('click', function() {
                var branchId = <?php echo e($branch->id); ?>;
                var type = $(this).data('type');
                var form = $('#importForm-' + branchId)[0];
                var formData = new FormData(form);
                formData.append('type', type);

                $.ajax({
                    url: '/admin/business-settings/store/import-area-delivery-charge/' + branchId,
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    headers: {
                        'X-CSRF-TOKEN': $('input[name=_token]').val()
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            toastr.success(response.message);
                            location.reload();
                        } else {
                            toastr.error(response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        let response = JSON.parse(xhr.responseText);
                        toastr.error(response.message);
                    }
                });
            });
        });

    </script>

    <script>
        $(document).ready(function() {
            // Toggle visibility of weight charge section based on checkbox status
            $('#toggleWeightCharge-<?php echo e($branch->id); ?>').change(function() {
                $('#weightChargeSection-<?php echo e($branch->id); ?>').toggle(this.checked);
            });

            // Toggle between Per Kg and Weight Range sections
            $('input[name="weight_charge_type-<?php echo e($branch->id); ?>"]').change(function() {
                if ($('#chargePerKg-<?php echo e($branch->id); ?>').is(':checked')) {
                    $('#perKgSection-<?php echo e($branch->id); ?>').show();
                    $('#weightRangeSection-<?php echo e($branch->id); ?>').hide();
                } else if ($('#chargeByRange-<?php echo e($branch->id); ?>').is(':checked')) {
                    $('#perKgSection-<?php echo e($branch->id); ?>').hide();
                    $('#weightRangeSection-<?php echo e($branch->id); ?>').show();
                }
            });
            $('input[name="weight_charge_type-<?php echo e($branch->id); ?>"]').trigger('change');

            // Handle showing the modal or directly submitting the form
            $('#toggleWeightCharge-<?php echo e($branch->id); ?>').change(function() {
                if (this.checked) {
                    $('#weightChargeModal-<?php echo e($branch->id); ?>').modal('show');
                } else {
                    $('#weightChargeStatus-<?php echo e($branch->id); ?>').val(0);
                    $('#weightChargeForm-<?php echo e($branch->id); ?>').submit();
                }
            });

            // Confirm action in the modal
            $('#confirmWeightCharge-<?php echo e($branch->id); ?>').click(function() {
                $('#weightChargeStatus-<?php echo e($branch->id); ?>').val(1);
                $('#weightChargeForm-<?php echo e($branch->id); ?>').submit();
            });

            // Handle modal close without confirming
            $('#weightChargeModal-<?php echo e($branch->id); ?>').on('hidden.bs.modal', function() {
                if (!$('#weightChargeStatus-<?php echo e($branch->id); ?>').val()) {
                    $('#toggleWeightCharge-<?php echo e($branch->id); ?>').prop('checked', false);
                }
            });
        });


        $(document).ready(function() {

            function updateRules() {
                const rows = $('#weightRows-<?php echo e($branch->id); ?> .weight-row-<?php echo e($branch->id); ?>');
                const totalRows = rows.length;

                const rulesList = $('#weight-range-rules-<?php echo e($branch->id); ?>');

                let symbol = '<?php echo e(Helpers::currency_symbol()); ?>';
                let weightUnit = '<?php echo e(Helpers::get_business_settings('product_weight_unit')); ?>';

                rulesList.empty();
                if (totalRows > 0) {
                    rows.each(function(index) {
                        const minWeight = $(this).find('input[name="min_weight[]"]').val();
                        const minOperation = $(this).find('select[name="min_operation[]"]').val();
                        const maxWeight = $(this).find('input[name="max_weight[]"]').val();
                        const maxOperation = $(this).find('select[name="max_operation[]"]').val();

                        const deliveryCharge = $(this).find('input[name="delivery_charge[]"]').val();
                        let rule = '';

                        if (minOperation === 'greater_or_equal') {
                            rule += minWeight +' '+ weightUnit;
                            rule += ' >= weight ';
                        } else if (minOperation === 'greater') {
                            rule += minWeight +' '+ weightUnit;
                            rule += ' > weight ';
                        }

                        if (maxOperation === 'less_or_equal') {
                            rule += '<= ' + maxWeight +' '+ weightUnit;
                        } else if (maxOperation === 'less') {
                            rule += '< ' + maxWeight +' '+ weightUnit;
                        }

                        rule += ' = ' + deliveryCharge +' '+ symbol;

                        rulesList.append('<li>' + rule + '</li>');
                    });
                } else {
                    rulesList.append('<li><?php echo e(translate("No rules added yet")); ?></li>');
                }
            }

            $('input[name="delivery_charge[]"], input[name="max_weight[]"], input[name="min_weight[]"]').on('input', function(){
                updateRules()
                updateMinMaxWeight()
            });

            $('select[name="max_operation[]"], select[name="min_operation[]"]').on('change', function(){
                updateRules()
                updateMinMaxWeight()
            });

            function updateButtons() {
                const rows = $('#weightRows-<?php echo e($branch->id); ?> .weight-row-<?php echo e($branch->id); ?>');
                const totalRows = rows.length;

                // Hide all add and remove buttons first
                rows.find('.add-row-<?php echo e($branch->id); ?>').hide();
                rows.find('.remove-row-<?php echo e($branch->id); ?>').hide();

                if (totalRows >= 0) {
                    rows.each(function(index) {
                        const addButton = $(this).find('.add-row-<?php echo e($branch->id); ?>');
                        const removeButton = $(this).find('.remove-row-<?php echo e($branch->id); ?>');

                        addButton.show();
                        removeButton.show();

                        if (index == 0) {
                            removeButton.hide()
                            totalRows > 1 && addButton.hide()
                        } else if (index === totalRows - 1) {
                            addButton.show();
                            removeButton.show();
                        } else {
                            addButton.hide();
                            removeButton.hide();
                        }

                    });
                } else {
                    rows.find('.add-row-<?php echo e($branch->id); ?>').show();
                }
                updateRules()
                updateMinMaxWeight();
            }

            // Initialize buttons on document ready
            updateButtons();

            // Adjust Min max value when overall data updating
            function updateMinMaxWeight() {
                const rows = $('#weightRows-<?php echo e($branch->id); ?> .weight-row-<?php echo e($branch->id); ?>');
                const totalRows = rows.length;

                if (totalRows > 0) {
                    rows.each(function(index) {
                        const minWeight = $(this).find('input[name="min_weight[]"]').val();
                        const maxWeight = $(this).find('input[name="max_weight[]"]').val();

                        if (index > 0) {
                            const previousRow = $(this).prev();
                            if(previousRow) {
                                const previousMaxWeight = previousRow.find('input[name="max_weight[]"]').val();
                                const previousMaxOperation = previousRow.find('select[name="max_operation[]"]').val();

                                $(this).find('input[name="min_weight[]"]').val(previousMaxWeight)
                                $(this).find('input[name="max_weight[]"]').attr('min', previousMaxWeight)

                                if (previousMaxOperation === 'less') {
                                    $(this).find('select[name="min_operation[]"]').val('greater_or_equal').prop('disabled', true).append('<input type="hidden" name="min_operation[]" value="greater_or_equal">');
                                } else if (previousMaxOperation === 'less_or_equal') {
                                    $(this).find('select[name="min_operation[]"]').val('greater').prop('disabled', true).append('<input type="hidden" name="min_operation[]" value="greater">');
                                }
                            }
                        } else {
                            // $(this).find('select[name="min_operation[]"]').val('greater_or_equal').prop('disabled', true).append('<input type="hidden" name="min_operation[]" value="greater_or_equal">');
                        }
                    });
                }
            }

            // Bind the add row event
            $('#weightRows-<?php echo e($branch->id); ?>').on('click', '.add-row-<?php echo e($branch->id); ?>', function() {
                // Target the last row in the container to use as a reference for cloning
                var lastRow = $('#weightRows-<?php echo e($branch->id); ?> .weight-row-<?php echo e($branch->id); ?>:last');
                var newRow = lastRow.clone(true);

                // Get the previous (last) row's max weight and operation
                var previousRowMaxWeight = lastRow.find('input[name="max_weight[]"]').val();
                var previousRowMaxOperation = lastRow.find('select[name="max_operation[]"]').val();
                var previousRowMinWeight = lastRow.find('input[name="min_weight[]"]').val();



                if (parseFloat(previousRowMaxWeight) <= 0 || parseFloat(previousRowMinWeight) < 0) {
                    Swal.fire({
                        type: 'warning',
                        title: '<?php echo e(translate("Weight values must be positive")); ?>!',
                        text: '<?php echo e(translate("Please enter positive values for Min Weight and Max Weight.")); ?>',
                        confirmButtonText: '<?php echo e(translate("OK")); ?>',
                        confirmButtonColor: '#107980',
                    });
                    if(parseFloat(previousRowMinWeight) <= 0){
                        lastRow.find('input[name="min_weight[]"]').val('');
                    }
                    if(parseFloat(previousRowMaxWeight) <= 0){
                        lastRow.find('input[name="max_weight[]"]').val('');
                    }
                    return; // Prevent adding a new row if weights are not positive
                }

                if (!previousRowMinWeight) {
                    Swal.fire({
                        type: 'warning',
                        title: '<?php echo e(translate("Please enter a value for Min Weight.")); ?>',
                        text: '<?php echo e(translate("Min Weight is required before adding a new row")); ?>!',
                        confirmButtonText: '<?php echo e(translate("OK")); ?>',
                        confirmButtonColor: '#107980',
                    });
                    return; // Prevent adding a new row if max weight is not provided
                }

                // Check if max weight is provided
                if (!previousRowMaxWeight) {
                    Swal.fire({
                        type: 'warning',
                        title: '<?php echo e(translate("Please enter a value for Max Weight.")); ?>',
                        text: '<?php echo e(translate("Max Weight is required before adding a new row")); ?>!',
                        confirmButtonText: '<?php echo e(translate("OK")); ?>',
                        confirmButtonColor: '#107980',
                    });
                    return; // Prevent adding a new row if max weight is not provided
                }

                if (parseFloat(previousRowMaxWeight) <= parseFloat(previousRowMinWeight)) {
                    Swal.fire({
                        type: 'warning',
                        title: '<?php echo e(translate("Max Weight must be greater than Min Weight")); ?>!',
                        text: '<?php echo e(translate("Please select at least one login option.")); ?>',
                        confirmButtonText: '<?php echo e(translate("OK")); ?>',
                        confirmButtonColor: '#107980',
                    });
                    lastRow.find('input[name="max_weight[]"]').val('');
                    return; // Prevent adding a new row if validation fails
                }

                // Clear inputs for the new row
                newRow.find('input').val('');
                newRow.find('select').prop('selectedIndex', 0);

                // Change button from add to remove for the new row
                // newRow.find('.add-row-<?php echo e($branch->id); ?>').removeClass('btn-success add-row-<?php echo e($branch->id); ?>').addClass('btn-danger remove-row-<?php echo e($branch->id); ?>').text('-');

                // Set the new row's min weight to the previous row's max weight
                newRow.find('input[name="min_weight[]"]').val(previousRowMaxWeight).prop('readonly', true);

                // Conditionally set the new row's min weight operation based on the previous row's max operation
                if (previousRowMaxOperation === 'less') {
                    newRow.find('select[name="min_operation[]"]').val('greater_or_equal').prop('disabled', true).append('<input type="hidden" name="min_operation[]" value="greater_or_equal">');

                } else if (previousRowMaxOperation === 'less_or_equal') {
                    newRow.find('select[name="min_operation[]"]').val('greater').prop('disabled', true).append('<input type="hidden" name="min_operation[]" value="greater">');
                }

                // Append the new row to the container
                $('#weightRows-<?php echo e($branch->id); ?>').append(newRow);
                lastRow.find('input[name="min_weight[]"]').prop('readonly', true);

                // Update buttons after adding a new row
                updateButtons();
            });

            // Bind the remove row event
            $('#weightRows-<?php echo e($branch->id); ?>').on('click', '.remove-row-<?php echo e($branch->id); ?>', function() {
                $(this).closest('.weight-row-<?php echo e($branch->id); ?>').remove();

                const remainingRows = $('#weightRows-<?php echo e($branch->id); ?> .weight-row-<?php echo e($branch->id); ?>');

                if (remainingRows.length === 1) {
                    // If only one row remains, make the min_weight field editable (readonly = false)
                    remainingRows.find('input[name="min_weight[]"]').prop('readonly', false);
                }else {
                    remainingRows.first().find('input[name="min_weight[]"]').prop('readonly', true); // Readonly for the first row
                }

                updateButtons();
            });
        });



    </script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/partial/delivery_charge_form.blade.php ENDPATH**/ ?>