<?php $__env->startSection('title', translate('Offline Payment')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/business_setup2.png')); ?>" alt="<?php echo e(translate('business_setup')); ?>">
                <span class="page-header-title ml-2 mb-0">
                    <?php echo e(translate('Offline Payment Method Setup')); ?>

                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="justify-content-between align-items-center gy-2">
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search" class="form-control" placeholder="<?php echo e(translate('Search_by_method_name')); ?>" aria-label="Search" value="<?php echo e($search); ?>" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn--primary">
                                            <?php echo e(translate('Search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div>
                            <a href="<?php echo e(route('admin.business-settings.web-app.third-party.offline-payment.add')); ?>" type="button" class="btn btn--primary"><i class="tio-add"></i><?php echo e(translate('Add New Method')); ?></a>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(translate('SL')); ?></th>
                                    <th><?php echo e(translate('Payment Method Name')); ?></th>
                                    <th><?php echo e(translate('Payment Info')); ?></th>
                                    <th><?php echo e(translate('Required Info from Customer')); ?></th>
                                    <th class="text-center"><?php echo e(translate('status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('action')); ?></th>
                                </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($methods->firstitem()+$key); ?></td>
                                        <td>
                                            <div class="max-w300 text-wrap">
                                                <?php echo e($method['method_name']); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <?php $__currentLoopData = $method['method_fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="border border-white max-w300 text-wrap text-left">
                                                    <?php echo e($fields['field_name']); ?> : <?php echo e(translate($fields['field_data'])); ?>

                                                </span><br/>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>
                                            <?php $__currentLoopData = $method['method_informations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$informations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="border border-white max-w300 text-wrap text-left">
                                                     <?php echo e(translate($informations['information_name'])); ?> |
                                                </span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <div class="max-w300 text-wrap">
                                               <?php echo e(translate('Payment note')); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <label class="toggle-switch my-0">
                                                <input type="checkbox"
                                                       class="toggle-switch-input status-change-alert" id="stocksCheckbox<?php echo e($method->id); ?>"
                                                       data-route="<?php echo e(route('admin.business-settings.web-app.third-party.offline-payment.status', [$method->id, $method->status ? 0 : 1])); ?>"
                                                       data-message="<?php echo e($method->status? translate('you_want_to_disable_this_method'): translate('you_want_to_active_this_method')); ?>?"
                                                    <?php echo e($method->status ? 'checked' : ''); ?>>
                                                <span class="toggle-switch-label mx-auto text">
                                                    <span class="toggle-switch-indicator"></span>
                                                </span>
                                            </label>
                                        </td>
                                        <td>
                                            <div class="btn--container justify-content-center">
                                                <a class="action-btn"
                                                   href="<?php echo e(route('admin.business-settings.web-app.third-party.offline-payment.edit', [$method['id']])); ?>">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <button class="action-btn btn--danger btn-outline-danger delete-method"
                                                        data-id="<?php echo e($method->id); ?>">
                                                    <i class="tio-delete-outlined"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                <?php echo $methods->links(); ?>

                            </div>
                        </div>

                        <?php if(count($methods) == 0): ?>
                            <div class="text-center p-4">
                                <img class="w-120px mb-3" src="<?php echo e(asset('/public/assets/admin/svg/illustrations/sorry.svg')); ?>" alt="<?php echo e(translate('Image')); ?>">
                                <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        "use strict";

        $('.delete-method').on('click', function(){
            let id = $(this).data('id');
            deleteItem(id)
        })
        function deleteItem(id) {
            Swal.fire({
                title: '<?php echo e(translate('Are you sure')); ?>?',
                text: "<?php echo e(translate('You will not be able to revert this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#FC6A57',
                cancelButtonColor: '#EA295E',
                confirmButtonText: '<?php echo e(translate('Yes, delete it')); ?>!'
            }).then((result) => {
                if (result.value) {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.business-settings.web-app.third-party.offline-payment.delete')); ?>",
                        method: 'POST',
                        data: {
                                id: id,
                                "_token": "<?php echo e(csrf_token()); ?>",
                            },
                        success: function () {
                            toastr.success('<?php echo e(translate('Removed successfully')); ?>');
                            location.reload();
                        }
                    });
                }
            })
        }
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/business-settings/offline-payment/list.blade.php ENDPATH**/ ?>