<?php $__env->startSection('title', translate('verify_offline_payments')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="mb-0 page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/all_orders.png')); ?>" class="w--20" alt="<?php echo e(translate('orders')); ?>">
                </span>
                <span class="">
                    <?php echo e(translate('verify_offline_payments')); ?>

                    <span class="badge badge-pill badge-soft-secondary ml-2"><?php echo e($orders->total()); ?></span>
                </span>
            </h1>
            <ul class="nav nav-tabs border-0 my-2">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Request::is('branch/verify-offline-payment/pending')?'active':''); ?>"  href="<?php echo e(route('branch.verify-offline-payment', ['pending'])); ?>"><?php echo e(translate('Pending Orders')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Request::is('branch/verify-offline-payment/denied')?'active':''); ?>"  href="<?php echo e(route('branch.verify-offline-payment', ['denied'])); ?>"><?php echo e(translate('Denied Orders')); ?></a>
                </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body p-20px">
                <div class="order-top">
                    <div class="card--header">
                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                            <div class="input-group">
                                <input id="datatableSearch_" type="search" name="search"
                                       class="form-control"
                                       placeholder="<?php echo e(translate('Search by order ID')); ?>" aria-label="Search"
                                       value="<?php echo e($search); ?>" required autocomplete="off">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text">
                                        <?php echo e(translate('Search')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                        <thead class="thead-light">
                        <tr>
                            <th class="">
                                <?php echo e(translate('#')); ?>

                            </th>
                            <th class="table-column-pl-0"><?php echo e(translate('order ID')); ?></th>
                            <th><?php echo e(translate('Delivery')); ?> <?php echo e(translate('date')); ?></th>
                            <th><?php echo e(translate('customer')); ?></th>
                            <th><?php echo e(translate('total amount')); ?></th>
                            <th><?php echo e(translate('Payment_Method')); ?></th>
                            <th><?php echo e(translate('Verification_Status')); ?></th>
                            <th>
                                <div class="text-center">
                                    <?php echo e(translate('action')); ?>

                                </div>
                            </th>
                        </tr>
                        </thead>

                        <tbody id="set-rows">
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr class="status-<?php echo e($order['order_status']); ?> class-all">
                                <td class="">
                                    <?php echo e($orders->firstItem()+$key); ?>

                                </td>
                                <td class="table-column-pl-0">
                                    <a href="<?php echo e(route('branch.orders.details',['id'=>$order['id']])); ?>"><?php echo e($order['id']); ?></a>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(date('d M Y',strtotime($order['delivery_date']))); ?>

                                        <span><?php echo e($order->time_slot?date(config('time_format'), strtotime($order->time_slot['start_time'])).' - ' .date(config('time_format'), strtotime($order->time_slot['end_time'])) :'No Time Slot'); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <?php if($order->is_guest == 0): ?>
                                        <?php if(isset($order->customer)): ?>
                                            <div>
                                                <a class="text-body text-capitalize font-medium"
                                                   href="#"><?php echo e($order->customer['f_name'].' '.$order->customer['l_name']); ?></a>
                                            </div>
                                            <div class="text-sm">
                                                <a href="Tel:<?php echo e($order->customer['phone']); ?>"><?php echo e($order->customer['phone']); ?></a>
                                            </div>
                                        <?php elseif($order->user_id != null && !isset($order->customer)): ?>
                                            <label
                                                class="text-danger"><?php echo e(translate('Customer_not_available')); ?>

                                            </label>
                                        <?php else: ?>
                                            <label
                                                class="text-success"><?php echo e(translate('Walking Customer')); ?>

                                            </label>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <label
                                            class="text-success"><?php echo e(translate('Guest Customer')); ?>

                                        </label>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="mw-90">
                                        <div>
                                                <?php
                                                $vat_status = $order->details[0] ? $order->details[0]->vat_status : '';
                                                if($vat_status == 'included'){
                                                    $order_amount = $order['order_amount'] - $order['total_tax_amount'];
                                                }else{
                                                    $order_amount = $order['order_amount'];
                                                }
                                                ?>
                                            <?php echo e(Helpers::set_symbol($order_amount)); ?>

                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php
                                        $payment_info = json_decode($order->offline_payment?->payment_info, true);
                                    ?>
                                    <?php echo e($paymentInfo['payment_name'] ?? null); ?>

                                </td>
                                <td class="text-capitalize">
                                    <?php if($order->offline_payment?->status == 0): ?>
                                        <span class="badge badge-soft-info">
                                            <?php echo e(translate('pending')); ?>

                                        </span>
                                    <?php elseif($order->offline_payment?->status == 2): ?>
                                        <span class="badge badge-soft-danger">
                                            <?php echo e(translate('denied')); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="justify-content-center gap-2 d-flex">
                                        <button class="btn px-3 btn--primary offline_details" type="button" id="offline_details"
                                                data-id="<?php echo e($order['id']); ?>" data-target="" data-toggle="modal">
                                            <?php echo e(translate('Verify_Payment')); ?>

                                        </button>
                                        <?php if($order->offline_payment?->status != 2): ?>
                                            <button class="btn badge-danger deny-payment-btn" data-order-id="<?php echo e($order->id); ?>" data-status="2"><?php echo e(translate('deny')); ?></button>
                                        <?php endif; ?>
                                        <a class="btn badge-info flex-grow-1" href="<?php echo e(route('branch.orders.verify-offline-payment', ['order_id' => $order->id, 'status' => 1])); ?>"><?php echo e(translate('approve')); ?></a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php if(count($orders)==0): ?>
                    <div class="text-center p-4">
                        <img class="w-120px mb-3" src="<?php echo e(asset('public/assets/admin/svg/illustrations/sorry.svg')); ?>" alt="<?php echo e(translate('image')); ?>">
                        <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="card-footer border-0">
                <div class="d-flex justify-content-center justify-content-sm-end">
                    <?php echo $orders->links(); ?>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="quick-view" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered coupon-details modal-lg" role="document">
            <div class="modal-content" id="quick-view-modal">
            </div>
        </div>
    </div>

    <div class="modal fade" id="denyPaymentModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body pt-5 p-md-5">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
                    <div class="d-flex justify-content-center mb-4">
                        <img width="75" height="75" src="<?php echo e(asset('public/assets/admin/svg/components/info.svg')); ?>" class="rounded-circle" alt="">
                    </div>

                    <h3 class="text-start mb-1 fw-medium text-center"><?php echo e(translate('Are you sure you want to deny?')); ?></h3>
                    <p class="text-start fs-12 fw-medium text-muted text-center"><?php echo e(translate('Please insert the deny note for this payment request')); ?></p>
                    <form method="GET" id="denyPaymentForm">
                        <div>
                            <label for="add-your-note" class="d-block mb-2 fz-12px title-clr d-flex align-items-end gap-2"><?php echo e(translate('Deny Note')); ?> <span class="text-danger fz-12px">*</span></label>
                            <textarea class="form-control h-69px" placeholder="<?php echo e(translate('Type here your note')); ?>" name="denied_note" id="add-your-note" maxlength="255" required></textarea>
                            <div class="d-flex justify-content-center mt-3 gap-3">
                                <button type="button" class="btn btn--reset min-w-120px px-2" data-dismiss="modal" aria-label="Close"><?php echo e(translate('Cancel')); ?></button>
                                <button type="submit" class="btn btn-primary min-w-120px"><?php echo e(translate('Submit')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        "use strict";

        $('.offline_details').on('click', function() {
            let id = $(this).data('id');
            get_offline_payment(id);
        });

        function get_offline_payment(id){
            $.ajax({
                type: 'GET',
                url: '<?php echo e(route('branch.offline-modal-view')); ?>',
                data: {
                    id: id
                },
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    $('#loading').hide();
                    $('#quick-view').modal('show');
                    $('#quick-view-modal').empty().html(data.view);
                }
            });
        }

        $(document).on('click', '.deny-payment-btn', function() {
            var orderId = $(this).data('order-id');
            var status = $(this).data('status');
            var url = '<?php echo e(url('/')); ?>/branch/orders/verify-offline-payment/'+ orderId + '/' + status;

            $('#denyPaymentForm').attr('action', url);
            $('#denyPaymentModal').modal('show');
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/branch-views/order/offline-payment/list.blade.php ENDPATH**/ ?>