<?php $__env->startSection('title', translate('Add new notification')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/notification.png')); ?>" class="w--20" alt="<?php echo e(translate('notification')); ?>">
                </span>
                <span>
                    <?php echo e(translate('Send Push Notification')); ?>

                </span>
            </h1>
        </div>
        <div class="row">
            <div class="col-sm-12 mb-5">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.notification.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label mb-3" for="exampleFormControlInput1"><?php echo e(translate('title')); ?></label>
                                        <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" placeholder="<?php echo e(translate('Ex : New Notification')); ?>" required>
                                    </div>
                                    <div class="form-group mb-0">
                                        <label class="form-label mb-3" for="exampleFormControlInput1"><?php echo e(translate('description')); ?>

                                            <i class="tio-info-outined"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="<?php echo e(translate('Description maximum character length must be 255')); ?>">
                                            </i>
                                        </label>
                                        <textarea name="description" class="form-control h--92px" placeholder="<?php echo e(translate('Ex : Max 250 Words')); ?>" required><?php echo e(old('description')); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex flex-column justify-content-center h-100">
                                        <h5 class="text-center mb-3 mt-auto text--title text-capitalize">
                                            <?php echo e(translate('notification banner')); ?>

                                            <small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 3:1 )</small>
                                        </h5>
                                        <label class="upload--vertical mt-auto">
                                            <input type="file" name="image" id="customFileEg1" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" hidden>
                                            <img id="viewer" src="<?php echo e(asset('public/assets/admin/img/upload-vertical.png')); ?>" alt="notification image"/>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="btn--container justify-content-end mt-2">
                                        <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                        <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header border-0 flex-between">
                        <div class="card--header">
                            <h5 class="card-title"><?php echo e(translate('Notifications Table')); ?> <span class="ml-2 badge badge-pill badge-soft-secondary"><?php echo e($notifications->total()); ?></span> </h5>
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search"
                                            class="form-control"
                                            placeholder="<?php echo e(translate('Search')); ?>" aria-label="Search"
                                            value="<?php echo e($search); ?>" required autocomplete="off">
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text">
                                            <?php echo e(translate('search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive datatable-custom">
                        <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(translate('#')); ?></th>
                                    <th><?php echo e(translate('image')); ?></th>
                                    <th><?php echo e(translate('title')); ?></th>
                                    <th><?php echo e(translate('description')); ?></th>
                                    <th class="text-center"><?php echo e(translate('status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('action')); ?></th>
                                </tr>
                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($notifications->firstItem()+$key); ?></td>
                                    <td>
                                        <?php if($notification['image']!=null): ?>
                                            <img class="img-vertical-150"
                                                 src="<?php echo e($notification->imageFullPath); ?>"
                                            alt="<?php echo e(translate('notification')); ?>">
                                        <?php else: ?>
                                            <label class="badge badge-soft-warning">No <?php echo e(translate('image')); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                    <span class="d-block font-size-sm text-body">
                                        <?php echo e(substr($notification['title'],0,25)); ?> <?php echo e(strlen($notification['title'])>25?'...':''); ?>

                                    </span>
                                    </td>
                                    <td>
                                        <div class="line--limit-2 max-200px ">
                                        <?php echo e(substr($notification['description'],0,50)); ?> <?php echo e(strlen($notification['description'])>25?'...':''); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <label class="toggle-switch my-0">
                                            <input type="checkbox"
                                                   data-route="<?php echo e(route('admin.notification.status', [$notification->id, $notification->status ? 0 : 1])); ?>"
                                                   data-message="<?php echo e($notification->status? translate('you_want_to_disable_this_notification'): translate('you_want_to_active_this_notification')); ?>?"
                                                    class="toggle-switch-input status-change-alert" id="stocksCheckbox<?php echo e($notification->id); ?>"
                                                    <?php echo e($notification->status ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label mx-auto text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="btn--container justify-content-center">
                                            <a class="action-btn"
                                                href="<?php echo e(route('admin.notification.edit',[$notification['id']])); ?>">
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="action-btn btn--danger btn-outline-danger form-alert" href="javascript:"
                                               data-id="notification-<?php echo e($notification['id']); ?>"
                                               data-message="<?php echo e(translate("Want to delete this")); ?>?">
                                                <i class="tio-delete-outlined"></i>
                                            </a>
                                            <form
                                                action="<?php echo e(route('admin.notification.delete',[$notification['id']])); ?>"
                                                method="post" id="notification-<?php echo e($notification['id']); ?>">
                                                <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <table>
                            <tfoot>
                            <?php echo $notifications->links(); ?>

                            </tfoot>
                        </table>
                        <?php if(count($notifications)==0): ?>
                            <div class="text-center p-4">
                                <img class="mb-3 width-7rem" src="<?php echo e(asset('public/assets/admin')); ?>/svg/illustrations/sorry.svg" alt="<?php echo e(translate('image')); ?>">
                                <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
<script src="<?php echo e(asset('public/assets/admin/js/upload-single-image.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/notification/index.blade.php ENDPATH**/ ?>