<?php $__env->startSection('title', translate('Add new category')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/category.png')); ?>" class="w--24" alt="<?php echo e(translate('category')); ?>">
                </span>
                <span>
                    <?php echo e(translate('category_setup')); ?>

                </span>
            </h1>
        </div>

        <div class="row g-2">
            <div class="col-sm-12 col-lg-12">
                <div class="card">
                    <div class="card-body pt-sm-0 pb-sm-4">
                        <form action="<?php echo e(route('admin.category.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php ($data = Helpers::get_business_settings('language')); ?>
                            <?php ($defaultLanguage = Helpers::get_default_language()); ?>
                            <?php if($data && array_key_exists('code', $data[0])): ?>
                                <ul class="nav nav-tabs d-inline-flex mb--n-30">
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link lang_link <?php echo e($lang['default'] == true ? 'active' : ''); ?>" href="#"
                                        id="<?php echo e($lang['code']); ?>-link"><?php echo e(Helpers::get_language_name($lang['code']) . '(' . strtoupper($lang['code']) . ')'); ?></a>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <div class="row align-items-end g-4">
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-sm-6 <?php echo e($lang['default'] == false ? 'd-none' : ''); ?> lang_form"
                                                id="<?php echo e($lang['code']); ?>-form">
                                            <label class="form-label"
                                                    for="exampleFormControlInput1"><?php echo e(translate('category')); ?> <?php echo e(translate('name')); ?>

                                                (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                            <input type="text" name="name[]" class="form-control" placeholder="<?php echo e(translate('Ex: Size')); ?>" maxlength="255"
                                                    <?php echo e($lang['status'] == true ? 'required':''); ?>

                                                    <?php if($lang['status'] == true): ?> oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>>
                                        </div>
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="lang_form col-sm-6" id="<?php echo e($defaultLanguage); ?>-form">
                                            <label class="form-label"
                                                    for="exampleFormControlInput1"><?php echo e(translate('category')); ?> <?php echo e(translate('name')); ?>

                                                (<?php echo e(strtoupper($defaultLanguage)); ?>)</label>
                                            <input type="text" name="name[]" class="form-control" maxlength="255"
                                                    placeholder="<?php echo e(translate('New Category')); ?>" required>
                                        </div>
                                        <input type="hidden" name="lang[]" value="<?php echo e($defaultLanguage); ?>">
                                    <?php endif; ?>
                                    <input name="position" value="0" hidden>
                                    <div class="col-sm-6">
                                        <div>
                                            <div class="text-center mb-3">
                                                <img id="viewer" class="img--105" src="<?php echo e(asset('public/assets/admin/img/160x160/1.png')); ?>" alt="<?php echo e(translate('image')); ?>" />
                                            </div>
                                        </div>
                                        <label class="form-label text-capitalize"><?php echo e(translate('category image')); ?></label><small class="text-danger">* ( <?php echo e(translate('ratio')); ?>3:1 )</small>
                                        <div class="custom-file">
                                            <input type="file" name="image" id="customFileEg1" class="custom-file-input"
                                                    accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" required oninvalid="document.getElementById('en-link').click()">
                                            <label class="custom-file-label" for="customFileEg1"><?php echo e(translate('choose')); ?>

                                                <?php echo e(translate('file')); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="btn--container justify-content-end">
                                            <button type="reset" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                                            <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                                        </div>
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-lg-12">
                <div class="card">
                    <div class="card-header border-0">
                        <div class="card--header">
                            <h5 class="card-title"><?php echo e(translate('Category Table')); ?> <span class="badge badge-soft-secondary"><?php echo e($categories->total()); ?></span> </h5>
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group">
                                    <input id="datatableSearch_" type="search" name="search" maxlength="255"
                                           class="form-control pl-5"
                                           placeholder="<?php echo e(translate('Search_by_Name')); ?>" aria-label="Search"
                                           value="<?php echo e($search); ?>" required autocomplete="off">
                                           <i class="tio-search tio-input-search"></i>
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text">
                                            <?php echo e(translate('search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Table -->
                    <div class="table-responsive datatable-custom">
                        <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center"><?php echo e(translate('#')); ?></th>
                                <th><?php echo e(translate('category_image')); ?></th>
                                <th><?php echo e(translate('name')); ?></th>
                                <th><?php echo e(translate('status')); ?></th>
                                <th><?php echo e(translate('priority')); ?></th>
                                <th class="text-center"><?php echo e(translate('action')); ?></th>
                            </tr>
                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"><?php echo e($categories->firstItem()+$key); ?></td>
                                    <td>
                                        <img src="<?php echo e($category->imageFullPath); ?>" class="img--50 ml-3"
                                             alt="<?php echo e(translate('category')); ?>">
                                    </td>
                                    <td>
                                    <span class="d-block font-size-sm text-body text-trim-50">
                                        <?php echo e($category['name']); ?>

                                    </span>
                                    </td>
                                    <td>

                                        <label class="toggle-switch">
                                            <input type="checkbox"
                                                class="toggle-switch-input status-change-alert" id="stocksCheckbox<?php echo e($category->id); ?>"
                                                   data-route="<?php echo e(route('admin.category.status', [$category->id, $category->status ? 0 : 1])); ?>"
                                                   data-message="<?php echo e($category->status? translate('you_want_to_disable_this_category'): translate('you_want_to_active_this_category')); ?>"
                                                <?php echo e($category->status ? 'checked' : ''); ?>>
                                            <span class="toggle-switch-label text">
                                                <span class="toggle-switch-indicator"></span>
                                            </span>
                                        </label>

                                    </td>
                                    <td>
                                        <div class="max-85">
                                            <select name="priority" class="custom-select"
                                                    onchange="location.href='<?php echo e(route('admin.category.priority', ['id' => $category['id'], 'priority' => ''])); ?>' + this.value">
                                                <?php for($i = 1; $i <= 10; $i++): ?>
                                                    <option value="<?php echo e($i); ?>" <?php echo e($category->priority == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn--container justify-content-center">
                                            <a class="action-btn"
                                                href="<?php echo e(route('admin.category.edit',[$category['id']])); ?>">
                                            <i class="tio-edit"></i></a>
                                            <a class="action-btn btn--danger btn-outline-danger form-alert" href="javascript:"
                                               data-id="category-<?php echo e($category['id']); ?>"
                                               data-message="<?php echo e(translate("Want to delete this")); ?>?">
                                                <i class="tio-delete-outlined"></i>
                                            </a>
                                        </div>
                                        <form action="<?php echo e(route('admin.category.delete',[$category['id']])); ?>"
                                                method="post" id="category-<?php echo e($category['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>


                        <?php if(count($categories) == 0): ?>
                        <div class="text-center p-4">
                            <img class="w-120px mb-3" src="<?php echo e(asset('/public/assets/admin/svg/illustrations/sorry.svg')); ?>" alt="<?php echo e(translate('image')); ?>">
                            <p class="mb-0"><?php echo e(translate('No_data_to_show')); ?></p>
                        </div>
                        <?php endif; ?>

                        <table>
                            <tfoot>
                            <?php echo $categories->links(); ?>

                            </tfoot>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/category.js')); ?>"></script>
    <script>
        "use strict";

        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#"+lang+"-form").removeClass('d-none');
            if(lang == '<?php echo e($defaultLanguage); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forbuy/public_html/resources/views/admin-views/category/index.blade.php ENDPATH**/ ?>